package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type ImageSpriteTask struct {

	// 任务状态，包含成功，失败
	Status *string `json:"status,omitempty"`

	// 错误码
	ErrorCode *string `json:"error_code,omitempty"`

	// 错误信息
	ErrorMsg *string `json:"error_msg,omitempty"`

	Output *ImageSpriteTaskOutPut `json:"output,omitempty"`
}

func (o ImageSpriteTask) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ImageSpriteTask struct{}"
	}

	return strings.Join([]string{"ImageSpriteTask", string(data)}, " ")
}
