// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package docdbelastic

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateCluster
func (c *DocDBElastic) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/cluster",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon DocumentDB Elastic Clusters.
//
// Creates a new Elastic DocumentDB cluster and returns its Cluster structure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - ServiceQuotaExceededException
//     The service quota for the action was exceeded.
//
//   - ConflictException
//     There was an access conflict.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateCluster
func (c *DocDBElastic) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateClusterSnapshot = "CreateClusterSnapshot"

// CreateClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateClusterSnapshot for more information on using the CreateClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterSnapshotRequest method.
//	req, resp := client.CreateClusterSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateClusterSnapshot
func (c *DocDBElastic) CreateClusterSnapshotRequest(input *CreateClusterSnapshotInput) (req *request.Request, output *CreateClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateClusterSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/cluster-snapshot",
	}

	if input == nil {
		input = &CreateClusterSnapshotInput{}
	}

	output = &CreateClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateClusterSnapshot API operation for Amazon DocumentDB Elastic Clusters.
//
// Creates a snapshot of a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation CreateClusterSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - ServiceQuotaExceededException
//     The service quota for the action was exceeded.
//
//   - ConflictException
//     There was an access conflict.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/CreateClusterSnapshot
func (c *DocDBElastic) CreateClusterSnapshot(input *CreateClusterSnapshotInput) (*CreateClusterSnapshotOutput, error) {
	req, out := c.CreateClusterSnapshotRequest(input)
	return out, req.Send()
}

// CreateClusterSnapshotWithContext is the same as CreateClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) CreateClusterSnapshotWithContext(ctx aws.Context, input *CreateClusterSnapshotInput, opts ...request.Option) (*CreateClusterSnapshotOutput, error) {
	req, out := c.CreateClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterRequest method.
//	req, resp := client.DeleteClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteCluster
func (c *DocDBElastic) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cluster/{clusterArn}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon DocumentDB Elastic Clusters.
//
// Delete a Elastic DocumentDB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - ConflictException
//     There was an access conflict.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteCluster
func (c *DocDBElastic) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClusterSnapshot = "DeleteClusterSnapshot"

// DeleteClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClusterSnapshot for more information on using the DeleteClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterSnapshotRequest method.
//	req, resp := client.DeleteClusterSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteClusterSnapshot
func (c *DocDBElastic) DeleteClusterSnapshotRequest(input *DeleteClusterSnapshotInput) (req *request.Request, output *DeleteClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteClusterSnapshot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cluster-snapshot/{snapshotArn}",
	}

	if input == nil {
		input = &DeleteClusterSnapshotInput{}
	}

	output = &DeleteClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteClusterSnapshot API operation for Amazon DocumentDB Elastic Clusters.
//
// Delete a Elastic DocumentDB snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation DeleteClusterSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - ConflictException
//     There was an access conflict.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/DeleteClusterSnapshot
func (c *DocDBElastic) DeleteClusterSnapshot(input *DeleteClusterSnapshotInput) (*DeleteClusterSnapshotOutput, error) {
	req, out := c.DeleteClusterSnapshotRequest(input)
	return out, req.Send()
}

// DeleteClusterSnapshotWithContext is the same as DeleteClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) DeleteClusterSnapshotWithContext(ctx aws.Context, input *DeleteClusterSnapshotInput, opts ...request.Option) (*DeleteClusterSnapshotOutput, error) {
	req, out := c.DeleteClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCluster = "GetCluster"

// GetClusterRequest generates a "aws/request.Request" representing the
// client's request for the GetCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCluster for more information on using the GetCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetClusterRequest method.
//	req, resp := client.GetClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetCluster
func (c *DocDBElastic) GetClusterRequest(input *GetClusterInput) (req *request.Request, output *GetClusterOutput) {
	op := &request.Operation{
		Name:       opGetCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/cluster/{clusterArn}",
	}

	if input == nil {
		input = &GetClusterInput{}
	}

	output = &GetClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCluster API operation for Amazon DocumentDB Elastic Clusters.
//
// Returns information about a specific Elastic DocumentDB cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation GetCluster for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetCluster
func (c *DocDBElastic) GetCluster(input *GetClusterInput) (*GetClusterOutput, error) {
	req, out := c.GetClusterRequest(input)
	return out, req.Send()
}

// GetClusterWithContext is the same as GetCluster with the addition of
// the ability to pass a context and additional request options.
//
// See GetCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) GetClusterWithContext(ctx aws.Context, input *GetClusterInput, opts ...request.Option) (*GetClusterOutput, error) {
	req, out := c.GetClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClusterSnapshot = "GetClusterSnapshot"

// GetClusterSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetClusterSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClusterSnapshot for more information on using the GetClusterSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetClusterSnapshotRequest method.
//	req, resp := client.GetClusterSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetClusterSnapshot
func (c *DocDBElastic) GetClusterSnapshotRequest(input *GetClusterSnapshotInput) (req *request.Request, output *GetClusterSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetClusterSnapshot,
		HTTPMethod: "GET",
		HTTPPath:   "/cluster-snapshot/{snapshotArn}",
	}

	if input == nil {
		input = &GetClusterSnapshotInput{}
	}

	output = &GetClusterSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClusterSnapshot API operation for Amazon DocumentDB Elastic Clusters.
//
// # Returns information about a specific Elastic DocumentDB snapshot
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation GetClusterSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/GetClusterSnapshot
func (c *DocDBElastic) GetClusterSnapshot(input *GetClusterSnapshotInput) (*GetClusterSnapshotOutput, error) {
	req, out := c.GetClusterSnapshotRequest(input)
	return out, req.Send()
}

// GetClusterSnapshotWithContext is the same as GetClusterSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetClusterSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) GetClusterSnapshotWithContext(ctx aws.Context, input *GetClusterSnapshotInput, opts ...request.Option) (*GetClusterSnapshotOutput, error) {
	req, out := c.GetClusterSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusterSnapshots = "ListClusterSnapshots"

// ListClusterSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the ListClusterSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusterSnapshots for more information on using the ListClusterSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClusterSnapshotsRequest method.
//	req, resp := client.ListClusterSnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots
func (c *DocDBElastic) ListClusterSnapshotsRequest(input *ListClusterSnapshotsInput) (req *request.Request, output *ListClusterSnapshotsOutput) {
	op := &request.Operation{
		Name:       opListClusterSnapshots,
		HTTPMethod: "GET",
		HTTPPath:   "/cluster-snapshots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClusterSnapshotsInput{}
	}

	output = &ListClusterSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusterSnapshots API operation for Amazon DocumentDB Elastic Clusters.
//
// Returns information about Elastic DocumentDB snapshots for a specified cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation ListClusterSnapshots for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusterSnapshots
func (c *DocDBElastic) ListClusterSnapshots(input *ListClusterSnapshotsInput) (*ListClusterSnapshotsOutput, error) {
	req, out := c.ListClusterSnapshotsRequest(input)
	return out, req.Send()
}

// ListClusterSnapshotsWithContext is the same as ListClusterSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusterSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) ListClusterSnapshotsWithContext(ctx aws.Context, input *ListClusterSnapshotsInput, opts ...request.Option) (*ListClusterSnapshotsOutput, error) {
	req, out := c.ListClusterSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClusterSnapshotsPages iterates over the pages of a ListClusterSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusterSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusterSnapshots operation.
//	pageNum := 0
//	err := client.ListClusterSnapshotsPages(params,
//	    func(page *docdbelastic.ListClusterSnapshotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DocDBElastic) ListClusterSnapshotsPages(input *ListClusterSnapshotsInput, fn func(*ListClusterSnapshotsOutput, bool) bool) error {
	return c.ListClusterSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClusterSnapshotsPagesWithContext same as ListClusterSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) ListClusterSnapshotsPagesWithContext(ctx aws.Context, input *ListClusterSnapshotsInput, fn func(*ListClusterSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClusterSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClusterSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClusterSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClustersRequest method.
//	req, resp := client.ListClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters
func (c *DocDBElastic) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon DocumentDB Elastic Clusters.
//
// Returns information about provisioned Elastic DocumentDB clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListClusters
func (c *DocDBElastic) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusters operation.
//	pageNum := 0
//	err := client.ListClustersPages(params,
//	    func(page *docdbelastic.ListClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *DocDBElastic) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListTagsForResource
func (c *DocDBElastic) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon DocumentDB Elastic Clusters.
//
// # Lists all tags on a Elastic DocumentDB resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/ListTagsForResource
func (c *DocDBElastic) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreClusterFromSnapshot = "RestoreClusterFromSnapshot"

// RestoreClusterFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreClusterFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreClusterFromSnapshot for more information on using the RestoreClusterFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreClusterFromSnapshotRequest method.
//	req, resp := client.RestoreClusterFromSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/RestoreClusterFromSnapshot
func (c *DocDBElastic) RestoreClusterFromSnapshotRequest(input *RestoreClusterFromSnapshotInput) (req *request.Request, output *RestoreClusterFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreClusterFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/cluster-snapshot/{snapshotArn}/restore",
	}

	if input == nil {
		input = &RestoreClusterFromSnapshotInput{}
	}

	output = &RestoreClusterFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreClusterFromSnapshot API operation for Amazon DocumentDB Elastic Clusters.
//
// Restores a Elastic DocumentDB cluster from a snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation RestoreClusterFromSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - ServiceQuotaExceededException
//     The service quota for the action was exceeded.
//
//   - ConflictException
//     There was an access conflict.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/RestoreClusterFromSnapshot
func (c *DocDBElastic) RestoreClusterFromSnapshot(input *RestoreClusterFromSnapshotInput) (*RestoreClusterFromSnapshotOutput, error) {
	req, out := c.RestoreClusterFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreClusterFromSnapshotWithContext is the same as RestoreClusterFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreClusterFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) RestoreClusterFromSnapshotWithContext(ctx aws.Context, input *RestoreClusterFromSnapshotInput, opts ...request.Option) (*RestoreClusterFromSnapshotOutput, error) {
	req, out := c.RestoreClusterFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/TagResource
func (c *DocDBElastic) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon DocumentDB Elastic Clusters.
//
// # Adds metadata tags to a Elastic DocumentDB resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/TagResource
func (c *DocDBElastic) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UntagResource
func (c *DocDBElastic) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon DocumentDB Elastic Clusters.
//
// # Removes metadata tags to a Elastic DocumentDB resource
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UntagResource
func (c *DocDBElastic) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCluster = "UpdateCluster"

// UpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCluster for more information on using the UpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterRequest method.
//	req, resp := client.UpdateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UpdateCluster
func (c *DocDBElastic) UpdateClusterRequest(input *UpdateClusterInput) (req *request.Request, output *UpdateClusterOutput) {
	op := &request.Operation{
		Name:       opUpdateCluster,
		HTTPMethod: "PUT",
		HTTPPath:   "/cluster/{clusterArn}",
	}

	if input == nil {
		input = &UpdateClusterInput{}
	}

	output = &UpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCluster API operation for Amazon DocumentDB Elastic Clusters.
//
// Modifies a Elastic DocumentDB cluster. This includes updating admin-username/password,
// upgrading API version setting up a backup window and maintenance window
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DocumentDB Elastic Clusters's
// API operation UpdateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     ThrottlingException will be thrown when request was denied due to request
//     throttling.
//
//   - ValidationException
//     A structure defining a validation exception.
//
//   - ConflictException
//     There was an access conflict.
//
//   - InternalServerException
//     There was an internal server error.
//
//   - ResourceNotFoundException
//     The specified resource could not be located.
//
//   - AccessDeniedException
//     An exception that occurs when there are not sufficient permissions to perform
//     an action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/docdb-elastic-2022-11-28/UpdateCluster
func (c *DocDBElastic) UpdateCluster(input *UpdateClusterInput) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	return out, req.Send()
}

// UpdateClusterWithContext is the same as UpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DocDBElastic) UpdateClusterWithContext(ctx aws.Context, input *UpdateClusterInput, opts ...request.Option) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An exception that occurs when there are not sufficient permissions to perform
// an action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An error message explaining why access was denied.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns information about a specific Elastic DocumentDB cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic DocumentDB cluster administrator.
	//
	// AdminUserName is a required field
	AdminUserName *string `locationName:"adminUserName" type:"string" required:"true"`

	// The authentication type for the Elastic DocumentDB cluster.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"Auth"`

	// The arn of the Elastic DocumentDB cluster.
	//
	// ClusterArn is a required field
	ClusterArn *string `locationName:"clusterArn" type:"string" required:"true"`

	// The URL used to connect to the Elastic DocumentDB cluster.
	//
	// ClusterEndpoint is a required field
	ClusterEndpoint *string `locationName:"clusterEndpoint" type:"string" required:"true"`

	// The name of the Elastic DocumentDB cluster.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" type:"string" required:"true"`

	// The time when the Elastic DocumentDB cluster was created in Universal Coordinated
	// Time (UTC).
	//
	// CreateTime is a required field
	CreateTime *string `locationName:"createTime" type:"string" required:"true"`

	// The KMS key identifier to use to encrypt the Elastic DocumentDB cluster.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" type:"string" required:"true"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// PreferredMaintenanceWindow is a required field
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string" required:"true"`

	// The capacity of each shard in the Elastic DocumentDB cluster.
	//
	// ShardCapacity is a required field
	ShardCapacity *int64 `locationName:"shardCapacity" type:"integer" required:"true"`

	// The number of shards in the Elastic DocumentDB cluster.
	//
	// ShardCount is a required field
	ShardCount *int64 `locationName:"shardCount" type:"integer" required:"true"`

	// The status of the Elastic DocumentDB cluster.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`

	// The Amazon EC2 subnet IDs for the Elastic DocumentDB cluster.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`

	// A list of EC2 VPC security groups associated with this cluster.
	//
	// VpcSecurityGroupIds is a required field
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetAdminUserName sets the AdminUserName field's value.
func (s *Cluster) SetAdminUserName(v string) *Cluster {
	s.AdminUserName = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *Cluster) SetAuthType(v string) *Cluster {
	s.AuthType = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Cluster) SetClusterArn(v string) *Cluster {
	s.ClusterArn = &v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *Cluster) SetClusterEndpoint(v string) *Cluster {
	s.ClusterEndpoint = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Cluster) SetClusterName(v string) *Cluster {
	s.ClusterName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *Cluster) SetCreateTime(v string) *Cluster {
	s.CreateTime = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Cluster) SetKmsKeyId(v string) *Cluster {
	s.KmsKeyId = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Cluster) SetPreferredMaintenanceWindow(v string) *Cluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetShardCapacity sets the ShardCapacity field's value.
func (s *Cluster) SetShardCapacity(v int64) *Cluster {
	s.ShardCapacity = &v
	return s
}

// SetShardCount sets the ShardCount field's value.
func (s *Cluster) SetShardCount(v int64) *Cluster {
	s.ShardCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *Cluster) SetSubnetIds(v []*string) *Cluster {
	s.SubnetIds = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *Cluster) SetVpcSecurityGroupIds(v []*string) *Cluster {
	s.VpcSecurityGroupIds = v
	return s
}

// A list of Elastic DocumentDB cluster.
type ClusterInList struct {
	_ struct{} `type:"structure"`

	// The arn of the Elastic DocumentDB cluster.
	//
	// ClusterArn is a required field
	ClusterArn *string `locationName:"clusterArn" type:"string" required:"true"`

	// The name of the Elastic DocumentDB cluster.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" type:"string" required:"true"`

	// The status of the Elastic DocumentDB cluster.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterInList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterInList) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterInList) SetClusterArn(v string) *ClusterInList {
	s.ClusterArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ClusterInList) SetClusterName(v string) *ClusterInList {
	s.ClusterName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterInList) SetStatus(v string) *ClusterInList {
	s.Status = &v
	return s
}

// Returns information about a specific Elastic DocumentDB snapshot.
type ClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic DocumentDB cluster administrator.
	//
	// AdminUserName is a required field
	AdminUserName *string `locationName:"adminUserName" type:"string" required:"true"`

	// The arn of the Elastic DocumentDB cluster.
	//
	// ClusterArn is a required field
	ClusterArn *string `locationName:"clusterArn" type:"string" required:"true"`

	// The time when the Elastic DocumentDB cluster was created in Universal Coordinated
	// Time (UTC).
	//
	// ClusterCreationTime is a required field
	ClusterCreationTime *string `locationName:"clusterCreationTime" type:"string" required:"true"`

	// The KMS key identifier to use to encrypt the Elastic DocumentDB cluster.
	//
	// KmsKeyId is a required field
	KmsKeyId *string `locationName:"kmsKeyId" type:"string" required:"true"`

	// The arn of the Elastic DocumentDB snapshot
	//
	// SnapshotArn is a required field
	SnapshotArn *string `locationName:"snapshotArn" type:"string" required:"true"`

	// The time when the Elastic DocumentDB snapshot was created in Universal Coordinated
	// Time (UTC).
	//
	// SnapshotCreationTime is a required field
	SnapshotCreationTime *string `locationName:"snapshotCreationTime" type:"string" required:"true"`

	// The name of the Elastic DocumentDB snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`

	// The status of the Elastic DocumentDB snapshot.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`

	// A list of the IDs of subnets associated with the DB cluster snapshot.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`

	// A list of the IDs of the VPC security groups associated with the cluster
	// snapshot.
	//
	// VpcSecurityGroupIds is a required field
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterSnapshot) GoString() string {
	return s.String()
}

// SetAdminUserName sets the AdminUserName field's value.
func (s *ClusterSnapshot) SetAdminUserName(v string) *ClusterSnapshot {
	s.AdminUserName = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterSnapshot) SetClusterArn(v string) *ClusterSnapshot {
	s.ClusterArn = &v
	return s
}

// SetClusterCreationTime sets the ClusterCreationTime field's value.
func (s *ClusterSnapshot) SetClusterCreationTime(v string) *ClusterSnapshot {
	s.ClusterCreationTime = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ClusterSnapshot) SetKmsKeyId(v string) *ClusterSnapshot {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *ClusterSnapshot) SetSnapshotArn(v string) *ClusterSnapshot {
	s.SnapshotArn = &v
	return s
}

// SetSnapshotCreationTime sets the SnapshotCreationTime field's value.
func (s *ClusterSnapshot) SetSnapshotCreationTime(v string) *ClusterSnapshot {
	s.SnapshotCreationTime = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *ClusterSnapshot) SetSnapshotName(v string) *ClusterSnapshot {
	s.SnapshotName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterSnapshot) SetStatus(v string) *ClusterSnapshot {
	s.Status = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ClusterSnapshot) SetSubnetIds(v []*string) *ClusterSnapshot {
	s.SubnetIds = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ClusterSnapshot) SetVpcSecurityGroupIds(v []*string) *ClusterSnapshot {
	s.VpcSecurityGroupIds = v
	return s
}

// A list of Elastic DocumentDB snapshots.
type ClusterSnapshotInList struct {
	_ struct{} `type:"structure"`

	// The arn of the Elastic DocumentDB cluster.
	//
	// ClusterArn is a required field
	ClusterArn *string `locationName:"clusterArn" type:"string" required:"true"`

	// The arn of the Elastic DocumentDB snapshot
	//
	// SnapshotArn is a required field
	SnapshotArn *string `locationName:"snapshotArn" type:"string" required:"true"`

	// The time when the Elastic DocumentDB snapshot was created in Universal Coordinated
	// Time (UTC).
	//
	// SnapshotCreationTime is a required field
	SnapshotCreationTime *string `locationName:"snapshotCreationTime" type:"string" required:"true"`

	// The name of the Elastic DocumentDB snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`

	// The status of the Elastic DocumentDB snapshot.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterSnapshotInList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterSnapshotInList) GoString() string {
	return s.String()
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ClusterSnapshotInList) SetClusterArn(v string) *ClusterSnapshotInList {
	s.ClusterArn = &v
	return s
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *ClusterSnapshotInList) SetSnapshotArn(v string) *ClusterSnapshotInList {
	s.SnapshotArn = &v
	return s
}

// SetSnapshotCreationTime sets the SnapshotCreationTime field's value.
func (s *ClusterSnapshotInList) SetSnapshotCreationTime(v string) *ClusterSnapshotInList {
	s.SnapshotCreationTime = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *ClusterSnapshotInList) SetSnapshotName(v string) *ClusterSnapshotInList {
	s.SnapshotName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ClusterSnapshotInList) SetStatus(v string) *ClusterSnapshotInList {
	s.Status = &v
	return s
}

// There was an access conflict.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource where there was an access conflict.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource where there was an access conflict.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic DocumentDB cluster administrator.
	//
	// Constraints:
	//
	//    * Must be from 1 to 63 letters or numbers.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot be a reserved word.
	//
	// AdminUserName is a required field
	AdminUserName *string `locationName:"adminUserName" type:"string" required:"true"`

	// The password for the Elastic DocumentDB cluster administrator and can contain
	// any printable ASCII characters.
	//
	// Constraints:
	//
	//    * Must contain from 8 to 100 characters.
	//
	//    * Cannot contain a forward slash (/), double quote ("), or the "at" symbol
	//    (@).
	//
	// AdminUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateClusterInput's
	// String and GoString methods.
	//
	// AdminUserPassword is a required field
	AdminUserPassword *string `locationName:"adminUserPassword" type:"string" required:"true" sensitive:"true"`

	// The authentication type for the Elastic DocumentDB cluster.
	//
	// AuthType is a required field
	AuthType *string `locationName:"authType" type:"string" required:"true" enum:"Auth"`

	// The client token for the Elastic DocumentDB cluster.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the new Elastic DocumentDB cluster. This parameter is stored
	// as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: my-cluster
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" type:"string" required:"true"`

	// The KMS key identifier to use to encrypt the new Elastic DocumentDB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a cluster using the same Amazon account that owns
	// this KMS encryption key, you can use the KMS key alias instead of the ARN
	// as the KMS encryption key.
	//
	// If an encryption key is not specified, Elastic DocumentDB uses the default
	// encryption key that KMS creates for your account. Your account has a different
	// default encryption key for each Amazon Region.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: a 30-minute window selected at random from an 8-hour block of time
	// for each Amazon Web Services Region, occurring on a random day of the week.
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// The capacity of each shard in the new Elastic DocumentDB cluster.
	//
	// ShardCapacity is a required field
	ShardCapacity *int64 `locationName:"shardCapacity" type:"integer" required:"true"`

	// The number of shards to create in the new Elastic DocumentDB cluster.
	//
	// ShardCount is a required field
	ShardCount *int64 `locationName:"shardCount" type:"integer" required:"true"`

	// The Amazon EC2 subnet IDs for the new Elastic DocumentDB cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The tags to be assigned to the new Elastic DocumentDB cluster.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of EC2 VPC security groups to associate with the new Elastic DocumentDB
	// cluster.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.AdminUserName == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminUserName"))
	}
	if s.AdminUserPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("AdminUserPassword"))
	}
	if s.AuthType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthType"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ShardCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardCapacity"))
	}
	if s.ShardCount == nil {
		invalidParams.Add(request.NewErrParamRequired("ShardCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminUserName sets the AdminUserName field's value.
func (s *CreateClusterInput) SetAdminUserName(v string) *CreateClusterInput {
	s.AdminUserName = &v
	return s
}

// SetAdminUserPassword sets the AdminUserPassword field's value.
func (s *CreateClusterInput) SetAdminUserPassword(v string) *CreateClusterInput {
	s.AdminUserPassword = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *CreateClusterInput) SetAuthType(v string) *CreateClusterInput {
	s.AuthType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateClusterInput) SetClientToken(v string) *CreateClusterInput {
	s.ClientToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateClusterInput) SetKmsKeyId(v string) *CreateClusterInput {
	s.KmsKeyId = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateClusterInput) SetPreferredMaintenanceWindow(v string) *CreateClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetShardCapacity sets the ShardCapacity field's value.
func (s *CreateClusterInput) SetShardCapacity(v int64) *CreateClusterInput {
	s.ShardCapacity = &v
	return s
}

// SetShardCount sets the ShardCount field's value.
func (s *CreateClusterInput) SetShardCount(v int64) *CreateClusterInput {
	s.ShardCount = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateClusterInput) SetSubnetIds(v []*string) *CreateClusterInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateClusterInput) SetVpcSecurityGroupIds(v []*string) *CreateClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The new Elastic DocumentDB cluster that has been created.
	//
	// Cluster is a required field
	Cluster *Cluster `locationName:"cluster" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateClusterSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The arn of the Elastic DocumentDB cluster that the snapshot will be taken
	// from.
	//
	// ClusterArn is a required field
	ClusterArn *string `locationName:"clusterArn" type:"string" required:"true"`

	// The name of the Elastic DocumentDB snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" min:"1" type:"string" required:"true"`

	// The tags to be assigned to the new Elastic DocumentDB snapshot.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterSnapshotInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *CreateClusterSnapshotInput) SetClusterArn(v string) *CreateClusterSnapshotInput {
	s.ClusterArn = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateClusterSnapshotInput) SetSnapshotName(v string) *CreateClusterSnapshotInput {
	s.SnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterSnapshotInput) SetTags(v map[string]*string) *CreateClusterSnapshotInput {
	s.Tags = v
	return s
}

type CreateClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the new Elastic DocumentDB snapshot.
	//
	// Snapshot is a required field
	Snapshot *ClusterSnapshot `locationName:"snapshot" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateClusterSnapshotOutput) SetSnapshot(v *ClusterSnapshot) *CreateClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB cluster that is to be deleted.
	//
	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *DeleteClusterInput) SetClusterArn(v string) *DeleteClusterInput {
	s.ClusterArn = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the newly deleted Elastic DocumentDB cluster.
	//
	// Cluster is a required field
	Cluster *Cluster `locationName:"cluster" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteClusterSnapshotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB snapshot that is to be deleted.
	//
	// SnapshotArn is a required field
	SnapshotArn *string `location:"uri" locationName:"snapshotArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterSnapshotInput"}
	if s.SnapshotArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotArn"))
	}
	if s.SnapshotArn != nil && len(*s.SnapshotArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *DeleteClusterSnapshotInput) SetSnapshotArn(v string) *DeleteClusterSnapshotInput {
	s.SnapshotArn = &v
	return s
}

type DeleteClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the newly deleted Elastic DocumentDB snapshot.
	//
	// Snapshot is a required field
	Snapshot *ClusterSnapshot `locationName:"snapshot" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *DeleteClusterSnapshotOutput) SetSnapshot(v *ClusterSnapshot) *DeleteClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

type GetClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB cluster.
	//
	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *GetClusterInput) SetClusterArn(v string) *GetClusterInput {
	s.ClusterArn = &v
	return s
}

type GetClusterOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about a specific Elastic DocumentDB cluster.
	//
	// Cluster is a required field
	Cluster *Cluster `locationName:"cluster" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *GetClusterOutput) SetCluster(v *Cluster) *GetClusterOutput {
	s.Cluster = v
	return s
}

type GetClusterSnapshotInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB snapshot.
	//
	// SnapshotArn is a required field
	SnapshotArn *string `location:"uri" locationName:"snapshotArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClusterSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClusterSnapshotInput"}
	if s.SnapshotArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotArn"))
	}
	if s.SnapshotArn != nil && len(*s.SnapshotArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *GetClusterSnapshotInput) SetSnapshotArn(v string) *GetClusterSnapshotInput {
	s.SnapshotArn = &v
	return s
}

type GetClusterSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about a specific Elastic DocumentDB snapshot.
	//
	// Snapshot is a required field
	Snapshot *ClusterSnapshot `locationName:"snapshot" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClusterSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *GetClusterSnapshotOutput) SetSnapshot(v *ClusterSnapshot) *GetClusterSnapshotOutput {
	s.Snapshot = v
	return s
}

// There was an internal server error.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListClusterSnapshotsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB cluster.
	ClusterArn *string `location:"querystring" locationName:"clusterArn" type:"string"`

	// The maximum number of entries to recieve in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"20" type:"integer"`

	// The nextToken which is used the get the next page of data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClusterSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClusterSnapshotsInput"}
	if s.MaxResults != nil && *s.MaxResults < 20 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterArn sets the ClusterArn field's value.
func (s *ListClusterSnapshotsInput) SetClusterArn(v string) *ListClusterSnapshotsInput {
	s.ClusterArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClusterSnapshotsInput) SetMaxResults(v int64) *ListClusterSnapshotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterSnapshotsInput) SetNextToken(v string) *ListClusterSnapshotsInput {
	s.NextToken = &v
	return s
}

type ListClusterSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// The response will provide a nextToken if there is more data beyond the maxResults.
	//
	// If there is no more data in the responce, the nextToken will not be returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of Elastic DocumentDB snapshots for a specified cluster.
	Snapshots []*ClusterSnapshotInList `locationName:"snapshots" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClusterSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListClusterSnapshotsOutput) SetNextToken(v string) *ListClusterSnapshotsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *ListClusterSnapshotsOutput) SetSnapshots(v []*ClusterSnapshotInList) *ListClusterSnapshotsOutput {
	s.Snapshots = v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of entries to recieve in the response.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken which is used the get the next page of data.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of Elastic DocumentDB cluster.
	Clusters []*ClusterInList `locationName:"clusters" type:"list"`

	// The response will provide a nextToken if there is more data beyond the maxResults.
	//
	// If there is no more data in the responce, the nextToken will not be returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *ListClustersOutput) SetClusters(v []*ClusterInList) *ListClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags for the specified Elastic DocumentDB resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified resource could not be located.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// An error message describing the failure.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that could not be located.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that could not be found.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreClusterFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elastic DocumentDB cluster.
	//
	// ClusterName is a required field
	ClusterName *string `locationName:"clusterName" type:"string" required:"true"`

	// The KMS key identifier to use to encrypt the new Elastic DocumentDB cluster.
	//
	// The KMS key identifier is the Amazon Resource Name (ARN) for the KMS encryption
	// key. If you are creating a cluster using the same Amazon account that owns
	// this KMS encryption key, you can use the KMS key alias instead of the ARN
	// as the KMS encryption key.
	//
	// If an encryption key is not specified here, Elastic DocumentDB uses the default
	// encryption key that KMS creates for your account. Your account has a different
	// default encryption key for each Amazon Region.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The arn of the Elastic DocumentDB snapshot.
	//
	// SnapshotArn is a required field
	SnapshotArn *string `location:"uri" locationName:"snapshotArn" type:"string" required:"true"`

	// The Amazon EC2 subnet IDs for the Elastic DocumentDB cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// A list of the tag names to be assigned to the restored DB cluster, in the
	// form of an array of key-value pairs in which the key is the tag name and
	// the value is the key value.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of EC2 VPC security groups to associate with the Elastic DocumentDB
	// cluster.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreClusterFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreClusterFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreClusterFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreClusterFromSnapshotInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.SnapshotArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotArn"))
	}
	if s.SnapshotArn != nil && len(*s.SnapshotArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *RestoreClusterFromSnapshotInput) SetClusterName(v string) *RestoreClusterFromSnapshotInput {
	s.ClusterName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *RestoreClusterFromSnapshotInput) SetKmsKeyId(v string) *RestoreClusterFromSnapshotInput {
	s.KmsKeyId = &v
	return s
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *RestoreClusterFromSnapshotInput) SetSnapshotArn(v string) *RestoreClusterFromSnapshotInput {
	s.SnapshotArn = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *RestoreClusterFromSnapshotInput) SetSubnetIds(v []*string) *RestoreClusterFromSnapshotInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestoreClusterFromSnapshotInput) SetTags(v map[string]*string) *RestoreClusterFromSnapshotInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *RestoreClusterFromSnapshotInput) SetVpcSecurityGroupIds(v []*string) *RestoreClusterFromSnapshotInput {
	s.VpcSecurityGroupIds = v
	return s
}

type RestoreClusterFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about a the restored Elastic DocumentDB cluster.
	//
	// Cluster is a required field
	Cluster *Cluster `locationName:"cluster" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreClusterFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreClusterFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RestoreClusterFromSnapshotOutput) SetCluster(v *Cluster) *RestoreClusterFromSnapshotOutput {
	s.Cluster = v
	return s
}

// The service quota for the action was exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The arn of the Elastic DocumentDB resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tags to be assigned to the Elastic DocumentDB resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// ThrottlingException will be thrown when request was denied due to request
// throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the operation.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The arn of the Elastic DocumentDB resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag keys to be removed from the Elastic DocumentDB resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The password for the Elastic DocumentDB cluster administrator. This password
	// can contain any printable ASCII character except forward slash (/), double
	// quote ("), or the "at" symbol (@).
	//
	// Constraints: Must contain from 8 to 100 characters.
	//
	// AdminUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateClusterInput's
	// String and GoString methods.
	AdminUserPassword *string `locationName:"adminUserPassword" type:"string" sensitive:"true"`

	// The authentication type for the Elastic DocumentDB cluster.
	AuthType *string `locationName:"authType" type:"string" enum:"Auth"`

	// The client token for the Elastic DocumentDB cluster.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The arn of the Elastic DocumentDB cluster.
	//
	// ClusterArn is a required field
	ClusterArn *string `location:"uri" locationName:"clusterArn" type:"string" required:"true"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: a 30-minute window selected at random from an 8-hour block of time
	// for each Amazon Web Services Region, occurring on a random day of the week.
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `locationName:"preferredMaintenanceWindow" type:"string"`

	// The capacity of each shard in the Elastic DocumentDB cluster.
	ShardCapacity *int64 `locationName:"shardCapacity" type:"integer"`

	// The number of shards to create in the Elastic DocumentDB cluster.
	ShardCount *int64 `locationName:"shardCount" type:"integer"`

	// The number of shards to create in the Elastic DocumentDB cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// A list of EC2 VPC security groups to associate with the new Elastic DocumentDB
	// cluster.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterInput"}
	if s.ClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterArn"))
	}
	if s.ClusterArn != nil && len(*s.ClusterArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminUserPassword sets the AdminUserPassword field's value.
func (s *UpdateClusterInput) SetAdminUserPassword(v string) *UpdateClusterInput {
	s.AdminUserPassword = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *UpdateClusterInput) SetAuthType(v string) *UpdateClusterInput {
	s.AuthType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateClusterInput) SetClientToken(v string) *UpdateClusterInput {
	s.ClientToken = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *UpdateClusterInput) SetClusterArn(v string) *UpdateClusterInput {
	s.ClusterArn = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *UpdateClusterInput) SetPreferredMaintenanceWindow(v string) *UpdateClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetShardCapacity sets the ShardCapacity field's value.
func (s *UpdateClusterInput) SetShardCapacity(v int64) *UpdateClusterInput {
	s.ShardCapacity = &v
	return s
}

// SetShardCount sets the ShardCount field's value.
func (s *UpdateClusterInput) SetShardCount(v int64) *UpdateClusterInput {
	s.ShardCount = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateClusterInput) SetSubnetIds(v []*string) *UpdateClusterInput {
	s.SubnetIds = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *UpdateClusterInput) SetVpcSecurityGroupIds(v []*string) *UpdateClusterInput {
	s.VpcSecurityGroupIds = v
	return s
}

type UpdateClusterOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about the updated Elastic DocumentDB cluster.
	//
	// Cluster is a required field
	Cluster *Cluster `locationName:"cluster" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterOutput) SetCluster(v *Cluster) *UpdateClusterOutput {
	s.Cluster = v
	return s
}

// A structure defining a validation exception.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A list of the fields in which the validation exception occurred.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// An error message describing the validation exception.
	Message_ *string `locationName:"message" type:"string"`

	// The reason why the validation exception occurred (one of unknownOperation,
	// cannotParse, fieldValidationFailed, or other).
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A specific field in which a given validation exception occurred.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// An error message describing the validation exception in this field.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the field where the validation exception occurred.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AuthPlainText is a Auth enum value
	AuthPlainText = "PLAIN_TEXT"

	// AuthSecretArn is a Auth enum value
	AuthSecretArn = "SECRET_ARN"
)

// Auth_Values returns all elements of the Auth enum
func Auth_Values() []string {
	return []string{
		AuthPlainText,
		AuthSecretArn,
	}
}

const (
	// StatusCreating is a Status enum value
	StatusCreating = "CREATING"

	// StatusActive is a Status enum value
	StatusActive = "ACTIVE"

	// StatusDeleting is a Status enum value
	StatusDeleting = "DELETING"

	// StatusUpdating is a Status enum value
	StatusUpdating = "UPDATING"

	// StatusVpcEndpointLimitExceeded is a Status enum value
	StatusVpcEndpointLimitExceeded = "VPC_ENDPOINT_LIMIT_EXCEEDED"

	// StatusIpAddressLimitExceeded is a Status enum value
	StatusIpAddressLimitExceeded = "IP_ADDRESS_LIMIT_EXCEEDED"

	// StatusInvalidSecurityGroupId is a Status enum value
	StatusInvalidSecurityGroupId = "INVALID_SECURITY_GROUP_ID"

	// StatusInvalidSubnetId is a Status enum value
	StatusInvalidSubnetId = "INVALID_SUBNET_ID"

	// StatusInaccessibleEncryptionCreds is a Status enum value
	StatusInaccessibleEncryptionCreds = "INACCESSIBLE_ENCRYPTION_CREDS"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusCreating,
		StatusActive,
		StatusDeleting,
		StatusUpdating,
		StatusVpcEndpointLimitExceeded,
		StatusIpAddressLimitExceeded,
		StatusInvalidSecurityGroupId,
		StatusInvalidSubnetId,
		StatusInaccessibleEncryptionCreds,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
