;
;	*****RSWITCH.ASM task switching code for Borland C++ 4.0 32-bit PM.
;
;
;       Derived from Borland 16-bit and Intel CodeBuilder versions.
;	14-Aug-94 ... MBE
;
;   Coswitch algorithm in C:
;
;   coswitch( old_cs, new_cs, first )
;   int	*old_cs, *new_cs, first;
;   {
;	/* save SP, frame pointers, and other registers in old_cs */
;	if ( first == 0 ) {
;	    /* load sp from new_sp[0] and clear frame pointers */
;	    new_context((int)0, (dptr)0 );
;	    syserr( "new_context() returned in coswitch" );
;	    }
;	else {
;	    /* load sp, frame pointers and other registers from new_cs */
;	    }
;   }

	.386
rsw	struc
rsw_eip	dd	?		; return eip
rsw_ocs	dd	?		; old_cs
rsw_ncs	dd	?		; new_cs
rsw_fst	dd	?		; first
rsw	ends

cstate	struc
csp	dd	?		; save esp
cbp	dd	?		; save ebp
csi	dd	?		; save esi
cdi	dd	?		; save edi
cbx	dd	?		; save dbx
cstate	ends

DGROUP	group	_DATA
	assume	cs:_TEXT,ds:DGROUP

_DATA	segment dword public use32 'DATA'
msg	db	'new_context() returned in coswitch',0
_DATA	ends

	extrn	_new_context:near
	extrn	_syserr:near

_TEXT segment byte public use32 'CODE'

	public	_coswitch

_coswitch proc	near

; /* save SP, frame pointers, and other registers in old_cs */
	mov	edx,rsw_ocs[esp]  ; point to old_cs
	mov	csp[edx],esp	  ; save esp
	mov	cbp[edx],ebp	  ; save ebp
	mov	csi[edx],esi	  ; save esi
	mov	cdi[edx],edi      ; save edi
	mov	cbx[edx],ebx	  ; save ebx


; if ( first == 0 ) {
	cmp	rsw_fst[esp],0
	jnz	notzero

;    /* First is 0. */
;    /* Set things up for first activation of this coexpression */
	mov	edx,rsw_ncs[esp]    ; point to new_cs area
	mov	esp,csp[edx]	    ; set ESP from new_cs
	mov	ebp,esp		    ; set EBP equal to ESP
	xor	ebx,ebx		    ; clear EBX
	xor	esi,esi		    ; clear ESI
	xor	edi,edi		    ; clear EDI

;   new_context((int)0, (dptr)0 );
	push	esi		    ; push two zeros
	push	esi		    ;   onto stack
	call	_new_context	    ; new_context(0,0) - should not return!

;   syserr( "new_context() returned in coswitch" );
;   }
	push	offset msg	    ; push offset to error messgae
	call	_syserr		    ; terminate with error
				    ;  (call doesn't return)


;   else {
;      /* load sp, frame pointers and other registers from new_cs */
;      }
notzero:
	mov	edx,rsw_ncs[esp]    ; point to new_cs
	mov	esp,csp[edx]	    ; restore esp
	mov	ebp,cbp[edx]	    ; restore ebp
	mov	esi,csi[edx]	    ; restore esi
	mov	edi,cdi[edx]	    ; restore edi
	mov	ebx,cbx[edx]	    ; restore ebx
	ret			    ; return

_coswitch endp
_TEXT	ends
	end
