;  Rover.Asm
;
;  Integer Arithmetic Overflow for Macintosh Icon.
;  Consulair MDS assembler & LightSpeed C.
;  Lightspeed C reserves registers D3-D7, A2-A7 for register variables
;  and system pointers.  Registers D0-D2, A0-A1 are scratch.
;  Mac ToolBox destroys D0-D2, A0-A1.
;
;
	INCLUDE Traps.Txt
	
	XREF	fatalerr

	XDEF	ckadd,cksub,ckmul

;
;  ckadd -- Long integer addition with overflow check.
;
ckadd
	MOVE.L	4(SP),D0	;Get first operand
	ADD.L	8(SP),D0	;Add second operand
	BVS.S	oflow		;Jump if overflow
	RTS			;Return

;
;  cksub -- Long integer subtraction with overflow check.
;
cksub
	MOVE.L	4(SP),D0	;Get first operand
	SUB.L	8(SP),D0	;Subtract second operand
	BVS.S	oflow		;Jump if overflow
	RTS			;Return

;
;  Come here if overflow detected -- terminate Icon run with
;  run error 203 -- integer overflow.
;
oflow
	MOVE.L	#0,-(SP)	;Push NULL
	MOVE.W	#-203,-(SP)	;Push error code -203
	JSR	fatalerr	;Go terminate the run

;
;  ckmul -- Long integer multiplication with overflow check.
;
ckmul
;
;  Call the Macintosh toolbox procedure LongMul to do 64
;  bit multiplication.
;
	MOVE.L	4(SP),-(SP)	;Push first operand
	MOVE.L	12(SP),-(SP)	;Push second operand
	PEA	product(A5)	;Push address for result on stack
	_LongMul		;Call toolbox LongMul (Pascal conventions)
	MOVE.L	product+4(A5),D0;Get low 32 bits of result
;
;  Check for 32 bit overflow.
;
	MOVE.L	product+0(A5),D1;Get the high 32 bits of result
	TST.L	D0		;Test sign of result
	BPL.S	@1		;Jump if positive
	NOT.L	D1		;Else flip bits of high 32 bits
@1	TST.L	D1		;Test high 32 bits
	BNE.S	oflow		;Jump if not all zero -- overflow
	RTS			;Return

;
;  Data for ckmul
;
product	DS.L	2		;Location for 64-bit result of LongMul


	END
