;
;  Co-expression context switch for Macintosh Icon
;
;  Consulair MDS assembler & LightSpeed C.
;  Lightspeed C reserves registers D3-D7, A2-A7 for register variables
;  and system pointers.  Registers D0-D2, A0-A1 are scratch.
;  Mac ToolBox destroys D0-D2, A0-A1.
;
	INCLUDE	SysEqu.Txt
	
	XREF	interp,syserr
	
	XDEF	coswitch, ResetStack

;
;  Save registers of the co-expression being deactivated.
;
coswitch
	MOVE.L	4(SP),A0		;Get address of old task's registers
	MOVE.L	8(SP),A1		;Get address of new task's registers
	MOVE.L	SP,(A0)+		;Stack pointer must be in state[0]
	MOVEM.L	D3-D7/A2-A6,(A0)	;Save remaining registers
	TST.L	12(SP)			;Check whether this is first activation
	BNE.S	not_first		;Jump if not first
;
;  Come here for co-expression's first activation.  Set the stack
;  pointer to its stack and call interp.
first
	MOVE.L	#0,StkLowPt		;Disable Mac's "stack sniffer"
	MOVE.L	(A1),SP			;Get new stack pointer from state[0]
	MOVE.L	#0,-(SP)		;Set up args for interp
	MOVE.L	#0,-(SP)		; ...
	JSR	interp			;Call interp
	ADD.L	#8,SP			;Pop args off stack
;
;  We should never get here, but just in case ...
;
	PEA	errmsg
	JSR	syserr			;System error
;
; Come here if not the first activation.  Restore registers and return.
;
not_first
	MOVEM.L	(A1)+,SP		;Restore stack pointer
	MOVEM.L	(A1),D3-D7/A2-A6	;Restore rest of registers
	RTS				;Return

;
;  This routine is called at the end of an Icon run.  It re-enables
;  the "stack sniffer".
;
ResetStack
	MOVE.L	SP,StkLowPt
	RTS

;  Data for Rswitch
errmsg	dc.b	'interp() returned in coswitch()'
	END
