package ht.sr.git.whereswaldon.niotify;

import android.content.Context;
import android.content.Intent;
import android.app.PendingIntent;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.util.Log;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.os.Build;

public class NotificationHelper {
    private final static String tag = "NotificationHelper";
    public static void newChannel(Context ctx, int importance, String channelID, String name, String description) {
        NotificationChannel channel = new NotificationChannel(channelID, name, importance);
        channel.setDescription(description);

        NotificationManager notificationManager = ctx.getSystemService(NotificationManager.class);
        notificationManager.createNotificationChannel(channel);
    }
    public static void sendNotification(Context ctx, String channelID, int notificationID, String title, String text, boolean onGoing) throws ClassNotFoundException{
        Intent resultIntent = new Intent(ctx, Class.forName("org.gioui.GioActivity"));
        PendingIntent pending = null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            pending = PendingIntent.getActivity(ctx, notificationID, resultIntent, PendingIntent.FLAG_IMMUTABLE);
        } else {
            pending = PendingIntent.getActivity(ctx, notificationID, resultIntent, Intent.FLAG_ACTIVITY_CLEAR_TASK);
        }
        Bitmap bitmap = Bitmap.createBitmap(data, 0, width, width, height, Bitmap.Config.ARGB_8888);
        Notification.Builder builder = new Notification.Builder(ctx, channelID)
                .setContentTitle(title)
                .setSmallIcon(Icon.createWithBitmap(bitmap))
                .setContentText(text)
                .setContentIntent(pending)
                .setOngoing(onGoing);

        NotificationManager notificationManager = ctx.getSystemService(NotificationManager.class);
        notificationManager.notify(notificationID, builder.build());
    }
    public static void cancelNotification(Context ctx, int notificationID) {
        NotificationManager notificationManager = ctx.getSystemService(NotificationManager.class);
        notificationManager.cancel(notificationID);
    }
    // Gio logo image data
	private static int height = 64;
	private static int width = 57;
	private static int[] data = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,520093696,2063597568,-738197504,-251658240,2013265920,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,268435456,1677721600,-1056964608,-33554432,-16777216,-16777216,-16777216,-33554432,402653184,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,989855744,-1476395008,-150994944,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-335544320,150994944,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83886080,1509949440,-905969664,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-100663296,-1358954496,721420288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,100663296,1761607680,-503316480,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-33554432,-1056964608,1744830464,318767104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,83886080,1577058304,-603979776,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-268435456,-1728053248,721420288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1308622848,-620756992,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-587202560,1744830464,167772160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,671088640,-1207959552,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-704643072,1543503872,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117440512,-2046820352,-100663296,-16777216,-16777216,-16777216,-16777216,-16777216,-452984832,1677721600,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,822083584,-771751936,-16777216,-16777216,-16777216,-16777216,-16777216,-167772160,2113929216,184549376,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,2097152000,-100663296,-16777216,-16777216,-16777216,-16777216,-16777216,-1191182336,603979776,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,352321536,-1157627904,-16777216,-16777216,-16777216,-16777216,-16777216,-268435456,1543503872,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,922746880,-503316480,-16777216,-16777216,-16777216,-16777216,-16777216,-1040187392,520093696,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1342177280,-167772160,-16777216,-16777216,-16777216,-16777216,-33554432,-2113929216,50331648,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1644167168,-83886080,-16777216,-16777216,-16777216,-16777216,-150994944,1543503872,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1996488704,-16777216,-16777216,-16777216,-16777216,-16777216,-452984832,889192448,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1828716544,-16777216,-16777216,-16777216,-16777216,-16777216,-603979776,486539264,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1627389952,-33554432,-16777216,-16777216,-16777216,-16777216,-553648128,520093696,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,973078528,-117440512,-16777216,-16777216,-16777216,-16777216,-486539264,570425344,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,452984832,-419430400,-16777216,-16777216,-16777216,-16777216,-268435456,637534208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,-973078528,-16777216,-16777216,-16777216,-16777216,-33554432,1358954496,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2063597568,-16777216,-16777216,-16777216,-16777216,-16777216,-1962934272,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,637534208,-134217728,-16777216,-16777216,-16777216,-16777216,-1006632960,83886080,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1308622848,-16777216,-16777216,-16777216,-16777216,-117440512,687865856,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1023410176,-16777216,-16777216,-16777216,-16777216,-16777216,-2030043136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1191182336,-16777216,-16777216,-16777216,-16777216,-268435456,285212672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,822083584,-16777216,-16777216,-16777216,-16777216,-16777216,-2097152000,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1711276032,-16777216,-16777216,-16777216,-16777216,-33554432,570425344,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,201326592,-218103808,-16777216,-16777216,-16777216,-16777216,-1090519040,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1476395008,-16777216,-16777216,-16777216,-16777216,-16777216,1610612736,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1426063360,-16777216,-16777216,-16777216,-16777216,-33554432,301989888,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,-268435456,-16777216,-16777216,-16777216,-16777216,-603979776,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,889192448,-16777216,-16777216,-16777216,-16777216,-16777216,-1476395008,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1862270976,-16777216,-16777216,-16777216,-16777216,-16777216,1979711488,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1694498816,-16777216,-16777216,-16777216,-16777216,-16777216,1493172224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-989855744,-16777216,-16777216,-16777216,-16777216,-16777216,1191182336,0,0,0,0,0,0,0,0,0,0,0,0,0,1157627904,-1258291200,1023410176,0,0,0,0,0,0,0,0,0,402653184,-2147483648,-1056964608,-738197504,-855638016,-1593835520,1275068416,16777216,0,0,0,0,436207616,-889192448,-100663296,-1107296256,1493172224,67108864,0,0,0,0,0,0,0,-570425344,-16777216,-16777216,-16777216,-16777216,-16777216,939524096,0,0,0,0,0,0,0,0,0,0,0,0,0,-637534208,-16777216,-637534208,16777216,0,0,0,0,0,0,0,1056964608,-352321536,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-1107296256,335544320,0,0,0,-2147483648,-16777216,-16777216,-16777216,-16777216,-687865856,1191182336,0,0,0,0,0,0,-251658240,-16777216,-16777216,-16777216,-16777216,-16777216,1073741824,0,0,0,0,0,0,0,0,0,0,0,0,0,-134217728,-16777216,-16777216,905969664,0,0,0,0,0,0,637534208,-234881024,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-1023410176,33554432,0,0,1593835520,-16777216,-16777216,-16777216,-16777216,-16777216,-33554432,-1744830464,201326592,0,0,0,0,-150994944,-16777216,-16777216,-16777216,-16777216,-16777216,1308622848,0,0,0,0,0,0,0,0,0,0,0,0,117440512,-16777216,-16777216,-16777216,-2030043136,0,0,0,0,0,0,-1258291200,-16777216,-16777216,-184549376,1442840576,-905969664,-16777216,-16777216,-16777216,-16777216,-16777216,1342177280,0,0,16777216,1761607680,-671088640,-16777216,-16777216,-16777216,-16777216,-16777216,-922746880,268435456,0,0,0,-385875968,-16777216,-16777216,-16777216,-16777216,-16777216,1677721600,0,0,0,0,0,0,0,0,0,0,0,0,335544320,-16777216,-16777216,-16777216,-671088640,0,0,0,0,0,536870912,-50331648,-16777216,-16777216,-2097152000,0,855638016,-16777216,-16777216,-16777216,-16777216,-16777216,-1879048192,0,0,0,0,16777216,1476395008,-369098752,-16777216,-16777216,-16777216,-16777216,-872415232,218103808,0,0,-620756992,-16777216,-16777216,-16777216,-16777216,-16777216,-1744830464,0,0,0,0,0,0,0,0,0,0,0,0,620756992,-16777216,-16777216,-16777216,-16777216,822083584,0,0,0,0,1543503872,-16777216,-16777216,-16777216,1023410176,0,16777216,-201326592,-16777216,-16777216,-16777216,-16777216,-1711276032,0,0,0,0,0,0,536870912,-754974720,-16777216,-16777216,-16777216,-16777216,-1694498816,0,0,-905969664,-16777216,-16777216,-16777216,-16777216,-16777216,-805306368,0,0,0,0,0,0,0,0,0,0,0,0,1006632960,-16777216,-16777216,-16777216,-16777216,-1996488704,0,0,0,0,1946157056,-16777216,-16777216,-16777216,1291845632,0,167772160,-67108864,-16777216,-16777216,-16777216,-16777216,-2097152000,0,0,0,0,0,0,0,436207616,-486539264,-16777216,-16777216,-16777216,-33554432,1241513984,0,-1694498816,-16777216,-16777216,-16777216,-16777216,-16777216,-67108864,352321536,0,0,0,0,0,0,0,0,0,0,0,1258291200,-16777216,-16777216,-16777216,-16777216,-587202560,0,0,0,0,1610612736,-16777216,-16777216,-16777216,-251658240,-1174405120,-637534208,-16777216,-16777216,-16777216,-16777216,-16777216,1191182336,0,0,0,0,0,0,0,0,1241513984,-16777216,-16777216,-16777216,-16777216,-738197504,16777216,1677721600,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,1895825408,0,0,0,0,0,0,0,0,0,0,0,1375731712,-16777216,-16777216,-16777216,-16777216,-16777216,419430400,0,0,0,369098752,-83886080,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-671088640,33554432,0,0,0,0,0,0,0,0,0,-872415232,-16777216,-16777216,-16777216,-16777216,1090519040,771751936,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-486539264,134217728,0,0,0,0,0,0,0,0,0,0,1006632960,-16777216,-16777216,-16777216,-16777216,-436207616,100663296,0,0,0,0,-2030043136,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-67108864,1124073472,0,0,0,0,0,0,0,0,0,0,-2013265920,-16777216,-16777216,-16777216,-16777216,-1593835520,50331648,-335544320,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-2080374784,0,0,0,0,0,0,0,0,0,0,0,-2046820352,-16777216,-16777216,-16777216,1577058304,0,0,0,0,0,50331648,-1962934272,-33554432,-16777216,-16777216,-16777216,-16777216,-16777216,-167772160,1577058304,0,0,0,0,0,0,0,0,0,0,0,1778384896,-16777216,-16777216,-16777216,-16777216,-754974720,0,-1711276032,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-83886080,939524096,0,0,0,0,0,0,0,0,0,0,0,1795162112,-67108864,-1207959552,0,0,0,0,0,0,0,0,687865856,-1929379840,-905969664,-587202560,-922746880,-1962934272,570425344,0,0,0,0,0,0,0,0,0,0,0,0,-1962934272,-16777216,-16777216,-16777216,-16777216,-218103808,0,973078528,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-419430400,637534208,0,0,0,0,0,0,0,0,0,0,0,1090519040,285212672,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,-570425344,-16777216,-16777216,-16777216,-16777216,-234881024,0,0,-905969664,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-469762048,721420288,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1912602624,-16777216,-16777216,-16777216,-16777216,-16777216,-570425344,0,0,1241513984,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-201326592,1560281088,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1375731712,-117440512,-16777216,-16777216,-16777216,-16777216,-16777216,-1392508928,0,0,0,-1191182336,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-1258291200,570425344,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33554432,1979711488,-83886080,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,1627389952,0,0,0,503316480,-268435456,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-117440512,-1761607680,520093696,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1174405120,-922746880,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-251658240,201326592,0,0,0,0,1342177280,-50331648,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-67108864,-1291845632,1375731712,201326592,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16777216,805306368,1996488704,-721420288,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,1946157056,0,0,0,0,0,0,1845493760,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-134217728,-1157627904,1912602624,721420288,67108864,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167772160,973078528,1845493760,-1526726656,-385875968,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-822083584,83886080,0,0,0,0,0,0,0,2080374784,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-117440512,-805306368,-1526726656,2097152000,1728053248,1375731712,1140850688,1140850688,1140850688,1157627904,1509949440,1845493760,-2013265920,-1358954496,-671088640,-83886080,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-301989888,587202560,0,0,0,0,0,0,0,0,0,1728053248,-67108864,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-184549376,1073741824,0,0,0,0,0,0,0,0,0,0,0,1174405120,-402653184,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-234881024,1140850688,0,0,0,0,0,0,0,0,0,0,0,0,0,402653184,-1224736768,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-587202560,771751936,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1291845632,-553648128,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-33554432,-1728053248,218103808,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,167772160,1862270976,-553648128,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-704643072,973078528,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67108864,1476395008,-855638016,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-452984832,1795162112,100663296,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,822083584,-2063597568,-637534208,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-67108864,-1090519040,1509949440,117440512,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,805306368,-2130706432,-1124073472,-234881024,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-16777216,-352321536,-1375731712,1627389952,335544320,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,50331648,738197504,1677721600,-1778384896,-1241513984,-721420288,-402653184,-150994944,-83886080,-301989888,-452984832,-822083584,-1409286144,-1979711488,1593835520,654311424,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
}
