/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Arguments;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeCallPrototype;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public final class NativeCall
extends ScriptableObject {
    NativeCall caller;
    NativeFunction funObj;
    Scriptable thisObj;
    private Object[] originalArgs;

    static void init(Context cx, Scriptable scope, boolean sealed) {
        new NativeCallPrototype(cx, scope, sealed);
    }

    NativeCall() {
    }

    NativeCall(Context cx, Scriptable scope, NativeFunction funObj, Scriptable thisObj, Object[] args) {
        int i;
        this.funObj = funObj;
        this.thisObj = thisObj;
        this.setParentScope(scope);
        this.caller = cx.currentActivation;
        cx.currentActivation = this;
        this.originalArgs = args == null ? ScriptRuntime.emptyArgs : args;
        String[] argNames = funObj.argNames;
        if (argNames != null) {
            i = 0;
            while (i < funObj.argCount) {
                Scriptable val = i < args.length ? args[i] : Undefined.instance;
                super.put(argNames[i], (Scriptable)this, (Object)val);
                ++i;
            }
        }
        if (!super.has("arguments", (Scriptable)this)) {
            super.put("arguments", (Scriptable)this, (Object)new Arguments(this));
        }
        if (argNames != null) {
            i = funObj.argCount;
            while (i != argNames.length) {
                String name = argNames[i];
                if (!super.has(name, (Scriptable)this)) {
                    super.put(name, (Scriptable)this, (Object)Undefined.instance);
                }
                ++i;
            }
        }
    }

    public String getClassName() {
        return "Call";
    }

    NativeCall getActivation(Function f) {
        NativeCall x = this;
        do {
            if (x.funObj != f) continue;
            return x;
        } while ((x = x.caller) != null);
        return null;
    }

    public Function getFunctionObject() {
        return this.funObj;
    }

    public Object[] getOriginalArguments() {
        return this.originalArgs;
    }

    public NativeCall getCaller() {
        return this.caller;
    }

    public Scriptable getThisObj() {
        return this.thisObj;
    }
}

