// Copyright 2016 Google LLC. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.24.0
// 	protoc        v3.12.3
// source: trillian_log_api.proto

package trillian

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// ChargeTo describes the user(s) associated with the request whose quota should
// be checked and charged.
type ChargeTo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// user is a list of personality-defined strings.
	// Trillian will treat them as /User/%{user}/... keys when checking and
	// charging quota.
	// If one or more of the specified users has insufficient quota, the
	// request will be denied.
	//
	// As an example, a Certificate Transparency frontend might set the following
	// user strings when sending a QueueLeaves request to the Trillian log:
	//   - The requesting IP address.
	//     This would limit the number of requests per IP.
	//   - The "intermediate-<hash>" for each of the intermediate certificates in
	//     the submitted chain.
	//     This would have the effect of limiting the rate of submissions under
	//     a given intermediate/root.
	User []string `protobuf:"bytes,1,rep,name=user,proto3" json:"user,omitempty"`
}

func (x *ChargeTo) Reset() {
	*x = ChargeTo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ChargeTo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChargeTo) ProtoMessage() {}

func (x *ChargeTo) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChargeTo.ProtoReflect.Descriptor instead.
func (*ChargeTo) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{0}
}

func (x *ChargeTo) GetUser() []string {
	if x != nil {
		return x.User
	}
	return nil
}

type QueueLeafRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	Leaf     *LogLeaf  `protobuf:"bytes,2,opt,name=leaf,proto3" json:"leaf,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,3,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *QueueLeafRequest) Reset() {
	*x = QueueLeafRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueLeafRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueLeafRequest) ProtoMessage() {}

func (x *QueueLeafRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueLeafRequest.ProtoReflect.Descriptor instead.
func (*QueueLeafRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{1}
}

func (x *QueueLeafRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *QueueLeafRequest) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *QueueLeafRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type QueueLeafResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// queued_leaf describes the leaf which is or will be incorporated into the
	// Log.  If the submitted leaf was already present in the Log (as indicated by
	// its leaf identity hash), then the returned leaf will be the pre-existing
	// leaf entry rather than the submitted leaf.
	QueuedLeaf *QueuedLogLeaf `protobuf:"bytes,2,opt,name=queued_leaf,json=queuedLeaf,proto3" json:"queued_leaf,omitempty"`
}

func (x *QueueLeafResponse) Reset() {
	*x = QueueLeafResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueLeafResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueLeafResponse) ProtoMessage() {}

func (x *QueueLeafResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueLeafResponse.ProtoReflect.Descriptor instead.
func (*QueueLeafResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{2}
}

func (x *QueueLeafResponse) GetQueuedLeaf() *QueuedLogLeaf {
	if x != nil {
		return x.QueuedLeaf
	}
	return nil
}

type AddSequencedLeafRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	Leaf     *LogLeaf  `protobuf:"bytes,2,opt,name=leaf,proto3" json:"leaf,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,3,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *AddSequencedLeafRequest) Reset() {
	*x = AddSequencedLeafRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSequencedLeafRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSequencedLeafRequest) ProtoMessage() {}

func (x *AddSequencedLeafRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSequencedLeafRequest.ProtoReflect.Descriptor instead.
func (*AddSequencedLeafRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{3}
}

func (x *AddSequencedLeafRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *AddSequencedLeafRequest) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *AddSequencedLeafRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type AddSequencedLeafResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Result *QueuedLogLeaf `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *AddSequencedLeafResponse) Reset() {
	*x = AddSequencedLeafResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSequencedLeafResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSequencedLeafResponse) ProtoMessage() {}

func (x *AddSequencedLeafResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSequencedLeafResponse.ProtoReflect.Descriptor instead.
func (*AddSequencedLeafResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{4}
}

func (x *AddSequencedLeafResponse) GetResult() *QueuedLogLeaf {
	if x != nil {
		return x.Result
	}
	return nil
}

type GetInclusionProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId     int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	LeafIndex int64     `protobuf:"varint,2,opt,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	TreeSize  int64     `protobuf:"varint,3,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	ChargeTo  *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetInclusionProofRequest) Reset() {
	*x = GetInclusionProofRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofRequest) ProtoMessage() {}

func (x *GetInclusionProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofRequest.ProtoReflect.Descriptor instead.
func (*GetInclusionProofRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{5}
}

func (x *GetInclusionProofRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetInclusionProofRequest) GetLeafIndex() int64 {
	if x != nil {
		return x.LeafIndex
	}
	return 0
}

func (x *GetInclusionProofRequest) GetTreeSize() int64 {
	if x != nil {
		return x.TreeSize
	}
	return 0
}

func (x *GetInclusionProofRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetInclusionProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The proof field may be empty if the requested tree_size was larger
	// than that available at the server (e.g. because there is skew between
	// server instances, and an earlier client request was processed by a
	// more up-to-date instance).  In this case, the signed_log_root
	// field will indicate the tree size that the server is aware of, and
	// the proof field will be empty.
	Proof         *Proof         `protobuf:"bytes,2,opt,name=proof,proto3" json:"proof,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetInclusionProofResponse) Reset() {
	*x = GetInclusionProofResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofResponse) ProtoMessage() {}

func (x *GetInclusionProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofResponse.ProtoReflect.Descriptor instead.
func (*GetInclusionProofResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{6}
}

func (x *GetInclusionProofResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetInclusionProofResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetInclusionProofByHashRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId int64 `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	// The leaf hash field provides the Merkle tree hash of the leaf entry
	// to be retrieved.
	LeafHash        []byte    `protobuf:"bytes,2,opt,name=leaf_hash,json=leafHash,proto3" json:"leaf_hash,omitempty"`
	TreeSize        int64     `protobuf:"varint,3,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	OrderBySequence bool      `protobuf:"varint,4,opt,name=order_by_sequence,json=orderBySequence,proto3" json:"order_by_sequence,omitempty"`
	ChargeTo        *ChargeTo `protobuf:"bytes,5,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetInclusionProofByHashRequest) Reset() {
	*x = GetInclusionProofByHashRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofByHashRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofByHashRequest) ProtoMessage() {}

func (x *GetInclusionProofByHashRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofByHashRequest.ProtoReflect.Descriptor instead.
func (*GetInclusionProofByHashRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{7}
}

func (x *GetInclusionProofByHashRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetInclusionProofByHashRequest) GetLeafHash() []byte {
	if x != nil {
		return x.LeafHash
	}
	return nil
}

func (x *GetInclusionProofByHashRequest) GetTreeSize() int64 {
	if x != nil {
		return x.TreeSize
	}
	return 0
}

func (x *GetInclusionProofByHashRequest) GetOrderBySequence() bool {
	if x != nil {
		return x.OrderBySequence
	}
	return false
}

func (x *GetInclusionProofByHashRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetInclusionProofByHashResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Logs can potentially contain leaves with duplicate hashes so it's possible
	// for this to return multiple proofs.  If the leaf index for a particular
	// instance of the requested Merkle leaf hash is beyond the requested tree
	// size, the corresponding proof entry will be missing.
	Proof         []*Proof       `protobuf:"bytes,2,rep,name=proof,proto3" json:"proof,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetInclusionProofByHashResponse) Reset() {
	*x = GetInclusionProofByHashResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInclusionProofByHashResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInclusionProofByHashResponse) ProtoMessage() {}

func (x *GetInclusionProofByHashResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInclusionProofByHashResponse.ProtoReflect.Descriptor instead.
func (*GetInclusionProofByHashResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{8}
}

func (x *GetInclusionProofByHashResponse) GetProof() []*Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetInclusionProofByHashResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetConsistencyProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId          int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	FirstTreeSize  int64     `protobuf:"varint,2,opt,name=first_tree_size,json=firstTreeSize,proto3" json:"first_tree_size,omitempty"`
	SecondTreeSize int64     `protobuf:"varint,3,opt,name=second_tree_size,json=secondTreeSize,proto3" json:"second_tree_size,omitempty"`
	ChargeTo       *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetConsistencyProofRequest) Reset() {
	*x = GetConsistencyProofRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConsistencyProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConsistencyProofRequest) ProtoMessage() {}

func (x *GetConsistencyProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConsistencyProofRequest.ProtoReflect.Descriptor instead.
func (*GetConsistencyProofRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{9}
}

func (x *GetConsistencyProofRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetConsistencyProofRequest) GetFirstTreeSize() int64 {
	if x != nil {
		return x.FirstTreeSize
	}
	return 0
}

func (x *GetConsistencyProofRequest) GetSecondTreeSize() int64 {
	if x != nil {
		return x.SecondTreeSize
	}
	return 0
}

func (x *GetConsistencyProofRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetConsistencyProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The proof field may be empty if the requested tree_size was larger
	// than that available at the server (e.g. because there is skew between
	// server instances, and an earlier client request was processed by a
	// more up-to-date instance).  In this case, the signed_log_root
	// field will indicate the tree size that the server is aware of, and
	// the proof field will be empty.
	Proof         *Proof         `protobuf:"bytes,2,opt,name=proof,proto3" json:"proof,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetConsistencyProofResponse) Reset() {
	*x = GetConsistencyProofResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConsistencyProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConsistencyProofResponse) ProtoMessage() {}

func (x *GetConsistencyProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConsistencyProofResponse.ProtoReflect.Descriptor instead.
func (*GetConsistencyProofResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{10}
}

func (x *GetConsistencyProofResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetConsistencyProofResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetLatestSignedLogRootRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,2,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
	// If first_tree_size is non-zero, the response will include a consistency
	// proof between first_tree_size and the new tree size (if not smaller).
	FirstTreeSize int64 `protobuf:"varint,3,opt,name=first_tree_size,json=firstTreeSize,proto3" json:"first_tree_size,omitempty"`
}

func (x *GetLatestSignedLogRootRequest) Reset() {
	*x = GetLatestSignedLogRootRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLatestSignedLogRootRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestSignedLogRootRequest) ProtoMessage() {}

func (x *GetLatestSignedLogRootRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestSignedLogRootRequest.ProtoReflect.Descriptor instead.
func (*GetLatestSignedLogRootRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{11}
}

func (x *GetLatestSignedLogRootRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetLatestSignedLogRootRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

func (x *GetLatestSignedLogRootRequest) GetFirstTreeSize() int64 {
	if x != nil {
		return x.FirstTreeSize
	}
	return 0
}

type GetLatestSignedLogRootResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	SignedLogRoot *SignedLogRoot `protobuf:"bytes,2,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
	// proof is filled in with a consistency proof if first_tree_size in
	// GetLatestSignedLogRootRequest is non-zero (and within the tree size
	// available at the server).
	Proof *Proof `protobuf:"bytes,3,opt,name=proof,proto3" json:"proof,omitempty"`
}

func (x *GetLatestSignedLogRootResponse) Reset() {
	*x = GetLatestSignedLogRootResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLatestSignedLogRootResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLatestSignedLogRootResponse) ProtoMessage() {}

func (x *GetLatestSignedLogRootResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLatestSignedLogRootResponse.ProtoReflect.Descriptor instead.
func (*GetLatestSignedLogRootResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{12}
}

func (x *GetLatestSignedLogRootResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

func (x *GetLatestSignedLogRootResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

// DO NOT USE - FOR DEBUGGING/TEST ONLY
//
// (Use GetLatestSignedLogRoot then de-serialize the Log Root and use
// use the tree size field within.)
type GetSequencedLeafCountRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,2,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetSequencedLeafCountRequest) Reset() {
	*x = GetSequencedLeafCountRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSequencedLeafCountRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSequencedLeafCountRequest) ProtoMessage() {}

func (x *GetSequencedLeafCountRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSequencedLeafCountRequest.ProtoReflect.Descriptor instead.
func (*GetSequencedLeafCountRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{13}
}

func (x *GetSequencedLeafCountRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetSequencedLeafCountRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetSequencedLeafCountResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LeafCount int64 `protobuf:"varint,2,opt,name=leaf_count,json=leafCount,proto3" json:"leaf_count,omitempty"`
}

func (x *GetSequencedLeafCountResponse) Reset() {
	*x = GetSequencedLeafCountResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSequencedLeafCountResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSequencedLeafCountResponse) ProtoMessage() {}

func (x *GetSequencedLeafCountResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSequencedLeafCountResponse.ProtoReflect.Descriptor instead.
func (*GetSequencedLeafCountResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{14}
}

func (x *GetSequencedLeafCountResponse) GetLeafCount() int64 {
	if x != nil {
		return x.LeafCount
	}
	return 0
}

type GetEntryAndProofRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId     int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	LeafIndex int64     `protobuf:"varint,2,opt,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	TreeSize  int64     `protobuf:"varint,3,opt,name=tree_size,json=treeSize,proto3" json:"tree_size,omitempty"`
	ChargeTo  *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetEntryAndProofRequest) Reset() {
	*x = GetEntryAndProofRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryAndProofRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryAndProofRequest) ProtoMessage() {}

func (x *GetEntryAndProofRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryAndProofRequest.ProtoReflect.Descriptor instead.
func (*GetEntryAndProofRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{15}
}

func (x *GetEntryAndProofRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetEntryAndProofRequest) GetLeafIndex() int64 {
	if x != nil {
		return x.LeafIndex
	}
	return 0
}

func (x *GetEntryAndProofRequest) GetTreeSize() int64 {
	if x != nil {
		return x.TreeSize
	}
	return 0
}

func (x *GetEntryAndProofRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetEntryAndProofResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Proof         *Proof         `protobuf:"bytes,2,opt,name=proof,proto3" json:"proof,omitempty"`
	Leaf          *LogLeaf       `protobuf:"bytes,3,opt,name=leaf,proto3" json:"leaf,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,4,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetEntryAndProofResponse) Reset() {
	*x = GetEntryAndProofResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetEntryAndProofResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryAndProofResponse) ProtoMessage() {}

func (x *GetEntryAndProofResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryAndProofResponse.ProtoReflect.Descriptor instead.
func (*GetEntryAndProofResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{16}
}

func (x *GetEntryAndProofResponse) GetProof() *Proof {
	if x != nil {
		return x.Proof
	}
	return nil
}

func (x *GetEntryAndProofResponse) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *GetEntryAndProofResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type InitLogRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	ChargeTo *ChargeTo `protobuf:"bytes,2,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *InitLogRequest) Reset() {
	*x = InitLogRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitLogRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitLogRequest) ProtoMessage() {}

func (x *InitLogRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitLogRequest.ProtoReflect.Descriptor instead.
func (*InitLogRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{17}
}

func (x *InitLogRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *InitLogRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type InitLogResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Created *SignedLogRoot `protobuf:"bytes,1,opt,name=created,proto3" json:"created,omitempty"`
}

func (x *InitLogResponse) Reset() {
	*x = InitLogResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitLogResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitLogResponse) ProtoMessage() {}

func (x *InitLogResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitLogResponse.ProtoReflect.Descriptor instead.
func (*InitLogResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{18}
}

func (x *InitLogResponse) GetCreated() *SignedLogRoot {
	if x != nil {
		return x.Created
	}
	return nil
}

type QueueLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64      `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	Leaves   []*LogLeaf `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	ChargeTo *ChargeTo  `protobuf:"bytes,3,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *QueueLeavesRequest) Reset() {
	*x = QueueLeavesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueLeavesRequest) ProtoMessage() {}

func (x *QueueLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueLeavesRequest.ProtoReflect.Descriptor instead.
func (*QueueLeavesRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{19}
}

func (x *QueueLeavesRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *QueueLeavesRequest) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *QueueLeavesRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type QueueLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Same number and order as in the corresponding request.
	QueuedLeaves []*QueuedLogLeaf `protobuf:"bytes,2,rep,name=queued_leaves,json=queuedLeaves,proto3" json:"queued_leaves,omitempty"`
}

func (x *QueueLeavesResponse) Reset() {
	*x = QueueLeavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueueLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueueLeavesResponse) ProtoMessage() {}

func (x *QueueLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueueLeavesResponse.ProtoReflect.Descriptor instead.
func (*QueueLeavesResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{20}
}

func (x *QueueLeavesResponse) GetQueuedLeaves() []*QueuedLogLeaf {
	if x != nil {
		return x.QueuedLeaves
	}
	return nil
}

type AddSequencedLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId    int64      `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	Leaves   []*LogLeaf `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	ChargeTo *ChargeTo  `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *AddSequencedLeavesRequest) Reset() {
	*x = AddSequencedLeavesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSequencedLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSequencedLeavesRequest) ProtoMessage() {}

func (x *AddSequencedLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSequencedLeavesRequest.ProtoReflect.Descriptor instead.
func (*AddSequencedLeavesRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{21}
}

func (x *AddSequencedLeavesRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *AddSequencedLeavesRequest) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *AddSequencedLeavesRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type AddSequencedLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Same number and order as in the corresponding request.
	Results []*QueuedLogLeaf `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *AddSequencedLeavesResponse) Reset() {
	*x = AddSequencedLeavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddSequencedLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddSequencedLeavesResponse) ProtoMessage() {}

func (x *AddSequencedLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddSequencedLeavesResponse.ProtoReflect.Descriptor instead.
func (*AddSequencedLeavesResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{22}
}

func (x *AddSequencedLeavesResponse) GetResults() []*QueuedLogLeaf {
	if x != nil {
		return x.Results
	}
	return nil
}

type GetLeavesByIndexRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId     int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	LeafIndex []int64   `protobuf:"varint,2,rep,packed,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	ChargeTo  *ChargeTo `protobuf:"bytes,5,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetLeavesByIndexRequest) Reset() {
	*x = GetLeavesByIndexRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByIndexRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByIndexRequest) ProtoMessage() {}

func (x *GetLeavesByIndexRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByIndexRequest.ProtoReflect.Descriptor instead.
func (*GetLeavesByIndexRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{23}
}

func (x *GetLeavesByIndexRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetLeavesByIndexRequest) GetLeafIndex() []int64 {
	if x != nil {
		return x.LeafIndex
	}
	return nil
}

func (x *GetLeavesByIndexRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetLeavesByIndexResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TODO(gbelvin): Response syntax does not allow for some requested leaves to be available, and some not (but using QueuedLogLeaf might)
	Leaves        []*LogLeaf     `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetLeavesByIndexResponse) Reset() {
	*x = GetLeavesByIndexResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByIndexResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByIndexResponse) ProtoMessage() {}

func (x *GetLeavesByIndexResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByIndexResponse.ProtoReflect.Descriptor instead.
func (*GetLeavesByIndexResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{24}
}

func (x *GetLeavesByIndexResponse) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *GetLeavesByIndexResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetLeavesByRangeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId      int64     `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	StartIndex int64     `protobuf:"varint,2,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	Count      int64     `protobuf:"varint,3,opt,name=count,proto3" json:"count,omitempty"`
	ChargeTo   *ChargeTo `protobuf:"bytes,4,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetLeavesByRangeRequest) Reset() {
	*x = GetLeavesByRangeRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByRangeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByRangeRequest) ProtoMessage() {}

func (x *GetLeavesByRangeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByRangeRequest.ProtoReflect.Descriptor instead.
func (*GetLeavesByRangeRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{25}
}

func (x *GetLeavesByRangeRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetLeavesByRangeRequest) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *GetLeavesByRangeRequest) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *GetLeavesByRangeRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetLeavesByRangeResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Returned log leaves starting from the `start_index` of the request, in
	// order. There may be fewer than `request.count` leaves returned, if the
	// requested range extended beyond the size of the tree or if the server opted
	// to return fewer leaves than requested.
	Leaves        []*LogLeaf     `protobuf:"bytes,1,rep,name=leaves,proto3" json:"leaves,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,2,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetLeavesByRangeResponse) Reset() {
	*x = GetLeavesByRangeResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByRangeResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByRangeResponse) ProtoMessage() {}

func (x *GetLeavesByRangeResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByRangeResponse.ProtoReflect.Descriptor instead.
func (*GetLeavesByRangeResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{26}
}

func (x *GetLeavesByRangeResponse) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *GetLeavesByRangeResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

type GetLeavesByHashRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	LogId int64 `protobuf:"varint,1,opt,name=log_id,json=logId,proto3" json:"log_id,omitempty"`
	// The Merkle leaf hash of the leaf to be retrieved.
	LeafHash [][]byte `protobuf:"bytes,2,rep,name=leaf_hash,json=leafHash,proto3" json:"leaf_hash,omitempty"`
	// If order_by_sequence is set then leaves will be returned in order of ascending
	// leaf index.
	OrderBySequence bool      `protobuf:"varint,3,opt,name=order_by_sequence,json=orderBySequence,proto3" json:"order_by_sequence,omitempty"`
	ChargeTo        *ChargeTo `protobuf:"bytes,5,opt,name=charge_to,json=chargeTo,proto3" json:"charge_to,omitempty"`
}

func (x *GetLeavesByHashRequest) Reset() {
	*x = GetLeavesByHashRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByHashRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByHashRequest) ProtoMessage() {}

func (x *GetLeavesByHashRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByHashRequest.ProtoReflect.Descriptor instead.
func (*GetLeavesByHashRequest) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{27}
}

func (x *GetLeavesByHashRequest) GetLogId() int64 {
	if x != nil {
		return x.LogId
	}
	return 0
}

func (x *GetLeavesByHashRequest) GetLeafHash() [][]byte {
	if x != nil {
		return x.LeafHash
	}
	return nil
}

func (x *GetLeavesByHashRequest) GetOrderBySequence() bool {
	if x != nil {
		return x.OrderBySequence
	}
	return false
}

func (x *GetLeavesByHashRequest) GetChargeTo() *ChargeTo {
	if x != nil {
		return x.ChargeTo
	}
	return nil
}

type GetLeavesByHashResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Leaves        []*LogLeaf     `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	SignedLogRoot *SignedLogRoot `protobuf:"bytes,3,opt,name=signed_log_root,json=signedLogRoot,proto3" json:"signed_log_root,omitempty"`
}

func (x *GetLeavesByHashResponse) Reset() {
	*x = GetLeavesByHashResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLeavesByHashResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLeavesByHashResponse) ProtoMessage() {}

func (x *GetLeavesByHashResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLeavesByHashResponse.ProtoReflect.Descriptor instead.
func (*GetLeavesByHashResponse) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{28}
}

func (x *GetLeavesByHashResponse) GetLeaves() []*LogLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *GetLeavesByHashResponse) GetSignedLogRoot() *SignedLogRoot {
	if x != nil {
		return x.SignedLogRoot
	}
	return nil
}

// QueuedLogLeaf provides the result of submitting an entry to the log.
// TODO(pavelkalinnikov): Consider renaming it to AddLogLeafResult or the like.
type QueuedLogLeaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The leaf as it was stored by Trillian. Empty unless `status.code` is:
	//  - `google.rpc.OK`: the `leaf` data is the same as in the request.
	//  - `google.rpc.ALREADY_EXISTS` or 'google.rpc.FAILED_PRECONDITION`: the
	//    `leaf` is the conflicting one already in the log.
	Leaf *LogLeaf `protobuf:"bytes,1,opt,name=leaf,proto3" json:"leaf,omitempty"`
	// The status of adding the leaf.
	//  - `google.rpc.OK`: successfully added.
	//  - `google.rpc.ALREADY_EXISTS`: the leaf is a duplicate of an already
	//    existing one. Either `leaf_identity_hash` is the same in the `LOG`
	//    mode, or `leaf_index` in the `PREORDERED_LOG`.
	//  - `google.rpc.FAILED_PRECONDITION`: A conflicting entry is already
	//    present in the log, e.g., same `leaf_index` but different `leaf_data`.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *QueuedLogLeaf) Reset() {
	*x = QueuedLogLeaf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueuedLogLeaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueuedLogLeaf) ProtoMessage() {}

func (x *QueuedLogLeaf) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueuedLogLeaf.ProtoReflect.Descriptor instead.
func (*QueuedLogLeaf) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{29}
}

func (x *QueuedLogLeaf) GetLeaf() *LogLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *QueuedLogLeaf) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// LogLeaf describes a leaf in the Log's Merkle tree, corresponding to a single log entry.
// Each leaf has a unique leaf index in the scope of this tree.  Clients submitting new
// leaf entries should only set the following fields:
//   - leaf_value
//   - extra_data (optionally)
//   - leaf_identity_hash (optionally)
//   - leaf_index (iff the log is a PREORDERED_LOG)
type LogLeaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// merkle_leaf_hash holds the Merkle leaf hash over leaf_value.  This is
	// calculated by the Trillian server when leaves are added to the tree, using
	// the defined hashing algorithm and strategy for the tree; as such, the client
	// does not need to set it on leaf submissions.
	MerkleLeafHash []byte `protobuf:"bytes,1,opt,name=merkle_leaf_hash,json=merkleLeafHash,proto3" json:"merkle_leaf_hash,omitempty"`
	// leaf_value holds the data that forms the value of the Merkle tree leaf.
	// The client should set this field on all leaf submissions, and is
	// responsible for ensuring its validity (the Trillian server treats it as an
	// opaque blob).
	LeafValue []byte `protobuf:"bytes,2,opt,name=leaf_value,json=leafValue,proto3" json:"leaf_value,omitempty"`
	// extra_data holds additional data associated with the Merkle tree leaf.
	// The client may set this data on leaf submissions, and the Trillian server
	// will return it on subsequent read operations. However, the contents of
	// this field are not covered by and do not affect the Merkle tree hash
	// calculations.
	ExtraData []byte `protobuf:"bytes,3,opt,name=extra_data,json=extraData,proto3" json:"extra_data,omitempty"`
	// leaf_index indicates the index of this leaf in the Merkle tree.
	// This field is returned on all read operations, but should only be
	// set for leaf submissions in PREORDERED_LOG mode (for a normal log
	// the leaf index is assigned by Trillian when the submitted leaf is
	// integrated into the Merkle tree).
	LeafIndex int64 `protobuf:"varint,4,opt,name=leaf_index,json=leafIndex,proto3" json:"leaf_index,omitempty"`
	// leaf_identity_hash provides a hash value that indicates the client's
	// concept of which leaf entries should be considered identical.
	//
	// This mechanism allows the client personality to indicate that two leaves
	// should be considered "duplicates" even though their `leaf_value`s differ.
	//
	// If this is not set on leaf submissions, the Trillian server will take its
	// value to be the same as merkle_leaf_hash (and thus only leaves with
	// identical leaf_value contents will be considered identical).
	//
	// For example, in Certificate Transparency each certificate submission is
	// associated with a submission timestamp, but subsequent submissions of the
	// same certificate should be considered identical.  This is achieved
	// by setting the leaf identity hash to a hash over (just) the certificate,
	// whereas the Merkle leaf hash encompasses both the certificate and its
	// submission time -- allowing duplicate certificates to be detected.
	//
	//
	// Continuing the CT example, for a CT mirror personality (which must allow
	// dupes since the source log could contain them), the part of the
	// personality which fetches and submits the entries might set
	// `leaf_identity_hash` to `H(leaf_index||cert)`.
	//
	// TODO(pavelkalinnikov): Consider instead using `H(cert)` and allowing
	// identity hash dupes in `PREORDERED_LOG` mode, for it can later be
	// upgraded to `LOG` which will need to correctly detect duplicates with
	// older entries when new ones get queued.
	LeafIdentityHash []byte `protobuf:"bytes,5,opt,name=leaf_identity_hash,json=leafIdentityHash,proto3" json:"leaf_identity_hash,omitempty"`
	// queue_timestamp holds the time at which this leaf was queued for
	// inclusion in the Log, or zero if the entry was submitted without
	// queuing. Clients should not set this field on submissions.
	QueueTimestamp *timestamp.Timestamp `protobuf:"bytes,6,opt,name=queue_timestamp,json=queueTimestamp,proto3" json:"queue_timestamp,omitempty"`
	// integrate_timestamp holds the time at which this leaf was integrated into
	// the tree.  Clients should not set this field on submissions.
	IntegrateTimestamp *timestamp.Timestamp `protobuf:"bytes,7,opt,name=integrate_timestamp,json=integrateTimestamp,proto3" json:"integrate_timestamp,omitempty"`
}

func (x *LogLeaf) Reset() {
	*x = LogLeaf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_log_api_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LogLeaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogLeaf) ProtoMessage() {}

func (x *LogLeaf) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_log_api_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogLeaf.ProtoReflect.Descriptor instead.
func (*LogLeaf) Descriptor() ([]byte, []int) {
	return file_trillian_log_api_proto_rawDescGZIP(), []int{30}
}

func (x *LogLeaf) GetMerkleLeafHash() []byte {
	if x != nil {
		return x.MerkleLeafHash
	}
	return nil
}

func (x *LogLeaf) GetLeafValue() []byte {
	if x != nil {
		return x.LeafValue
	}
	return nil
}

func (x *LogLeaf) GetExtraData() []byte {
	if x != nil {
		return x.ExtraData
	}
	return nil
}

func (x *LogLeaf) GetLeafIndex() int64 {
	if x != nil {
		return x.LeafIndex
	}
	return 0
}

func (x *LogLeaf) GetLeafIdentityHash() []byte {
	if x != nil {
		return x.LeafIdentityHash
	}
	return nil
}

func (x *LogLeaf) GetQueueTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.QueueTimestamp
	}
	return nil
}

func (x *LogLeaf) GetIntegrateTimestamp() *timestamp.Timestamp {
	if x != nil {
		return x.IntegrateTimestamp
	}
	return nil
}

var File_trillian_log_api_proto protoreflect.FileDescriptor

var file_trillian_log_api_proto_rawDesc = []byte{
	0x0a, 0x16, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x0e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x1e, 0x0a, 0x08, 0x43, 0x68,
	0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x73, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x73, 0x65, 0x72, 0x22, 0x81, 0x01, 0x0a, 0x10, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12, 0x2f, 0x0a,
	0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72,
	0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x4d,
	0x0a, 0x11, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x6c, 0x65,
	0x61, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c,
	0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61,
	0x66, 0x52, 0x0a, 0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x22, 0x88, 0x01,
	0x0a, 0x17, 0x41, 0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65,
	0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64,
	0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61,
	0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08,
	0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x4b, 0x0a, 0x18, 0x41, 0x64, 0x64, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x9e, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61,
	0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6c,
	0x65, 0x61, 0x66, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x65, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x74, 0x72, 0x65,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c,
	0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68,
	0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x83, 0x01, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x49, 0x6e,
	0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0xce, 0x01, 0x0a,
	0x1e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x6f, 0x66, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x68,
	0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6c, 0x65, 0x61, 0x66, 0x48,
	0x61, 0x73, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x74, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x2a, 0x0a, 0x11, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09,
	0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67,
	0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x89, 0x01,
	0x0a, 0x1f, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x25, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0xb6, 0x01, 0x0a, 0x1a, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12,
	0x26, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x66, 0x69, 0x72, 0x73, 0x74, 0x54,
	0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x5f, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x54, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65,
	0x54, 0x6f, 0x22, 0x85, 0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f,
	0x6f, 0x66, 0x52, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67,
	0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0x8f, 0x01, 0x0a, 0x1d, 0x47,
	0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f,
	0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06,
	0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f,
	0x67, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72,
	0x67, 0x65, 0x54, 0x6f, 0x12, 0x26, 0x0a, 0x0f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x74, 0x72,
	0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x66,
	0x69, 0x72, 0x73, 0x74, 0x54, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x88, 0x01, 0x0a,
	0x1e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f,
	0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c,
	0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f,
	0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74,
	0x12, 0x25, 0x0a, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x52, 0x05, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x22, 0x66, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x53, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x2f,
	0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22,
	0x3e, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c,
	0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0x9d, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e, 0x64, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c,
	0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67,
	0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x74, 0x72, 0x65, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x2f,
	0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22,
	0xa9, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e, 0x64, 0x50,
	0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x0a, 0x05,
	0x70, 0x72, 0x6f, 0x6f, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x05, 0x70, 0x72,
	0x6f, 0x6f, 0x66, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67,
	0x4c, 0x65, 0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69,
	0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0x58, 0x0a, 0x0e, 0x49,
	0x6e, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a,
	0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c,
	0x6f, 0x67, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x44, 0x0a, 0x0f, 0x49, 0x6e, 0x69, 0x74, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f,
	0x6f, 0x74, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x22, 0x87, 0x01, 0x0a, 0x12,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61,
	0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x53, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x0d,
	0x71, 0x75, 0x65, 0x75, 0x65, 0x64, 0x5f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51,
	0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x0c, 0x71, 0x75,
	0x65, 0x75, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x19, 0x41,
	0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12,
	0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65,
	0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68,
	0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54,
	0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x4f, 0x0a, 0x1a, 0x41,
	0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x4c,
	0x65, 0x61, 0x66, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x80, 0x01, 0x0a,
	0x17, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12,
	0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2f,
	0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22,
	0x86, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x06,
	0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52,
	0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0x98, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x14, 0x0a, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e,
	0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08, 0x63, 0x68, 0x61, 0x72, 0x67,
	0x65, 0x54, 0x6f, 0x22, 0x86, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c,
	0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x0f, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x0d, 0x73,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0xa9, 0x01, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6c, 0x6f, 0x67, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x6f, 0x67, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0c, 0x52, 0x08, 0x6c, 0x65, 0x61, 0x66, 0x48, 0x61, 0x73, 0x68, 0x12, 0x2a, 0x0a, 0x11, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x68, 0x61, 0x72, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x52, 0x08,
	0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x54, 0x6f, 0x22, 0x85, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12,
	0x3f, 0x0a, 0x0f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x5f, 0x72, 0x6f,
	0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c,
	0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f,
	0x74, 0x52, 0x0d, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74,
	0x22, 0x62, 0x0a, 0x0d, 0x51, 0x75, 0x65, 0x75, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61,
	0x66, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65,
	0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x22, 0xd0, 0x02, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x61, 0x66,
	0x12, 0x28, 0x0a, 0x10, 0x6d, 0x65, 0x72, 0x6b, 0x6c, 0x65, 0x5f, 0x6c, 0x65, 0x61, 0x66, 0x5f,
	0x68, 0x61, 0x73, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0e, 0x6d, 0x65, 0x72, 0x6b,
	0x6c, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65,
	0x61, 0x66, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09,
	0x6c, 0x65, 0x61, 0x66, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x78, 0x74,
	0x72, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x65,
	0x78, 0x74, 0x72, 0x61, 0x44, 0x61, 0x74, 0x61, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6c, 0x65,
	0x61, 0x66, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2c, 0x0a, 0x12, 0x6c, 0x65, 0x61, 0x66, 0x5f,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x10, 0x6c, 0x65, 0x61, 0x66, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x43, 0x0a, 0x0f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0e, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x4b, 0x0a, 0x13, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x32, 0xe8, 0x0d, 0x0a, 0x0b, 0x54, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x4c, 0x6f, 0x67, 0x12, 0x6e, 0x0a, 0x09, 0x51, 0x75, 0x65, 0x75, 0x65,
	0x4c, 0x65, 0x61, 0x66, 0x12, 0x1a, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1b, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75,
	0x65, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x28, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x22, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0x8d, 0x01, 0x0a, 0x10, 0x41, 0x64, 0x64, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x21, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x41, 0x64, 0x64, 0x53, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x22, 0x27, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x5f,
	0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x65, 0x64, 0x3a, 0x01, 0x2a, 0x12, 0xa0, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x49,
	0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x22, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x67, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x2f, 0x7b, 0x6c,
	0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x7d, 0x3a, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0xa7, 0x01, 0x0a, 0x17, 0x47,
	0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66,
	0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x28, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x42, 0x79, 0x48,
	0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f,
	0x67, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x3a, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x79, 0x5f,
	0x68, 0x61, 0x73, 0x68, 0x12, 0x94, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x24, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x25, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x6f,
	0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x98, 0x01, 0x0a, 0x16,
	0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c,
	0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x27, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x28, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x52, 0x6f, 0x6f,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x25, 0x12, 0x23, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x3a,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x12, 0x9f, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x26, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c,
	0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64,
	0x4c, 0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x3a, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x8d, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x12, 0x21, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x41, 0x6e, 0x64, 0x50, 0x72, 0x6f, 0x6f, 0x66, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x67,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x65, 0x61,
	0x66, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x7d, 0x12, 0x63, 0x0a, 0x07, 0x49, 0x6e, 0x69, 0x74,
	0x4c, 0x6f, 0x67, 0x12, 0x18, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x49,
	0x6e, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x4c, 0x6f, 0x67,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d,
	0x22, 0x1b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x67, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x69, 0x6e, 0x69, 0x74, 0x12, 0x4c, 0x0a,
	0x0b, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x1c, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61,
	0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x51, 0x75, 0x65, 0x75, 0x65, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x61, 0x0a, 0x12, 0x41,
	0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x12, 0x23, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x41, 0x64, 0x64,
	0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x41, 0x64, 0x64, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5b,
	0x0a, 0x10, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x21, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e,
	0x2e, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5b, 0x0a, 0x10, 0x47,
	0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12,
	0x21, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x58, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x4c,
	0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x12, 0x20, 0x2e, 0x74, 0x72,
	0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73,
	0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x42, 0x79, 0x48, 0x61, 0x73, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x42, 0x4e, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42,
	0x13, 0x54, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x4c, 0x6f, 0x67, 0x41, 0x70, 0x69, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x1a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_trillian_log_api_proto_rawDescOnce sync.Once
	file_trillian_log_api_proto_rawDescData = file_trillian_log_api_proto_rawDesc
)

func file_trillian_log_api_proto_rawDescGZIP() []byte {
	file_trillian_log_api_proto_rawDescOnce.Do(func() {
		file_trillian_log_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_trillian_log_api_proto_rawDescData)
	})
	return file_trillian_log_api_proto_rawDescData
}

var file_trillian_log_api_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_trillian_log_api_proto_goTypes = []interface{}{
	(*ChargeTo)(nil),                        // 0: trillian.ChargeTo
	(*QueueLeafRequest)(nil),                // 1: trillian.QueueLeafRequest
	(*QueueLeafResponse)(nil),               // 2: trillian.QueueLeafResponse
	(*AddSequencedLeafRequest)(nil),         // 3: trillian.AddSequencedLeafRequest
	(*AddSequencedLeafResponse)(nil),        // 4: trillian.AddSequencedLeafResponse
	(*GetInclusionProofRequest)(nil),        // 5: trillian.GetInclusionProofRequest
	(*GetInclusionProofResponse)(nil),       // 6: trillian.GetInclusionProofResponse
	(*GetInclusionProofByHashRequest)(nil),  // 7: trillian.GetInclusionProofByHashRequest
	(*GetInclusionProofByHashResponse)(nil), // 8: trillian.GetInclusionProofByHashResponse
	(*GetConsistencyProofRequest)(nil),      // 9: trillian.GetConsistencyProofRequest
	(*GetConsistencyProofResponse)(nil),     // 10: trillian.GetConsistencyProofResponse
	(*GetLatestSignedLogRootRequest)(nil),   // 11: trillian.GetLatestSignedLogRootRequest
	(*GetLatestSignedLogRootResponse)(nil),  // 12: trillian.GetLatestSignedLogRootResponse
	(*GetSequencedLeafCountRequest)(nil),    // 13: trillian.GetSequencedLeafCountRequest
	(*GetSequencedLeafCountResponse)(nil),   // 14: trillian.GetSequencedLeafCountResponse
	(*GetEntryAndProofRequest)(nil),         // 15: trillian.GetEntryAndProofRequest
	(*GetEntryAndProofResponse)(nil),        // 16: trillian.GetEntryAndProofResponse
	(*InitLogRequest)(nil),                  // 17: trillian.InitLogRequest
	(*InitLogResponse)(nil),                 // 18: trillian.InitLogResponse
	(*QueueLeavesRequest)(nil),              // 19: trillian.QueueLeavesRequest
	(*QueueLeavesResponse)(nil),             // 20: trillian.QueueLeavesResponse
	(*AddSequencedLeavesRequest)(nil),       // 21: trillian.AddSequencedLeavesRequest
	(*AddSequencedLeavesResponse)(nil),      // 22: trillian.AddSequencedLeavesResponse
	(*GetLeavesByIndexRequest)(nil),         // 23: trillian.GetLeavesByIndexRequest
	(*GetLeavesByIndexResponse)(nil),        // 24: trillian.GetLeavesByIndexResponse
	(*GetLeavesByRangeRequest)(nil),         // 25: trillian.GetLeavesByRangeRequest
	(*GetLeavesByRangeResponse)(nil),        // 26: trillian.GetLeavesByRangeResponse
	(*GetLeavesByHashRequest)(nil),          // 27: trillian.GetLeavesByHashRequest
	(*GetLeavesByHashResponse)(nil),         // 28: trillian.GetLeavesByHashResponse
	(*QueuedLogLeaf)(nil),                   // 29: trillian.QueuedLogLeaf
	(*LogLeaf)(nil),                         // 30: trillian.LogLeaf
	(*Proof)(nil),                           // 31: trillian.Proof
	(*SignedLogRoot)(nil),                   // 32: trillian.SignedLogRoot
	(*status.Status)(nil),                   // 33: google.rpc.Status
	(*timestamp.Timestamp)(nil),             // 34: google.protobuf.Timestamp
}
var file_trillian_log_api_proto_depIdxs = []int32{
	30, // 0: trillian.QueueLeafRequest.leaf:type_name -> trillian.LogLeaf
	0,  // 1: trillian.QueueLeafRequest.charge_to:type_name -> trillian.ChargeTo
	29, // 2: trillian.QueueLeafResponse.queued_leaf:type_name -> trillian.QueuedLogLeaf
	30, // 3: trillian.AddSequencedLeafRequest.leaf:type_name -> trillian.LogLeaf
	0,  // 4: trillian.AddSequencedLeafRequest.charge_to:type_name -> trillian.ChargeTo
	29, // 5: trillian.AddSequencedLeafResponse.result:type_name -> trillian.QueuedLogLeaf
	0,  // 6: trillian.GetInclusionProofRequest.charge_to:type_name -> trillian.ChargeTo
	31, // 7: trillian.GetInclusionProofResponse.proof:type_name -> trillian.Proof
	32, // 8: trillian.GetInclusionProofResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 9: trillian.GetInclusionProofByHashRequest.charge_to:type_name -> trillian.ChargeTo
	31, // 10: trillian.GetInclusionProofByHashResponse.proof:type_name -> trillian.Proof
	32, // 11: trillian.GetInclusionProofByHashResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 12: trillian.GetConsistencyProofRequest.charge_to:type_name -> trillian.ChargeTo
	31, // 13: trillian.GetConsistencyProofResponse.proof:type_name -> trillian.Proof
	32, // 14: trillian.GetConsistencyProofResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 15: trillian.GetLatestSignedLogRootRequest.charge_to:type_name -> trillian.ChargeTo
	32, // 16: trillian.GetLatestSignedLogRootResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	31, // 17: trillian.GetLatestSignedLogRootResponse.proof:type_name -> trillian.Proof
	0,  // 18: trillian.GetSequencedLeafCountRequest.charge_to:type_name -> trillian.ChargeTo
	0,  // 19: trillian.GetEntryAndProofRequest.charge_to:type_name -> trillian.ChargeTo
	31, // 20: trillian.GetEntryAndProofResponse.proof:type_name -> trillian.Proof
	30, // 21: trillian.GetEntryAndProofResponse.leaf:type_name -> trillian.LogLeaf
	32, // 22: trillian.GetEntryAndProofResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 23: trillian.InitLogRequest.charge_to:type_name -> trillian.ChargeTo
	32, // 24: trillian.InitLogResponse.created:type_name -> trillian.SignedLogRoot
	30, // 25: trillian.QueueLeavesRequest.leaves:type_name -> trillian.LogLeaf
	0,  // 26: trillian.QueueLeavesRequest.charge_to:type_name -> trillian.ChargeTo
	29, // 27: trillian.QueueLeavesResponse.queued_leaves:type_name -> trillian.QueuedLogLeaf
	30, // 28: trillian.AddSequencedLeavesRequest.leaves:type_name -> trillian.LogLeaf
	0,  // 29: trillian.AddSequencedLeavesRequest.charge_to:type_name -> trillian.ChargeTo
	29, // 30: trillian.AddSequencedLeavesResponse.results:type_name -> trillian.QueuedLogLeaf
	0,  // 31: trillian.GetLeavesByIndexRequest.charge_to:type_name -> trillian.ChargeTo
	30, // 32: trillian.GetLeavesByIndexResponse.leaves:type_name -> trillian.LogLeaf
	32, // 33: trillian.GetLeavesByIndexResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 34: trillian.GetLeavesByRangeRequest.charge_to:type_name -> trillian.ChargeTo
	30, // 35: trillian.GetLeavesByRangeResponse.leaves:type_name -> trillian.LogLeaf
	32, // 36: trillian.GetLeavesByRangeResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	0,  // 37: trillian.GetLeavesByHashRequest.charge_to:type_name -> trillian.ChargeTo
	30, // 38: trillian.GetLeavesByHashResponse.leaves:type_name -> trillian.LogLeaf
	32, // 39: trillian.GetLeavesByHashResponse.signed_log_root:type_name -> trillian.SignedLogRoot
	30, // 40: trillian.QueuedLogLeaf.leaf:type_name -> trillian.LogLeaf
	33, // 41: trillian.QueuedLogLeaf.status:type_name -> google.rpc.Status
	34, // 42: trillian.LogLeaf.queue_timestamp:type_name -> google.protobuf.Timestamp
	34, // 43: trillian.LogLeaf.integrate_timestamp:type_name -> google.protobuf.Timestamp
	1,  // 44: trillian.TrillianLog.QueueLeaf:input_type -> trillian.QueueLeafRequest
	3,  // 45: trillian.TrillianLog.AddSequencedLeaf:input_type -> trillian.AddSequencedLeafRequest
	5,  // 46: trillian.TrillianLog.GetInclusionProof:input_type -> trillian.GetInclusionProofRequest
	7,  // 47: trillian.TrillianLog.GetInclusionProofByHash:input_type -> trillian.GetInclusionProofByHashRequest
	9,  // 48: trillian.TrillianLog.GetConsistencyProof:input_type -> trillian.GetConsistencyProofRequest
	11, // 49: trillian.TrillianLog.GetLatestSignedLogRoot:input_type -> trillian.GetLatestSignedLogRootRequest
	13, // 50: trillian.TrillianLog.GetSequencedLeafCount:input_type -> trillian.GetSequencedLeafCountRequest
	15, // 51: trillian.TrillianLog.GetEntryAndProof:input_type -> trillian.GetEntryAndProofRequest
	17, // 52: trillian.TrillianLog.InitLog:input_type -> trillian.InitLogRequest
	19, // 53: trillian.TrillianLog.QueueLeaves:input_type -> trillian.QueueLeavesRequest
	21, // 54: trillian.TrillianLog.AddSequencedLeaves:input_type -> trillian.AddSequencedLeavesRequest
	23, // 55: trillian.TrillianLog.GetLeavesByIndex:input_type -> trillian.GetLeavesByIndexRequest
	25, // 56: trillian.TrillianLog.GetLeavesByRange:input_type -> trillian.GetLeavesByRangeRequest
	27, // 57: trillian.TrillianLog.GetLeavesByHash:input_type -> trillian.GetLeavesByHashRequest
	2,  // 58: trillian.TrillianLog.QueueLeaf:output_type -> trillian.QueueLeafResponse
	4,  // 59: trillian.TrillianLog.AddSequencedLeaf:output_type -> trillian.AddSequencedLeafResponse
	6,  // 60: trillian.TrillianLog.GetInclusionProof:output_type -> trillian.GetInclusionProofResponse
	8,  // 61: trillian.TrillianLog.GetInclusionProofByHash:output_type -> trillian.GetInclusionProofByHashResponse
	10, // 62: trillian.TrillianLog.GetConsistencyProof:output_type -> trillian.GetConsistencyProofResponse
	12, // 63: trillian.TrillianLog.GetLatestSignedLogRoot:output_type -> trillian.GetLatestSignedLogRootResponse
	14, // 64: trillian.TrillianLog.GetSequencedLeafCount:output_type -> trillian.GetSequencedLeafCountResponse
	16, // 65: trillian.TrillianLog.GetEntryAndProof:output_type -> trillian.GetEntryAndProofResponse
	18, // 66: trillian.TrillianLog.InitLog:output_type -> trillian.InitLogResponse
	20, // 67: trillian.TrillianLog.QueueLeaves:output_type -> trillian.QueueLeavesResponse
	22, // 68: trillian.TrillianLog.AddSequencedLeaves:output_type -> trillian.AddSequencedLeavesResponse
	24, // 69: trillian.TrillianLog.GetLeavesByIndex:output_type -> trillian.GetLeavesByIndexResponse
	26, // 70: trillian.TrillianLog.GetLeavesByRange:output_type -> trillian.GetLeavesByRangeResponse
	28, // 71: trillian.TrillianLog.GetLeavesByHash:output_type -> trillian.GetLeavesByHashResponse
	58, // [58:72] is the sub-list for method output_type
	44, // [44:58] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_trillian_log_api_proto_init() }
func file_trillian_log_api_proto_init() {
	if File_trillian_log_api_proto != nil {
		return
	}
	file_trillian_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_trillian_log_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ChargeTo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueLeafRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueLeafResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddSequencedLeafRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddSequencedLeafResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInclusionProofRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInclusionProofResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInclusionProofByHashRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInclusionProofByHashResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConsistencyProofRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConsistencyProofResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLatestSignedLogRootRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLatestSignedLogRootResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSequencedLeafCountRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSequencedLeafCountResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryAndProofRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetEntryAndProofResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitLogRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitLogResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueLeavesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueueLeavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddSequencedLeavesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddSequencedLeavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLeavesByIndexRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLeavesByIndexResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLeavesByRangeRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLeavesByRangeResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLeavesByHashRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLeavesByHashResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*QueuedLogLeaf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_log_api_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LogLeaf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_trillian_log_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_trillian_log_api_proto_goTypes,
		DependencyIndexes: file_trillian_log_api_proto_depIdxs,
		MessageInfos:      file_trillian_log_api_proto_msgTypes,
	}.Build()
	File_trillian_log_api_proto = out.File
	file_trillian_log_api_proto_rawDesc = nil
	file_trillian_log_api_proto_goTypes = nil
	file_trillian_log_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TrillianLogClient is the client API for TrillianLog service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TrillianLogClient interface {
	// QueueLeaf adds a single leaf to the queue of pending leaves for a normal
	// log.
	QueueLeaf(ctx context.Context, in *QueueLeafRequest, opts ...grpc.CallOption) (*QueueLeafResponse, error)
	// AddSequencedLeaf adds a single leaf with an assigned sequence number to a
	// pre-ordered log.
	AddSequencedLeaf(ctx context.Context, in *AddSequencedLeafRequest, opts ...grpc.CallOption) (*AddSequencedLeafResponse, error)
	// GetInclusionProof returns an inclusion proof for a leaf with a given index
	// in a particular tree.
	//
	// If the requested tree_size is larger than the server is aware of, the
	// response will include the latest known log root and an empty proof.
	GetInclusionProof(ctx context.Context, in *GetInclusionProofRequest, opts ...grpc.CallOption) (*GetInclusionProofResponse, error)
	// GetInclusionProofByHash returns an inclusion proof for any leaves that have
	// the given Merkle hash in a particular tree.
	//
	// If any of the leaves that match the given Merkle has have a leaf index that
	// is beyond the requested tree size, the corresponding proof entry will be empty.
	GetInclusionProofByHash(ctx context.Context, in *GetInclusionProofByHashRequest, opts ...grpc.CallOption) (*GetInclusionProofByHashResponse, error)
	// GetConsistencyProof returns a consistency proof between different sizes of
	// a particular tree.
	//
	// If the requested tree size is larger than the server is aware of,
	// the response will include the latest known log root and an empty proof.
	GetConsistencyProof(ctx context.Context, in *GetConsistencyProofRequest, opts ...grpc.CallOption) (*GetConsistencyProofResponse, error)
	// GetLatestSignedLogRoot returns the latest signed log root for a given tree,
	// and optionally also includes a consistency proof from an earlier tree size
	// to the new size of the tree.
	//
	// If the earlier tree size is larger than the server is aware of,
	// an InvalidArgument error is returned.
	GetLatestSignedLogRoot(ctx context.Context, in *GetLatestSignedLogRootRequest, opts ...grpc.CallOption) (*GetLatestSignedLogRootResponse, error)
	// GetSequencedLeafCount returns the total number of leaves that have been
	// integrated into the given tree.
	//
	// DO NOT USE - FOR DEBUGGING/TEST ONLY
	//
	// (Use GetLatestSignedLogRoot then de-serialize the Log Root and use
	// use the tree size field within.)
	GetSequencedLeafCount(ctx context.Context, in *GetSequencedLeafCountRequest, opts ...grpc.CallOption) (*GetSequencedLeafCountResponse, error)
	// GetEntryAndProof returns a log leaf and the corresponding inclusion proof
	// to a specified tree size, for a given leaf index in a particular tree.
	//
	// If the requested tree size is unavailable but the leaf is
	// in scope for the current tree, the returned proof will be for the
	// current tree size rather than the requested tree size.
	GetEntryAndProof(ctx context.Context, in *GetEntryAndProofRequest, opts ...grpc.CallOption) (*GetEntryAndProofResponse, error)
	// InitLog initializes a particular tree, creating the initial signed log
	// root (which will be of size 0).
	InitLog(ctx context.Context, in *InitLogRequest, opts ...grpc.CallOption) (*InitLogResponse, error)
	// QueueLeaf adds a batch of leaves to the queue of pending leaves for a
	// normal log.
	QueueLeaves(ctx context.Context, in *QueueLeavesRequest, opts ...grpc.CallOption) (*QueueLeavesResponse, error)
	// AddSequencedLeaves adds a batch of leaves with assigned sequence numbers
	// to a pre-ordered log.  The indices of the provided leaves must be contiguous.
	AddSequencedLeaves(ctx context.Context, in *AddSequencedLeavesRequest, opts ...grpc.CallOption) (*AddSequencedLeavesResponse, error)
	// GetLeavesByIndex returns a batch of leaves whose leaf indices are provided
	// in the request.
	GetLeavesByIndex(ctx context.Context, in *GetLeavesByIndexRequest, opts ...grpc.CallOption) (*GetLeavesByIndexResponse, error)
	// GetLeavesByRange returns a batch of leaves whose leaf indices are in a
	// sequential range.
	GetLeavesByRange(ctx context.Context, in *GetLeavesByRangeRequest, opts ...grpc.CallOption) (*GetLeavesByRangeResponse, error)
	// GetLeavesByHash returns a batch of leaves which are identified by their
	// Merkle leaf hash values.
	GetLeavesByHash(ctx context.Context, in *GetLeavesByHashRequest, opts ...grpc.CallOption) (*GetLeavesByHashResponse, error)
}

type trillianLogClient struct {
	cc grpc.ClientConnInterface
}

func NewTrillianLogClient(cc grpc.ClientConnInterface) TrillianLogClient {
	return &trillianLogClient{cc}
}

func (c *trillianLogClient) QueueLeaf(ctx context.Context, in *QueueLeafRequest, opts ...grpc.CallOption) (*QueueLeafResponse, error) {
	out := new(QueueLeafResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/QueueLeaf", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) AddSequencedLeaf(ctx context.Context, in *AddSequencedLeafRequest, opts ...grpc.CallOption) (*AddSequencedLeafResponse, error) {
	out := new(AddSequencedLeafResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/AddSequencedLeaf", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetInclusionProof(ctx context.Context, in *GetInclusionProofRequest, opts ...grpc.CallOption) (*GetInclusionProofResponse, error) {
	out := new(GetInclusionProofResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetInclusionProof", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetInclusionProofByHash(ctx context.Context, in *GetInclusionProofByHashRequest, opts ...grpc.CallOption) (*GetInclusionProofByHashResponse, error) {
	out := new(GetInclusionProofByHashResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetInclusionProofByHash", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetConsistencyProof(ctx context.Context, in *GetConsistencyProofRequest, opts ...grpc.CallOption) (*GetConsistencyProofResponse, error) {
	out := new(GetConsistencyProofResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetConsistencyProof", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetLatestSignedLogRoot(ctx context.Context, in *GetLatestSignedLogRootRequest, opts ...grpc.CallOption) (*GetLatestSignedLogRootResponse, error) {
	out := new(GetLatestSignedLogRootResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetLatestSignedLogRoot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetSequencedLeafCount(ctx context.Context, in *GetSequencedLeafCountRequest, opts ...grpc.CallOption) (*GetSequencedLeafCountResponse, error) {
	out := new(GetSequencedLeafCountResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetSequencedLeafCount", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetEntryAndProof(ctx context.Context, in *GetEntryAndProofRequest, opts ...grpc.CallOption) (*GetEntryAndProofResponse, error) {
	out := new(GetEntryAndProofResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetEntryAndProof", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) InitLog(ctx context.Context, in *InitLogRequest, opts ...grpc.CallOption) (*InitLogResponse, error) {
	out := new(InitLogResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/InitLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) QueueLeaves(ctx context.Context, in *QueueLeavesRequest, opts ...grpc.CallOption) (*QueueLeavesResponse, error) {
	out := new(QueueLeavesResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/QueueLeaves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) AddSequencedLeaves(ctx context.Context, in *AddSequencedLeavesRequest, opts ...grpc.CallOption) (*AddSequencedLeavesResponse, error) {
	out := new(AddSequencedLeavesResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/AddSequencedLeaves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetLeavesByIndex(ctx context.Context, in *GetLeavesByIndexRequest, opts ...grpc.CallOption) (*GetLeavesByIndexResponse, error) {
	out := new(GetLeavesByIndexResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetLeavesByIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetLeavesByRange(ctx context.Context, in *GetLeavesByRangeRequest, opts ...grpc.CallOption) (*GetLeavesByRangeResponse, error) {
	out := new(GetLeavesByRangeResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetLeavesByRange", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianLogClient) GetLeavesByHash(ctx context.Context, in *GetLeavesByHashRequest, opts ...grpc.CallOption) (*GetLeavesByHashResponse, error) {
	out := new(GetLeavesByHashResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianLog/GetLeavesByHash", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TrillianLogServer is the server API for TrillianLog service.
type TrillianLogServer interface {
	// QueueLeaf adds a single leaf to the queue of pending leaves for a normal
	// log.
	QueueLeaf(context.Context, *QueueLeafRequest) (*QueueLeafResponse, error)
	// AddSequencedLeaf adds a single leaf with an assigned sequence number to a
	// pre-ordered log.
	AddSequencedLeaf(context.Context, *AddSequencedLeafRequest) (*AddSequencedLeafResponse, error)
	// GetInclusionProof returns an inclusion proof for a leaf with a given index
	// in a particular tree.
	//
	// If the requested tree_size is larger than the server is aware of, the
	// response will include the latest known log root and an empty proof.
	GetInclusionProof(context.Context, *GetInclusionProofRequest) (*GetInclusionProofResponse, error)
	// GetInclusionProofByHash returns an inclusion proof for any leaves that have
	// the given Merkle hash in a particular tree.
	//
	// If any of the leaves that match the given Merkle has have a leaf index that
	// is beyond the requested tree size, the corresponding proof entry will be empty.
	GetInclusionProofByHash(context.Context, *GetInclusionProofByHashRequest) (*GetInclusionProofByHashResponse, error)
	// GetConsistencyProof returns a consistency proof between different sizes of
	// a particular tree.
	//
	// If the requested tree size is larger than the server is aware of,
	// the response will include the latest known log root and an empty proof.
	GetConsistencyProof(context.Context, *GetConsistencyProofRequest) (*GetConsistencyProofResponse, error)
	// GetLatestSignedLogRoot returns the latest signed log root for a given tree,
	// and optionally also includes a consistency proof from an earlier tree size
	// to the new size of the tree.
	//
	// If the earlier tree size is larger than the server is aware of,
	// an InvalidArgument error is returned.
	GetLatestSignedLogRoot(context.Context, *GetLatestSignedLogRootRequest) (*GetLatestSignedLogRootResponse, error)
	// GetSequencedLeafCount returns the total number of leaves that have been
	// integrated into the given tree.
	//
	// DO NOT USE - FOR DEBUGGING/TEST ONLY
	//
	// (Use GetLatestSignedLogRoot then de-serialize the Log Root and use
	// use the tree size field within.)
	GetSequencedLeafCount(context.Context, *GetSequencedLeafCountRequest) (*GetSequencedLeafCountResponse, error)
	// GetEntryAndProof returns a log leaf and the corresponding inclusion proof
	// to a specified tree size, for a given leaf index in a particular tree.
	//
	// If the requested tree size is unavailable but the leaf is
	// in scope for the current tree, the returned proof will be for the
	// current tree size rather than the requested tree size.
	GetEntryAndProof(context.Context, *GetEntryAndProofRequest) (*GetEntryAndProofResponse, error)
	// InitLog initializes a particular tree, creating the initial signed log
	// root (which will be of size 0).
	InitLog(context.Context, *InitLogRequest) (*InitLogResponse, error)
	// QueueLeaf adds a batch of leaves to the queue of pending leaves for a
	// normal log.
	QueueLeaves(context.Context, *QueueLeavesRequest) (*QueueLeavesResponse, error)
	// AddSequencedLeaves adds a batch of leaves with assigned sequence numbers
	// to a pre-ordered log.  The indices of the provided leaves must be contiguous.
	AddSequencedLeaves(context.Context, *AddSequencedLeavesRequest) (*AddSequencedLeavesResponse, error)
	// GetLeavesByIndex returns a batch of leaves whose leaf indices are provided
	// in the request.
	GetLeavesByIndex(context.Context, *GetLeavesByIndexRequest) (*GetLeavesByIndexResponse, error)
	// GetLeavesByRange returns a batch of leaves whose leaf indices are in a
	// sequential range.
	GetLeavesByRange(context.Context, *GetLeavesByRangeRequest) (*GetLeavesByRangeResponse, error)
	// GetLeavesByHash returns a batch of leaves which are identified by their
	// Merkle leaf hash values.
	GetLeavesByHash(context.Context, *GetLeavesByHashRequest) (*GetLeavesByHashResponse, error)
}

// UnimplementedTrillianLogServer can be embedded to have forward compatible implementations.
type UnimplementedTrillianLogServer struct {
}

func (*UnimplementedTrillianLogServer) QueueLeaf(context.Context, *QueueLeafRequest) (*QueueLeafResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueueLeaf not implemented")
}
func (*UnimplementedTrillianLogServer) AddSequencedLeaf(context.Context, *AddSequencedLeafRequest) (*AddSequencedLeafResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddSequencedLeaf not implemented")
}
func (*UnimplementedTrillianLogServer) GetInclusionProof(context.Context, *GetInclusionProofRequest) (*GetInclusionProofResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetInclusionProof not implemented")
}
func (*UnimplementedTrillianLogServer) GetInclusionProofByHash(context.Context, *GetInclusionProofByHashRequest) (*GetInclusionProofByHashResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetInclusionProofByHash not implemented")
}
func (*UnimplementedTrillianLogServer) GetConsistencyProof(context.Context, *GetConsistencyProofRequest) (*GetConsistencyProofResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetConsistencyProof not implemented")
}
func (*UnimplementedTrillianLogServer) GetLatestSignedLogRoot(context.Context, *GetLatestSignedLogRootRequest) (*GetLatestSignedLogRootResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetLatestSignedLogRoot not implemented")
}
func (*UnimplementedTrillianLogServer) GetSequencedLeafCount(context.Context, *GetSequencedLeafCountRequest) (*GetSequencedLeafCountResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSequencedLeafCount not implemented")
}
func (*UnimplementedTrillianLogServer) GetEntryAndProof(context.Context, *GetEntryAndProofRequest) (*GetEntryAndProofResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEntryAndProof not implemented")
}
func (*UnimplementedTrillianLogServer) InitLog(context.Context, *InitLogRequest) (*InitLogResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method InitLog not implemented")
}
func (*UnimplementedTrillianLogServer) QueueLeaves(context.Context, *QueueLeavesRequest) (*QueueLeavesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueueLeaves not implemented")
}
func (*UnimplementedTrillianLogServer) AddSequencedLeaves(context.Context, *AddSequencedLeavesRequest) (*AddSequencedLeavesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AddSequencedLeaves not implemented")
}
func (*UnimplementedTrillianLogServer) GetLeavesByIndex(context.Context, *GetLeavesByIndexRequest) (*GetLeavesByIndexResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetLeavesByIndex not implemented")
}
func (*UnimplementedTrillianLogServer) GetLeavesByRange(context.Context, *GetLeavesByRangeRequest) (*GetLeavesByRangeResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetLeavesByRange not implemented")
}
func (*UnimplementedTrillianLogServer) GetLeavesByHash(context.Context, *GetLeavesByHashRequest) (*GetLeavesByHashResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetLeavesByHash not implemented")
}

func RegisterTrillianLogServer(s *grpc.Server, srv TrillianLogServer) {
	s.RegisterService(&_TrillianLog_serviceDesc, srv)
}

func _TrillianLog_QueueLeaf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueueLeafRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).QueueLeaf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/QueueLeaf",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).QueueLeaf(ctx, req.(*QueueLeafRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_AddSequencedLeaf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSequencedLeafRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).AddSequencedLeaf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/AddSequencedLeaf",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).AddSequencedLeaf(ctx, req.(*AddSequencedLeafRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetInclusionProof_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInclusionProofRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetInclusionProof(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetInclusionProof",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetInclusionProof(ctx, req.(*GetInclusionProofRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetInclusionProofByHash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInclusionProofByHashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetInclusionProofByHash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetInclusionProofByHash",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetInclusionProofByHash(ctx, req.(*GetInclusionProofByHashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetConsistencyProof_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConsistencyProofRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetConsistencyProof(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetConsistencyProof",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetConsistencyProof(ctx, req.(*GetConsistencyProofRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetLatestSignedLogRoot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLatestSignedLogRootRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetLatestSignedLogRoot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetLatestSignedLogRoot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetLatestSignedLogRoot(ctx, req.(*GetLatestSignedLogRootRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetSequencedLeafCount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSequencedLeafCountRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetSequencedLeafCount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetSequencedLeafCount",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetSequencedLeafCount(ctx, req.(*GetSequencedLeafCountRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetEntryAndProof_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntryAndProofRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetEntryAndProof(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetEntryAndProof",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetEntryAndProof(ctx, req.(*GetEntryAndProofRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_InitLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).InitLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/InitLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).InitLog(ctx, req.(*InitLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_QueueLeaves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueueLeavesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).QueueLeaves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/QueueLeaves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).QueueLeaves(ctx, req.(*QueueLeavesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_AddSequencedLeaves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSequencedLeavesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).AddSequencedLeaves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/AddSequencedLeaves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).AddSequencedLeaves(ctx, req.(*AddSequencedLeavesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetLeavesByIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLeavesByIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetLeavesByIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetLeavesByIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetLeavesByIndex(ctx, req.(*GetLeavesByIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetLeavesByRange_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLeavesByRangeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetLeavesByRange(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetLeavesByRange",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetLeavesByRange(ctx, req.(*GetLeavesByRangeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianLog_GetLeavesByHash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLeavesByHashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianLogServer).GetLeavesByHash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianLog/GetLeavesByHash",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianLogServer).GetLeavesByHash(ctx, req.(*GetLeavesByHashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TrillianLog_serviceDesc = grpc.ServiceDesc{
	ServiceName: "trillian.TrillianLog",
	HandlerType: (*TrillianLogServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueueLeaf",
			Handler:    _TrillianLog_QueueLeaf_Handler,
		},
		{
			MethodName: "AddSequencedLeaf",
			Handler:    _TrillianLog_AddSequencedLeaf_Handler,
		},
		{
			MethodName: "GetInclusionProof",
			Handler:    _TrillianLog_GetInclusionProof_Handler,
		},
		{
			MethodName: "GetInclusionProofByHash",
			Handler:    _TrillianLog_GetInclusionProofByHash_Handler,
		},
		{
			MethodName: "GetConsistencyProof",
			Handler:    _TrillianLog_GetConsistencyProof_Handler,
		},
		{
			MethodName: "GetLatestSignedLogRoot",
			Handler:    _TrillianLog_GetLatestSignedLogRoot_Handler,
		},
		{
			MethodName: "GetSequencedLeafCount",
			Handler:    _TrillianLog_GetSequencedLeafCount_Handler,
		},
		{
			MethodName: "GetEntryAndProof",
			Handler:    _TrillianLog_GetEntryAndProof_Handler,
		},
		{
			MethodName: "InitLog",
			Handler:    _TrillianLog_InitLog_Handler,
		},
		{
			MethodName: "QueueLeaves",
			Handler:    _TrillianLog_QueueLeaves_Handler,
		},
		{
			MethodName: "AddSequencedLeaves",
			Handler:    _TrillianLog_AddSequencedLeaves_Handler,
		},
		{
			MethodName: "GetLeavesByIndex",
			Handler:    _TrillianLog_GetLeavesByIndex_Handler,
		},
		{
			MethodName: "GetLeavesByRange",
			Handler:    _TrillianLog_GetLeavesByRange_Handler,
		},
		{
			MethodName: "GetLeavesByHash",
			Handler:    _TrillianLog_GetLeavesByHash_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "trillian_log_api.proto",
}
