// Copyright 2016 Google LLC. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.24.0
// 	protoc        v3.12.3
// source: trillian_map_api.proto

package trillian

import (
	context "context"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// MapLeaf represents the data behind Map leaves.
type MapLeaf struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// index is the location of this leaf.
	// All indexes for a given Map must contain a constant number of bits.
	// These are not numeric indices. Note that this is typically derived using a
	// hash and thus the length of all indices in the map will match the number
	// of bits in the hash function.
	Index []byte `protobuf:"bytes,1,opt,name=index,proto3" json:"index,omitempty"`
	// leaf_hash is the tree hash of leaf_value.  This does not need to be set
	// on SetMapLeavesRequest; the server will fill it in.
	// For an empty leaf (len(leaf_value)==0), there may be two possible values
	// for this hash:
	//  - If the leaf has never been set, it counts as an empty subtree and
	//    a nil value is used.
	//  - If the leaf has been explicitly set to a zero-length entry, it no
	//    longer counts as empty and the value of hasher.HashLeaf(index, nil)
	//    will be used.
	LeafHash []byte `protobuf:"bytes,2,opt,name=leaf_hash,json=leafHash,proto3" json:"leaf_hash,omitempty"`
	// leaf_value is the data the tree commits to.
	LeafValue []byte `protobuf:"bytes,3,opt,name=leaf_value,json=leafValue,proto3" json:"leaf_value,omitempty"`
	// extra_data holds related contextual data, but is not covered by any hash.
	ExtraData []byte `protobuf:"bytes,4,opt,name=extra_data,json=extraData,proto3" json:"extra_data,omitempty"`
}

func (x *MapLeaf) Reset() {
	*x = MapLeaf{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapLeaf) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapLeaf) ProtoMessage() {}

func (x *MapLeaf) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapLeaf.ProtoReflect.Descriptor instead.
func (*MapLeaf) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{0}
}

func (x *MapLeaf) GetIndex() []byte {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *MapLeaf) GetLeafHash() []byte {
	if x != nil {
		return x.LeafHash
	}
	return nil
}

func (x *MapLeaf) GetLeafValue() []byte {
	if x != nil {
		return x.LeafValue
	}
	return nil
}

func (x *MapLeaf) GetExtraData() []byte {
	if x != nil {
		return x.ExtraData
	}
	return nil
}

type MapLeaves struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Leaves []*MapLeaf `protobuf:"bytes,1,rep,name=leaves,proto3" json:"leaves,omitempty"`
}

func (x *MapLeaves) Reset() {
	*x = MapLeaves{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapLeaves) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapLeaves) ProtoMessage() {}

func (x *MapLeaves) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapLeaves.ProtoReflect.Descriptor instead.
func (*MapLeaves) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{1}
}

func (x *MapLeaves) GetLeaves() []*MapLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

type MapLeafInclusion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Leaf *MapLeaf `protobuf:"bytes,1,opt,name=leaf,proto3" json:"leaf,omitempty"`
	// inclusion holds the inclusion proof for this leaf in the map root. It
	// holds one entry for each level of the tree; combining each of these in
	// turn with the leaf's hash (according to the tree's hash strategy)
	// reproduces the root hash.  A nil entry for a particular level indicates
	// that the node in question has an empty subtree beneath it (and so its
	// associated hash value is hasher.HashEmpty(index, height) rather than
	// hasher.HashChildren(l_hash, r_hash)).
	Inclusion [][]byte `protobuf:"bytes,2,rep,name=inclusion,proto3" json:"inclusion,omitempty"`
}

func (x *MapLeafInclusion) Reset() {
	*x = MapLeafInclusion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MapLeafInclusion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MapLeafInclusion) ProtoMessage() {}

func (x *MapLeafInclusion) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MapLeafInclusion.ProtoReflect.Descriptor instead.
func (*MapLeafInclusion) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{2}
}

func (x *MapLeafInclusion) GetLeaf() *MapLeaf {
	if x != nil {
		return x.Leaf
	}
	return nil
}

func (x *MapLeafInclusion) GetInclusion() [][]byte {
	if x != nil {
		return x.Inclusion
	}
	return nil
}

type GetMapLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64    `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	Index [][]byte `protobuf:"bytes,2,rep,name=index,proto3" json:"index,omitempty"`
}

func (x *GetMapLeavesRequest) Reset() {
	*x = GetMapLeavesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMapLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMapLeavesRequest) ProtoMessage() {}

func (x *GetMapLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMapLeavesRequest.ProtoReflect.Descriptor instead.
func (*GetMapLeavesRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{3}
}

func (x *GetMapLeavesRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *GetMapLeavesRequest) GetIndex() [][]byte {
	if x != nil {
		return x.Index
	}
	return nil
}

type GetMapLeafRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64  `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	Index []byte `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *GetMapLeafRequest) Reset() {
	*x = GetMapLeafRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMapLeafRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMapLeafRequest) ProtoMessage() {}

func (x *GetMapLeafRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMapLeafRequest.ProtoReflect.Descriptor instead.
func (*GetMapLeafRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{4}
}

func (x *GetMapLeafRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *GetMapLeafRequest) GetIndex() []byte {
	if x != nil {
		return x.Index
	}
	return nil
}

type GetMapLeafByRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId    int64  `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	Index    []byte `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	Revision int64  `protobuf:"varint,3,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *GetMapLeafByRevisionRequest) Reset() {
	*x = GetMapLeafByRevisionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMapLeafByRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMapLeafByRevisionRequest) ProtoMessage() {}

func (x *GetMapLeafByRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMapLeafByRevisionRequest.ProtoReflect.Descriptor instead.
func (*GetMapLeafByRevisionRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{5}
}

func (x *GetMapLeafByRevisionRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *GetMapLeafByRevisionRequest) GetIndex() []byte {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *GetMapLeafByRevisionRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

// This message replaces the current implementation of GetMapLeavesRequest
// with the difference that revision must be >=0.
type GetMapLeavesByRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64 `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	// index(es) to query.  It is an error to request the same index more than once.
	Index [][]byte `protobuf:"bytes,2,rep,name=index,proto3" json:"index,omitempty"`
	// revision >= 0.
	Revision int64 `protobuf:"varint,3,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *GetMapLeavesByRevisionRequest) Reset() {
	*x = GetMapLeavesByRevisionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMapLeavesByRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMapLeavesByRevisionRequest) ProtoMessage() {}

func (x *GetMapLeavesByRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMapLeavesByRevisionRequest.ProtoReflect.Descriptor instead.
func (*GetMapLeavesByRevisionRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{6}
}

func (x *GetMapLeavesByRevisionRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *GetMapLeavesByRevisionRequest) GetIndex() [][]byte {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *GetMapLeavesByRevisionRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

type GetMapLeafResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapLeafInclusion *MapLeafInclusion `protobuf:"bytes,1,opt,name=map_leaf_inclusion,json=mapLeafInclusion,proto3" json:"map_leaf_inclusion,omitempty"`
	MapRoot          *SignedMapRoot    `protobuf:"bytes,2,opt,name=map_root,json=mapRoot,proto3" json:"map_root,omitempty"`
}

func (x *GetMapLeafResponse) Reset() {
	*x = GetMapLeafResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMapLeafResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMapLeafResponse) ProtoMessage() {}

func (x *GetMapLeafResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMapLeafResponse.ProtoReflect.Descriptor instead.
func (*GetMapLeafResponse) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{7}
}

func (x *GetMapLeafResponse) GetMapLeafInclusion() *MapLeafInclusion {
	if x != nil {
		return x.MapLeafInclusion
	}
	return nil
}

func (x *GetMapLeafResponse) GetMapRoot() *SignedMapRoot {
	if x != nil {
		return x.MapRoot
	}
	return nil
}

type GetMapLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapLeafInclusion []*MapLeafInclusion `protobuf:"bytes,2,rep,name=map_leaf_inclusion,json=mapLeafInclusion,proto3" json:"map_leaf_inclusion,omitempty"`
	MapRoot          *SignedMapRoot      `protobuf:"bytes,3,opt,name=map_root,json=mapRoot,proto3" json:"map_root,omitempty"`
}

func (x *GetMapLeavesResponse) Reset() {
	*x = GetMapLeavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMapLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMapLeavesResponse) ProtoMessage() {}

func (x *GetMapLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMapLeavesResponse.ProtoReflect.Descriptor instead.
func (*GetMapLeavesResponse) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{8}
}

func (x *GetMapLeavesResponse) GetMapLeafInclusion() []*MapLeafInclusion {
	if x != nil {
		return x.MapLeafInclusion
	}
	return nil
}

func (x *GetMapLeavesResponse) GetMapRoot() *SignedMapRoot {
	if x != nil {
		return x.MapRoot
	}
	return nil
}

// GetLastInRangeByRevisionRequest specifies a range in the map at a revision.
// The range is defined as the entire subtree below a particular point in the
// Merkle tree. Another way of saying this is that the range matches all leaves
// that share a common prefix of `prefix_bits` with `prefix`.
type GetLastInRangeByRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId    int64  `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	Revision int64  `protobuf:"varint,2,opt,name=revision,proto3" json:"revision,omitempty"`
	Prefix   []byte `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// prefix_bits is the number of bits to include, starting from the left, or
	// most significant bit (MSB).
	PrefixBits int32 `protobuf:"varint,4,opt,name=prefix_bits,json=prefixBits,proto3" json:"prefix_bits,omitempty"`
}

func (x *GetLastInRangeByRevisionRequest) Reset() {
	*x = GetLastInRangeByRevisionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLastInRangeByRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLastInRangeByRevisionRequest) ProtoMessage() {}

func (x *GetLastInRangeByRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLastInRangeByRevisionRequest.ProtoReflect.Descriptor instead.
func (*GetLastInRangeByRevisionRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{9}
}

func (x *GetLastInRangeByRevisionRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *GetLastInRangeByRevisionRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *GetLastInRangeByRevisionRequest) GetPrefix() []byte {
	if x != nil {
		return x.Prefix
	}
	return nil
}

func (x *GetLastInRangeByRevisionRequest) GetPrefixBits() int32 {
	if x != nil {
		return x.PrefixBits
	}
	return 0
}

type SetMapLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64 `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	// The leaves being set must have unique Index values within the request.
	Leaves   []*MapLeaf `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	Metadata []byte     `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The map revision to associate the leaves with. The request will fail if
	// this revision already exists, does not match the current write revision, or
	// is not positive. Note that revision = 0 is reserved for the empty tree.
	Revision int64 `protobuf:"varint,6,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *SetMapLeavesRequest) Reset() {
	*x = SetMapLeavesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMapLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMapLeavesRequest) ProtoMessage() {}

func (x *SetMapLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMapLeavesRequest.ProtoReflect.Descriptor instead.
func (*SetMapLeavesRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{10}
}

func (x *SetMapLeavesRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *SetMapLeavesRequest) GetLeaves() []*MapLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *SetMapLeavesRequest) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *SetMapLeavesRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

type SetMapLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapRoot *SignedMapRoot `protobuf:"bytes,2,opt,name=map_root,json=mapRoot,proto3" json:"map_root,omitempty"`
}

func (x *SetMapLeavesResponse) Reset() {
	*x = SetMapLeavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetMapLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetMapLeavesResponse) ProtoMessage() {}

func (x *SetMapLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetMapLeavesResponse.ProtoReflect.Descriptor instead.
func (*SetMapLeavesResponse) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{11}
}

func (x *SetMapLeavesResponse) GetMapRoot() *SignedMapRoot {
	if x != nil {
		return x.MapRoot
	}
	return nil
}

type WriteMapLeavesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64 `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	// The leaves being set must have unique Index values within the request.
	Leaves []*MapLeaf `protobuf:"bytes,2,rep,name=leaves,proto3" json:"leaves,omitempty"`
	// Metadata that the Map should associate with the new Map root after
	// incorporating the leaf changes.  The metadata will be reflected in the
	// Map Root published for this revision.
	// Map personalities should use metadata to persist any state needed later
	// to continue mapping from an external data source.
	Metadata []byte `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// The map revision to associate the leaves with. The request will fail if
	// this revision already exists, does not match the current write revision, or
	// is not positive. Note that revision = 0 is reserved for the empty tree.
	ExpectRevision int64 `protobuf:"varint,4,opt,name=expect_revision,json=expectRevision,proto3" json:"expect_revision,omitempty"`
}

func (x *WriteMapLeavesRequest) Reset() {
	*x = WriteMapLeavesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteMapLeavesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteMapLeavesRequest) ProtoMessage() {}

func (x *WriteMapLeavesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteMapLeavesRequest.ProtoReflect.Descriptor instead.
func (*WriteMapLeavesRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{12}
}

func (x *WriteMapLeavesRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *WriteMapLeavesRequest) GetLeaves() []*MapLeaf {
	if x != nil {
		return x.Leaves
	}
	return nil
}

func (x *WriteMapLeavesRequest) GetMetadata() []byte {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *WriteMapLeavesRequest) GetExpectRevision() int64 {
	if x != nil {
		return x.ExpectRevision
	}
	return 0
}

type WriteMapLeavesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The map revision that the leaves will be published at.
	// This may be accompanied by a proof that the write request has been included
	// in an input log in the future.
	Revision int64 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *WriteMapLeavesResponse) Reset() {
	*x = WriteMapLeavesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteMapLeavesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteMapLeavesResponse) ProtoMessage() {}

func (x *WriteMapLeavesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteMapLeavesResponse.ProtoReflect.Descriptor instead.
func (*WriteMapLeavesResponse) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{13}
}

func (x *WriteMapLeavesResponse) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

type GetSignedMapRootRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64 `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
}

func (x *GetSignedMapRootRequest) Reset() {
	*x = GetSignedMapRootRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSignedMapRootRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSignedMapRootRequest) ProtoMessage() {}

func (x *GetSignedMapRootRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSignedMapRootRequest.ProtoReflect.Descriptor instead.
func (*GetSignedMapRootRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{14}
}

func (x *GetSignedMapRootRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

type GetSignedMapRootByRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId    int64 `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
	Revision int64 `protobuf:"varint,2,opt,name=revision,proto3" json:"revision,omitempty"`
}

func (x *GetSignedMapRootByRevisionRequest) Reset() {
	*x = GetSignedMapRootByRevisionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSignedMapRootByRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSignedMapRootByRevisionRequest) ProtoMessage() {}

func (x *GetSignedMapRootByRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSignedMapRootByRevisionRequest.ProtoReflect.Descriptor instead.
func (*GetSignedMapRootByRevisionRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{15}
}

func (x *GetSignedMapRootByRevisionRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

func (x *GetSignedMapRootByRevisionRequest) GetRevision() int64 {
	if x != nil {
		return x.Revision
	}
	return 0
}

type GetSignedMapRootResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapRoot *SignedMapRoot `protobuf:"bytes,2,opt,name=map_root,json=mapRoot,proto3" json:"map_root,omitempty"`
}

func (x *GetSignedMapRootResponse) Reset() {
	*x = GetSignedMapRootResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSignedMapRootResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSignedMapRootResponse) ProtoMessage() {}

func (x *GetSignedMapRootResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSignedMapRootResponse.ProtoReflect.Descriptor instead.
func (*GetSignedMapRootResponse) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{16}
}

func (x *GetSignedMapRootResponse) GetMapRoot() *SignedMapRoot {
	if x != nil {
		return x.MapRoot
	}
	return nil
}

type InitMapRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	MapId int64 `protobuf:"varint,1,opt,name=map_id,json=mapId,proto3" json:"map_id,omitempty"`
}

func (x *InitMapRequest) Reset() {
	*x = InitMapRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitMapRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitMapRequest) ProtoMessage() {}

func (x *InitMapRequest) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitMapRequest.ProtoReflect.Descriptor instead.
func (*InitMapRequest) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{17}
}

func (x *InitMapRequest) GetMapId() int64 {
	if x != nil {
		return x.MapId
	}
	return 0
}

type InitMapResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Created *SignedMapRoot `protobuf:"bytes,1,opt,name=created,proto3" json:"created,omitempty"`
}

func (x *InitMapResponse) Reset() {
	*x = InitMapResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_trillian_map_api_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InitMapResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitMapResponse) ProtoMessage() {}

func (x *InitMapResponse) ProtoReflect() protoreflect.Message {
	mi := &file_trillian_map_api_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitMapResponse.ProtoReflect.Descriptor instead.
func (*InitMapResponse) Descriptor() ([]byte, []int) {
	return file_trillian_map_api_proto_rawDescGZIP(), []int{18}
}

func (x *InitMapResponse) GetCreated() *SignedMapRoot {
	if x != nil {
		return x.Created
	}
	return nil
}

var File_trillian_map_api_proto protoreflect.FileDescriptor

var file_trillian_map_api_proto_rawDesc = []byte{
	0x0a, 0x16, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x5f, 0x6d, 0x61, 0x70, 0x5f, 0x61,
	0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x08, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x1a, 0x0e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x7a, 0x0a, 0x07, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x14, 0x0a, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x68, 0x61, 0x73, 0x68, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6c, 0x65, 0x61, 0x66, 0x48, 0x61, 0x73, 0x68, 0x12, 0x1d,
	0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a,
	0x0a, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x65, 0x78, 0x74, 0x72, 0x61, 0x44, 0x61, 0x74, 0x61, 0x22, 0x36, 0x0a, 0x09,
	0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61,
	0x76, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x22, 0x57, 0x0a, 0x10, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x49,
	0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x04, 0x6c, 0x65, 0x61, 0x66,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x04, 0x6c, 0x65, 0x61, 0x66, 0x12,
	0x1c, 0x0a, 0x09, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0c, 0x52, 0x09, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x48, 0x0a,
	0x13, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x22, 0x40, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4d, 0x61,
	0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06,
	0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61,
	0x70, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x66, 0x0a, 0x1b, 0x47, 0x65, 0x74,
	0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x12,
	0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x22, 0x68, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x6d, 0x61, 0x70, 0x5f, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61,
	0x66, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6d, 0x61, 0x70, 0x4c,
	0x65, 0x61, 0x66, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x08,
	0x6d, 0x61, 0x70, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74,
	0x22, 0x94, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x6d, 0x61, 0x70,
	0x5f, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e,
	0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x10, 0x6d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x32, 0x0a, 0x08, 0x6d, 0x61, 0x70, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e,
	0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x07,
	0x6d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x22, 0x8d, 0x01, 0x0a, 0x1f, 0x47, 0x65, 0x74, 0x4c,
	0x61, 0x73, 0x74, 0x49, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d,
	0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70,
	0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78,
	0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x42, 0x69, 0x74, 0x73, 0x22, 0x9b, 0x01, 0x0a, 0x13, 0x53, 0x65, 0x74, 0x4d,
	0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61,
	0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1a, 0x0a,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a,
	0x04, 0x08, 0x04, 0x10, 0x05, 0x22, 0x4a, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c,
	0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32, 0x0a,
	0x08, 0x6d, 0x61, 0x70, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x52, 0x6f, 0x6f,
	0x74, 0x22, 0x9e, 0x01, 0x0a, 0x15, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d,
	0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70,
	0x49, 0x64, 0x12, 0x29, 0x0a, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4d, 0x61,
	0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x06, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x12, 0x1a, 0x0a,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x27, 0x0a, 0x0f, 0x65, 0x78, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x34, 0x0a, 0x16, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x0a, 0x08,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x30, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x22, 0x56, 0x0a, 0x21, 0x47, 0x65,
	0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x42, 0x79,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0x4e, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d,
	0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x32,
	0x0a, 0x08, 0x6d, 0x61, 0x70, 0x5f, 0x72, 0x6f, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x07, 0x6d, 0x61, 0x70, 0x52, 0x6f,
	0x6f, 0x74, 0x22, 0x27, 0x0a, 0x0e, 0x49, 0x6e, 0x69, 0x74, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6d, 0x61, 0x70, 0x49, 0x64, 0x22, 0x44, 0x0a, 0x0f, 0x49,
	0x6e, 0x69, 0x74, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x31,
	0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x32, 0xc3, 0x08, 0x0a, 0x0b, 0x54, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x4d, 0x61,
	0x70, 0x12, 0x46, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x66, 0x12, 0x1b, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65,
	0x61, 0x66, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x74, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5a, 0x0a, 0x11, 0x47, 0x65, 0x74,
	0x4c, 0x65, 0x61, 0x66, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70,
	0x4c, 0x65, 0x61, 0x66, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1c, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e,
	0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x66, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x4c, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x12, 0x1d, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65,
	0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74,
	0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x00, 0x12, 0x60, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73,
	0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x2e, 0x74, 0x72, 0x69,
	0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x00, 0x12, 0x5f, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x6f, 0x50, 0x72,
	0x6f, 0x6f, 0x66, 0x12, 0x27, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x9e, 0x01, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x4c, 0x61,
	0x73, 0x74, 0x49, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x29, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47,
	0x65, 0x74, 0x4c, 0x61, 0x73, 0x74, 0x49, 0x6e, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x79, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x11,
	0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61,
	0x66, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x12, 0x3c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x3a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x69,
	0x6e, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x4f, 0x0a, 0x09, 0x53, 0x65, 0x74, 0x4c, 0x65,
	0x61, 0x76, 0x65, 0x73, 0x12, 0x1d, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e,
	0x53, 0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x53,
	0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x88, 0x02, 0x01, 0x12, 0x86, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74,
	0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x12, 0x21, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x22, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12, 0x23, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x70,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x3a, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x12, 0x9e, 0x01, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d,
	0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x2b, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x42, 0x79, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x4d, 0x61, 0x70, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x2f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x64,
	0x7d, 0x2f, 0x72, 0x6f, 0x6f, 0x74, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x12, 0x63, 0x0a, 0x07, 0x49, 0x6e, 0x69, 0x74, 0x4d, 0x61, 0x70, 0x12, 0x18, 0x2e,
	0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x4d, 0x61, 0x70,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69,
	0x61, 0x6e, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x4d, 0x61, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x22, 0x1b, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x70, 0x5f, 0x69,
	0x64, 0x7d, 0x3a, 0x69, 0x6e, 0x69, 0x74, 0x32, 0xbd, 0x01, 0x0a, 0x10, 0x54, 0x72, 0x69, 0x6c,
	0x6c, 0x69, 0x61, 0x6e, 0x4d, 0x61, 0x70, 0x57, 0x72, 0x69, 0x74, 0x65, 0x12, 0x55, 0x0a, 0x13,
	0x47, 0x65, 0x74, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x27, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x47,
	0x65, 0x74, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x42, 0x79, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x13, 0x2e, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65,
	0x73, 0x22, 0x00, 0x12, 0x52, 0x0a, 0x0b, 0x57, 0x72, 0x69, 0x74, 0x65, 0x4c, 0x65, 0x61, 0x76,
	0x65, 0x73, 0x12, 0x1f, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x4d, 0x61, 0x70, 0x4c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x42, 0x4e, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x42, 0x13, 0x54, 0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x4d, 0x61,
	0x70, 0x41, 0x70, 0x69, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x1a, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_trillian_map_api_proto_rawDescOnce sync.Once
	file_trillian_map_api_proto_rawDescData = file_trillian_map_api_proto_rawDesc
)

func file_trillian_map_api_proto_rawDescGZIP() []byte {
	file_trillian_map_api_proto_rawDescOnce.Do(func() {
		file_trillian_map_api_proto_rawDescData = protoimpl.X.CompressGZIP(file_trillian_map_api_proto_rawDescData)
	})
	return file_trillian_map_api_proto_rawDescData
}

var file_trillian_map_api_proto_msgTypes = make([]protoimpl.MessageInfo, 19)
var file_trillian_map_api_proto_goTypes = []interface{}{
	(*MapLeaf)(nil),                           // 0: trillian.MapLeaf
	(*MapLeaves)(nil),                         // 1: trillian.MapLeaves
	(*MapLeafInclusion)(nil),                  // 2: trillian.MapLeafInclusion
	(*GetMapLeavesRequest)(nil),               // 3: trillian.GetMapLeavesRequest
	(*GetMapLeafRequest)(nil),                 // 4: trillian.GetMapLeafRequest
	(*GetMapLeafByRevisionRequest)(nil),       // 5: trillian.GetMapLeafByRevisionRequest
	(*GetMapLeavesByRevisionRequest)(nil),     // 6: trillian.GetMapLeavesByRevisionRequest
	(*GetMapLeafResponse)(nil),                // 7: trillian.GetMapLeafResponse
	(*GetMapLeavesResponse)(nil),              // 8: trillian.GetMapLeavesResponse
	(*GetLastInRangeByRevisionRequest)(nil),   // 9: trillian.GetLastInRangeByRevisionRequest
	(*SetMapLeavesRequest)(nil),               // 10: trillian.SetMapLeavesRequest
	(*SetMapLeavesResponse)(nil),              // 11: trillian.SetMapLeavesResponse
	(*WriteMapLeavesRequest)(nil),             // 12: trillian.WriteMapLeavesRequest
	(*WriteMapLeavesResponse)(nil),            // 13: trillian.WriteMapLeavesResponse
	(*GetSignedMapRootRequest)(nil),           // 14: trillian.GetSignedMapRootRequest
	(*GetSignedMapRootByRevisionRequest)(nil), // 15: trillian.GetSignedMapRootByRevisionRequest
	(*GetSignedMapRootResponse)(nil),          // 16: trillian.GetSignedMapRootResponse
	(*InitMapRequest)(nil),                    // 17: trillian.InitMapRequest
	(*InitMapResponse)(nil),                   // 18: trillian.InitMapResponse
	(*SignedMapRoot)(nil),                     // 19: trillian.SignedMapRoot
}
var file_trillian_map_api_proto_depIdxs = []int32{
	0,  // 0: trillian.MapLeaves.leaves:type_name -> trillian.MapLeaf
	0,  // 1: trillian.MapLeafInclusion.leaf:type_name -> trillian.MapLeaf
	2,  // 2: trillian.GetMapLeafResponse.map_leaf_inclusion:type_name -> trillian.MapLeafInclusion
	19, // 3: trillian.GetMapLeafResponse.map_root:type_name -> trillian.SignedMapRoot
	2,  // 4: trillian.GetMapLeavesResponse.map_leaf_inclusion:type_name -> trillian.MapLeafInclusion
	19, // 5: trillian.GetMapLeavesResponse.map_root:type_name -> trillian.SignedMapRoot
	0,  // 6: trillian.SetMapLeavesRequest.leaves:type_name -> trillian.MapLeaf
	19, // 7: trillian.SetMapLeavesResponse.map_root:type_name -> trillian.SignedMapRoot
	0,  // 8: trillian.WriteMapLeavesRequest.leaves:type_name -> trillian.MapLeaf
	19, // 9: trillian.GetSignedMapRootResponse.map_root:type_name -> trillian.SignedMapRoot
	19, // 10: trillian.InitMapResponse.created:type_name -> trillian.SignedMapRoot
	4,  // 11: trillian.TrillianMap.GetLeaf:input_type -> trillian.GetMapLeafRequest
	5,  // 12: trillian.TrillianMap.GetLeafByRevision:input_type -> trillian.GetMapLeafByRevisionRequest
	3,  // 13: trillian.TrillianMap.GetLeaves:input_type -> trillian.GetMapLeavesRequest
	6,  // 14: trillian.TrillianMap.GetLeavesByRevision:input_type -> trillian.GetMapLeavesByRevisionRequest
	6,  // 15: trillian.TrillianMap.GetLeavesByRevisionNoProof:input_type -> trillian.GetMapLeavesByRevisionRequest
	9,  // 16: trillian.TrillianMap.GetLastInRangeByRevision:input_type -> trillian.GetLastInRangeByRevisionRequest
	10, // 17: trillian.TrillianMap.SetLeaves:input_type -> trillian.SetMapLeavesRequest
	14, // 18: trillian.TrillianMap.GetSignedMapRoot:input_type -> trillian.GetSignedMapRootRequest
	15, // 19: trillian.TrillianMap.GetSignedMapRootByRevision:input_type -> trillian.GetSignedMapRootByRevisionRequest
	17, // 20: trillian.TrillianMap.InitMap:input_type -> trillian.InitMapRequest
	6,  // 21: trillian.TrillianMapWrite.GetLeavesByRevision:input_type -> trillian.GetMapLeavesByRevisionRequest
	12, // 22: trillian.TrillianMapWrite.WriteLeaves:input_type -> trillian.WriteMapLeavesRequest
	7,  // 23: trillian.TrillianMap.GetLeaf:output_type -> trillian.GetMapLeafResponse
	7,  // 24: trillian.TrillianMap.GetLeafByRevision:output_type -> trillian.GetMapLeafResponse
	8,  // 25: trillian.TrillianMap.GetLeaves:output_type -> trillian.GetMapLeavesResponse
	8,  // 26: trillian.TrillianMap.GetLeavesByRevision:output_type -> trillian.GetMapLeavesResponse
	1,  // 27: trillian.TrillianMap.GetLeavesByRevisionNoProof:output_type -> trillian.MapLeaves
	0,  // 28: trillian.TrillianMap.GetLastInRangeByRevision:output_type -> trillian.MapLeaf
	11, // 29: trillian.TrillianMap.SetLeaves:output_type -> trillian.SetMapLeavesResponse
	16, // 30: trillian.TrillianMap.GetSignedMapRoot:output_type -> trillian.GetSignedMapRootResponse
	16, // 31: trillian.TrillianMap.GetSignedMapRootByRevision:output_type -> trillian.GetSignedMapRootResponse
	18, // 32: trillian.TrillianMap.InitMap:output_type -> trillian.InitMapResponse
	1,  // 33: trillian.TrillianMapWrite.GetLeavesByRevision:output_type -> trillian.MapLeaves
	13, // 34: trillian.TrillianMapWrite.WriteLeaves:output_type -> trillian.WriteMapLeavesResponse
	23, // [23:35] is the sub-list for method output_type
	11, // [11:23] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_trillian_map_api_proto_init() }
func file_trillian_map_api_proto_init() {
	if File_trillian_map_api_proto != nil {
		return
	}
	file_trillian_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_trillian_map_api_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapLeaf); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapLeaves); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MapLeafInclusion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMapLeavesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMapLeafRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMapLeafByRevisionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMapLeavesByRevisionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMapLeafResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMapLeavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetLastInRangeByRevisionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMapLeavesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetMapLeavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteMapLeavesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteMapLeavesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSignedMapRootRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSignedMapRootByRevisionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSignedMapRootResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitMapRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_trillian_map_api_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InitMapResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_trillian_map_api_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   19,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_trillian_map_api_proto_goTypes,
		DependencyIndexes: file_trillian_map_api_proto_depIdxs,
		MessageInfos:      file_trillian_map_api_proto_msgTypes,
	}.Build()
	File_trillian_map_api_proto = out.File
	file_trillian_map_api_proto_rawDesc = nil
	file_trillian_map_api_proto_goTypes = nil
	file_trillian_map_api_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TrillianMapClient is the client API for TrillianMap service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TrillianMapClient interface {
	// GetLeaves returns an inclusion proof for each index requested.
	// For indexes that do not exist, the inclusion proof will use nil for the
	// empty leaf value.
	GetLeaf(ctx context.Context, in *GetMapLeafRequest, opts ...grpc.CallOption) (*GetMapLeafResponse, error)
	GetLeafByRevision(ctx context.Context, in *GetMapLeafByRevisionRequest, opts ...grpc.CallOption) (*GetMapLeafResponse, error)
	GetLeaves(ctx context.Context, in *GetMapLeavesRequest, opts ...grpc.CallOption) (*GetMapLeavesResponse, error)
	GetLeavesByRevision(ctx context.Context, in *GetMapLeavesByRevisionRequest, opts ...grpc.CallOption) (*GetMapLeavesResponse, error)
	// Deprecated: Do not use.
	// Deprecated: this should only be used by writers, which should migrate
	// to TrillianMapWrite#GetLeavesByRevision
	GetLeavesByRevisionNoProof(ctx context.Context, in *GetMapLeavesByRevisionRequest, opts ...grpc.CallOption) (*MapLeaves, error)
	// GetLastInRangeByRevision returns the last leaf in a requested range.
	GetLastInRangeByRevision(ctx context.Context, in *GetLastInRangeByRevisionRequest, opts ...grpc.CallOption) (*MapLeaf, error)
	// Deprecated: Do not use.
	// Deprecated: this should only be used by writers, which should migrate
	// to TrillianMapWrite#WriteLeaves
	SetLeaves(ctx context.Context, in *SetMapLeavesRequest, opts ...grpc.CallOption) (*SetMapLeavesResponse, error)
	GetSignedMapRoot(ctx context.Context, in *GetSignedMapRootRequest, opts ...grpc.CallOption) (*GetSignedMapRootResponse, error)
	GetSignedMapRootByRevision(ctx context.Context, in *GetSignedMapRootByRevisionRequest, opts ...grpc.CallOption) (*GetSignedMapRootResponse, error)
	InitMap(ctx context.Context, in *InitMapRequest, opts ...grpc.CallOption) (*InitMapResponse, error)
}

type trillianMapClient struct {
	cc grpc.ClientConnInterface
}

func NewTrillianMapClient(cc grpc.ClientConnInterface) TrillianMapClient {
	return &trillianMapClient{cc}
}

func (c *trillianMapClient) GetLeaf(ctx context.Context, in *GetMapLeafRequest, opts ...grpc.CallOption) (*GetMapLeafResponse, error) {
	out := new(GetMapLeafResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetLeaf", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) GetLeafByRevision(ctx context.Context, in *GetMapLeafByRevisionRequest, opts ...grpc.CallOption) (*GetMapLeafResponse, error) {
	out := new(GetMapLeafResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetLeafByRevision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) GetLeaves(ctx context.Context, in *GetMapLeavesRequest, opts ...grpc.CallOption) (*GetMapLeavesResponse, error) {
	out := new(GetMapLeavesResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetLeaves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) GetLeavesByRevision(ctx context.Context, in *GetMapLeavesByRevisionRequest, opts ...grpc.CallOption) (*GetMapLeavesResponse, error) {
	out := new(GetMapLeavesResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetLeavesByRevision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *trillianMapClient) GetLeavesByRevisionNoProof(ctx context.Context, in *GetMapLeavesByRevisionRequest, opts ...grpc.CallOption) (*MapLeaves, error) {
	out := new(MapLeaves)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetLeavesByRevisionNoProof", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) GetLastInRangeByRevision(ctx context.Context, in *GetLastInRangeByRevisionRequest, opts ...grpc.CallOption) (*MapLeaf, error) {
	out := new(MapLeaf)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetLastInRangeByRevision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *trillianMapClient) SetLeaves(ctx context.Context, in *SetMapLeavesRequest, opts ...grpc.CallOption) (*SetMapLeavesResponse, error) {
	out := new(SetMapLeavesResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/SetLeaves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) GetSignedMapRoot(ctx context.Context, in *GetSignedMapRootRequest, opts ...grpc.CallOption) (*GetSignedMapRootResponse, error) {
	out := new(GetSignedMapRootResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetSignedMapRoot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) GetSignedMapRootByRevision(ctx context.Context, in *GetSignedMapRootByRevisionRequest, opts ...grpc.CallOption) (*GetSignedMapRootResponse, error) {
	out := new(GetSignedMapRootResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/GetSignedMapRootByRevision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapClient) InitMap(ctx context.Context, in *InitMapRequest, opts ...grpc.CallOption) (*InitMapResponse, error) {
	out := new(InitMapResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMap/InitMap", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TrillianMapServer is the server API for TrillianMap service.
type TrillianMapServer interface {
	// GetLeaves returns an inclusion proof for each index requested.
	// For indexes that do not exist, the inclusion proof will use nil for the
	// empty leaf value.
	GetLeaf(context.Context, *GetMapLeafRequest) (*GetMapLeafResponse, error)
	GetLeafByRevision(context.Context, *GetMapLeafByRevisionRequest) (*GetMapLeafResponse, error)
	GetLeaves(context.Context, *GetMapLeavesRequest) (*GetMapLeavesResponse, error)
	GetLeavesByRevision(context.Context, *GetMapLeavesByRevisionRequest) (*GetMapLeavesResponse, error)
	// Deprecated: Do not use.
	// Deprecated: this should only be used by writers, which should migrate
	// to TrillianMapWrite#GetLeavesByRevision
	GetLeavesByRevisionNoProof(context.Context, *GetMapLeavesByRevisionRequest) (*MapLeaves, error)
	// GetLastInRangeByRevision returns the last leaf in a requested range.
	GetLastInRangeByRevision(context.Context, *GetLastInRangeByRevisionRequest) (*MapLeaf, error)
	// Deprecated: Do not use.
	// Deprecated: this should only be used by writers, which should migrate
	// to TrillianMapWrite#WriteLeaves
	SetLeaves(context.Context, *SetMapLeavesRequest) (*SetMapLeavesResponse, error)
	GetSignedMapRoot(context.Context, *GetSignedMapRootRequest) (*GetSignedMapRootResponse, error)
	GetSignedMapRootByRevision(context.Context, *GetSignedMapRootByRevisionRequest) (*GetSignedMapRootResponse, error)
	InitMap(context.Context, *InitMapRequest) (*InitMapResponse, error)
}

// UnimplementedTrillianMapServer can be embedded to have forward compatible implementations.
type UnimplementedTrillianMapServer struct {
}

func (*UnimplementedTrillianMapServer) GetLeaf(context.Context, *GetMapLeafRequest) (*GetMapLeafResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLeaf not implemented")
}
func (*UnimplementedTrillianMapServer) GetLeafByRevision(context.Context, *GetMapLeafByRevisionRequest) (*GetMapLeafResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLeafByRevision not implemented")
}
func (*UnimplementedTrillianMapServer) GetLeaves(context.Context, *GetMapLeavesRequest) (*GetMapLeavesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLeaves not implemented")
}
func (*UnimplementedTrillianMapServer) GetLeavesByRevision(context.Context, *GetMapLeavesByRevisionRequest) (*GetMapLeavesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLeavesByRevision not implemented")
}
func (*UnimplementedTrillianMapServer) GetLeavesByRevisionNoProof(context.Context, *GetMapLeavesByRevisionRequest) (*MapLeaves, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLeavesByRevisionNoProof not implemented")
}
func (*UnimplementedTrillianMapServer) GetLastInRangeByRevision(context.Context, *GetLastInRangeByRevisionRequest) (*MapLeaf, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLastInRangeByRevision not implemented")
}
func (*UnimplementedTrillianMapServer) SetLeaves(context.Context, *SetMapLeavesRequest) (*SetMapLeavesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLeaves not implemented")
}
func (*UnimplementedTrillianMapServer) GetSignedMapRoot(context.Context, *GetSignedMapRootRequest) (*GetSignedMapRootResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSignedMapRoot not implemented")
}
func (*UnimplementedTrillianMapServer) GetSignedMapRootByRevision(context.Context, *GetSignedMapRootByRevisionRequest) (*GetSignedMapRootResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSignedMapRootByRevision not implemented")
}
func (*UnimplementedTrillianMapServer) InitMap(context.Context, *InitMapRequest) (*InitMapResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InitMap not implemented")
}

func RegisterTrillianMapServer(s *grpc.Server, srv TrillianMapServer) {
	s.RegisterService(&_TrillianMap_serviceDesc, srv)
}

func _TrillianMap_GetLeaf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMapLeafRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetLeaf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetLeaf",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetLeaf(ctx, req.(*GetMapLeafRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetLeafByRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMapLeafByRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetLeafByRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetLeafByRevision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetLeafByRevision(ctx, req.(*GetMapLeafByRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetLeaves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMapLeavesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetLeaves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetLeaves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetLeaves(ctx, req.(*GetMapLeavesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetLeavesByRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMapLeavesByRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetLeavesByRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetLeavesByRevision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetLeavesByRevision(ctx, req.(*GetMapLeavesByRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetLeavesByRevisionNoProof_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMapLeavesByRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetLeavesByRevisionNoProof(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetLeavesByRevisionNoProof",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetLeavesByRevisionNoProof(ctx, req.(*GetMapLeavesByRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetLastInRangeByRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLastInRangeByRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetLastInRangeByRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetLastInRangeByRevision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetLastInRangeByRevision(ctx, req.(*GetLastInRangeByRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_SetLeaves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMapLeavesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).SetLeaves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/SetLeaves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).SetLeaves(ctx, req.(*SetMapLeavesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetSignedMapRoot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSignedMapRootRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetSignedMapRoot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetSignedMapRoot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetSignedMapRoot(ctx, req.(*GetSignedMapRootRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_GetSignedMapRootByRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSignedMapRootByRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).GetSignedMapRootByRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/GetSignedMapRootByRevision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).GetSignedMapRootByRevision(ctx, req.(*GetSignedMapRootByRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMap_InitMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapServer).InitMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMap/InitMap",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapServer).InitMap(ctx, req.(*InitMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TrillianMap_serviceDesc = grpc.ServiceDesc{
	ServiceName: "trillian.TrillianMap",
	HandlerType: (*TrillianMapServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLeaf",
			Handler:    _TrillianMap_GetLeaf_Handler,
		},
		{
			MethodName: "GetLeafByRevision",
			Handler:    _TrillianMap_GetLeafByRevision_Handler,
		},
		{
			MethodName: "GetLeaves",
			Handler:    _TrillianMap_GetLeaves_Handler,
		},
		{
			MethodName: "GetLeavesByRevision",
			Handler:    _TrillianMap_GetLeavesByRevision_Handler,
		},
		{
			MethodName: "GetLeavesByRevisionNoProof",
			Handler:    _TrillianMap_GetLeavesByRevisionNoProof_Handler,
		},
		{
			MethodName: "GetLastInRangeByRevision",
			Handler:    _TrillianMap_GetLastInRangeByRevision_Handler,
		},
		{
			MethodName: "SetLeaves",
			Handler:    _TrillianMap_SetLeaves_Handler,
		},
		{
			MethodName: "GetSignedMapRoot",
			Handler:    _TrillianMap_GetSignedMapRoot_Handler,
		},
		{
			MethodName: "GetSignedMapRootByRevision",
			Handler:    _TrillianMap_GetSignedMapRootByRevision_Handler,
		},
		{
			MethodName: "InitMap",
			Handler:    _TrillianMap_InitMap_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "trillian_map_api.proto",
}

// TrillianMapWriteClient is the client API for TrillianMapWrite service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TrillianMapWriteClient interface {
	// GetLeavesByRevision returns the requested map leaves without inclusion proofs.
	// This API is designed for internal use where verification is not needed.
	GetLeavesByRevision(ctx context.Context, in *GetMapLeavesByRevisionRequest, opts ...grpc.CallOption) (*MapLeaves, error)
	// WriteLeaves sets the values for the provided leaves, and returns the new map
	// revision if successful.
	WriteLeaves(ctx context.Context, in *WriteMapLeavesRequest, opts ...grpc.CallOption) (*WriteMapLeavesResponse, error)
}

type trillianMapWriteClient struct {
	cc grpc.ClientConnInterface
}

func NewTrillianMapWriteClient(cc grpc.ClientConnInterface) TrillianMapWriteClient {
	return &trillianMapWriteClient{cc}
}

func (c *trillianMapWriteClient) GetLeavesByRevision(ctx context.Context, in *GetMapLeavesByRevisionRequest, opts ...grpc.CallOption) (*MapLeaves, error) {
	out := new(MapLeaves)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMapWrite/GetLeavesByRevision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *trillianMapWriteClient) WriteLeaves(ctx context.Context, in *WriteMapLeavesRequest, opts ...grpc.CallOption) (*WriteMapLeavesResponse, error) {
	out := new(WriteMapLeavesResponse)
	err := c.cc.Invoke(ctx, "/trillian.TrillianMapWrite/WriteLeaves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TrillianMapWriteServer is the server API for TrillianMapWrite service.
type TrillianMapWriteServer interface {
	// GetLeavesByRevision returns the requested map leaves without inclusion proofs.
	// This API is designed for internal use where verification is not needed.
	GetLeavesByRevision(context.Context, *GetMapLeavesByRevisionRequest) (*MapLeaves, error)
	// WriteLeaves sets the values for the provided leaves, and returns the new map
	// revision if successful.
	WriteLeaves(context.Context, *WriteMapLeavesRequest) (*WriteMapLeavesResponse, error)
}

// UnimplementedTrillianMapWriteServer can be embedded to have forward compatible implementations.
type UnimplementedTrillianMapWriteServer struct {
}

func (*UnimplementedTrillianMapWriteServer) GetLeavesByRevision(context.Context, *GetMapLeavesByRevisionRequest) (*MapLeaves, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLeavesByRevision not implemented")
}
func (*UnimplementedTrillianMapWriteServer) WriteLeaves(context.Context, *WriteMapLeavesRequest) (*WriteMapLeavesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method WriteLeaves not implemented")
}

func RegisterTrillianMapWriteServer(s *grpc.Server, srv TrillianMapWriteServer) {
	s.RegisterService(&_TrillianMapWrite_serviceDesc, srv)
}

func _TrillianMapWrite_GetLeavesByRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMapLeavesByRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapWriteServer).GetLeavesByRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMapWrite/GetLeavesByRevision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapWriteServer).GetLeavesByRevision(ctx, req.(*GetMapLeavesByRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TrillianMapWrite_WriteLeaves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WriteMapLeavesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TrillianMapWriteServer).WriteLeaves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/trillian.TrillianMapWrite/WriteLeaves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TrillianMapWriteServer).WriteLeaves(ctx, req.(*WriteMapLeavesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TrillianMapWrite_serviceDesc = grpc.ServiceDesc{
	ServiceName: "trillian.TrillianMapWrite",
	HandlerType: (*TrillianMapWriteServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetLeavesByRevision",
			Handler:    _TrillianMapWrite_GetLeavesByRevision_Handler,
		},
		{
			MethodName: "WriteLeaves",
			Handler:    _TrillianMapWrite_WriteLeaves_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "trillian_map_api.proto",
}
