//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armeventhub_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventhub/armeventhub"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b574e2a41acda14a90ef237006e8bbdda2b63c63/specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/ApplicationGroup/ApplicationGroupListByNamespace.json
func ExampleApplicationGroupClient_NewListByNamespacePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewApplicationGroupClient().NewListByNamespacePager("contosotest", "contoso-ua-test-eh-system-1", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ApplicationGroupListResult = armeventhub.ApplicationGroupListResult{
		// 	Value: []*armeventhub.ApplicationGroup{
		// 		{
		// 			Name: to.Ptr("appGroup1"),
		// 			Type: to.Ptr("Microsoft.EventHub/Namespaces/ApplicationGroups"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosotest/providers/Microsoft.EventHub/namespaces/contoso-ua-test-eh-system-1/applicationgroups/appGroup1"),
		// 			Location: to.Ptr("EAST US 2 EUAP"),
		// 			Properties: &armeventhub.ApplicationGroupProperties{
		// 				ClientAppGroupIdentifier: to.Ptr("SASKeyName=KeyName"),
		// 				IsEnabled: to.Ptr(true),
		// 				Policies: []armeventhub.ApplicationGroupPolicyClassification{
		// 					&armeventhub.ThrottlingPolicy{
		// 						Name: to.Ptr("ThrottlingPolicy1"),
		// 						Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
		// 						MetricID: to.Ptr(armeventhub.MetricIDIncomingMessages),
		// 						RateLimitThreshold: to.Ptr[int64](7912),
		// 					},
		// 					&armeventhub.ThrottlingPolicy{
		// 						Name: to.Ptr("ThrottlingPolicy2"),
		// 						Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
		// 						MetricID: to.Ptr(armeventhub.MetricIDIncomingBytes),
		// 						RateLimitThreshold: to.Ptr[int64](3951729),
		// 					},
		// 					&armeventhub.ThrottlingPolicy{
		// 						Name: to.Ptr("ThrottlingPolicy3"),
		// 						Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
		// 						MetricID: to.Ptr(armeventhub.MetricIDOutgoingBytes),
		// 						RateLimitThreshold: to.Ptr[int64](245175),
		// 				}},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("appGroup2"),
		// 			Type: to.Ptr("Microsoft.EventHub/Namespaces/ApplicationGroups"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosotest/providers/Microsoft.EventHub/namespaces/contoso-ua-test-eh-system-1/applicationgroups/appGroup2"),
		// 			Location: to.Ptr("EAST US 2 EUAP"),
		// 			Properties: &armeventhub.ApplicationGroupProperties{
		// 				ClientAppGroupIdentifier: to.Ptr("AADAppID=Guid"),
		// 				IsEnabled: to.Ptr(false),
		// 				Policies: []armeventhub.ApplicationGroupPolicyClassification{
		// 					&armeventhub.ThrottlingPolicy{
		// 						Name: to.Ptr("ThrottlingPolicy1"),
		// 						Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
		// 						MetricID: to.Ptr(armeventhub.MetricIDIncomingMessages),
		// 						RateLimitThreshold: to.Ptr[int64](9984),
		// 					},
		// 					&armeventhub.ThrottlingPolicy{
		// 						Name: to.Ptr("ThrottlingPolicy2"),
		// 						Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
		// 						MetricID: to.Ptr(armeventhub.MetricIDIncomingBytes),
		// 						RateLimitThreshold: to.Ptr[int64](7823412),
		// 					},
		// 					&armeventhub.ThrottlingPolicy{
		// 						Name: to.Ptr("ThrottlingPolicy3"),
		// 						Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
		// 						MetricID: to.Ptr(armeventhub.MetricIDOutgoingBytes),
		// 						RateLimitThreshold: to.Ptr[int64](331665),
		// 				}},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b574e2a41acda14a90ef237006e8bbdda2b63c63/specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/ApplicationGroup/ApplicationGroupCreate.json
func ExampleApplicationGroupClient_CreateOrUpdateApplicationGroup() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGroupClient().CreateOrUpdateApplicationGroup(ctx, "contosotest", "contoso-ua-test-eh-system-1", "appGroup1", armeventhub.ApplicationGroup{
		Properties: &armeventhub.ApplicationGroupProperties{
			ClientAppGroupIdentifier: to.Ptr("SASKeyName=KeyName"),
			IsEnabled:                to.Ptr(true),
			Policies: []armeventhub.ApplicationGroupPolicyClassification{
				&armeventhub.ThrottlingPolicy{
					Name:               to.Ptr("ThrottlingPolicy1"),
					Type:               to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
					MetricID:           to.Ptr(armeventhub.MetricIDIncomingMessages),
					RateLimitThreshold: to.Ptr[int64](7912),
				},
				&armeventhub.ThrottlingPolicy{
					Name:               to.Ptr("ThrottlingPolicy2"),
					Type:               to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
					MetricID:           to.Ptr(armeventhub.MetricIDIncomingBytes),
					RateLimitThreshold: to.Ptr[int64](3951729),
				},
				&armeventhub.ThrottlingPolicy{
					Name:               to.Ptr("ThrottlingPolicy3"),
					Type:               to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
					MetricID:           to.Ptr(armeventhub.MetricIDOutgoingBytes),
					RateLimitThreshold: to.Ptr[int64](245175),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGroup = armeventhub.ApplicationGroup{
	// 	Name: to.Ptr("appGroup1"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces/ApplicationGroups"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosotest/providers/Microsoft.EventHub/namespaces/contoso-ua-test-eh-system-1/applicationgroups/appGroup1"),
	// 	Location: to.Ptr("EAST US 2 EUAP"),
	// 	Properties: &armeventhub.ApplicationGroupProperties{
	// 		ClientAppGroupIdentifier: to.Ptr("SASKeyName=KeyName"),
	// 		IsEnabled: to.Ptr(true),
	// 		Policies: []armeventhub.ApplicationGroupPolicyClassification{
	// 			&armeventhub.ThrottlingPolicy{
	// 				Name: to.Ptr("ThrottlingPolicy1"),
	// 				Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
	// 				MetricID: to.Ptr(armeventhub.MetricIDIncomingMessages),
	// 				RateLimitThreshold: to.Ptr[int64](7912),
	// 			},
	// 			&armeventhub.ThrottlingPolicy{
	// 				Name: to.Ptr("ThrottlingPolicy2"),
	// 				Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
	// 				MetricID: to.Ptr(armeventhub.MetricIDIncomingBytes),
	// 				RateLimitThreshold: to.Ptr[int64](3951729),
	// 			},
	// 			&armeventhub.ThrottlingPolicy{
	// 				Name: to.Ptr("ThrottlingPolicy3"),
	// 				Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
	// 				MetricID: to.Ptr(armeventhub.MetricIDOutgoingBytes),
	// 				RateLimitThreshold: to.Ptr[int64](245175),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b574e2a41acda14a90ef237006e8bbdda2b63c63/specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/ApplicationGroup/ApplicationGroupDelete.json
func ExampleApplicationGroupClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewApplicationGroupClient().Delete(ctx, "contosotest", "contoso-ua-test-eh-system-1", "appGroup1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/b574e2a41acda14a90ef237006e8bbdda2b63c63/specification/eventhub/resource-manager/Microsoft.EventHub/stable/2024-01-01/examples/ApplicationGroup/ApplicationGroupGet.json
func ExampleApplicationGroupClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armeventhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewApplicationGroupClient().Get(ctx, "contosotest", "contoso-ua-test-eh-system-1", "appGroup1", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ApplicationGroup = armeventhub.ApplicationGroup{
	// 	Name: to.Ptr("appGroup1"),
	// 	Type: to.Ptr("Microsoft.EventHub/Namespaces/ApplicationGroups"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/contosotest/providers/Microsoft.EventHub/namespaces/contoso-ua-test-eh-system-1/applicationgroups/appGroup1"),
	// 	Location: to.Ptr("EAST US 2 EUAP"),
	// 	Properties: &armeventhub.ApplicationGroupProperties{
	// 		ClientAppGroupIdentifier: to.Ptr("SASKeyName=KeyName"),
	// 		IsEnabled: to.Ptr(true),
	// 		Policies: []armeventhub.ApplicationGroupPolicyClassification{
	// 			&armeventhub.ThrottlingPolicy{
	// 				Name: to.Ptr("ThrottlingPolicy1"),
	// 				Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
	// 				MetricID: to.Ptr(armeventhub.MetricIDIncomingMessages),
	// 				RateLimitThreshold: to.Ptr[int64](7912),
	// 			},
	// 			&armeventhub.ThrottlingPolicy{
	// 				Name: to.Ptr("ThrottlingPolicy2"),
	// 				Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
	// 				MetricID: to.Ptr(armeventhub.MetricIDIncomingBytes),
	// 				RateLimitThreshold: to.Ptr[int64](3951729),
	// 			},
	// 			&armeventhub.ThrottlingPolicy{
	// 				Name: to.Ptr("ThrottlingPolicy3"),
	// 				Type: to.Ptr(armeventhub.ApplicationGroupPolicyTypeThrottlingPolicy),
	// 				MetricID: to.Ptr(armeventhub.MetricIDOutgoingBytes),
	// 				RateLimitThreshold: to.Ptr[int64](245175),
	// 		}},
	// 	},
	// }
}
