# 🍄 Mycorrhiza Wiki

**Mycorrhiza Wiki** is a lightweight file-system wiki engine that uses Git for keeping history. [Main wiki](https://mycorrhiza.wiki)

<img src="https://mycorrhiza.wiki/binary/release/1.15/screenshot" alt="A screenshot of mycorrhiza.wiki's home page in the Safari browser" width="700">


## Features

* **No database used.** Everything is stored in plain files. It makes installation super easy, and you can modify the content directly by yourself.
* **Everything is hyphae.** A hypha is a unit of content such as a picture, video or a text article. Hyphae can [transclude] and link each other, forming a tight network of hypertext pages.
* **Hyphae are authored in [Mycomarkup],** a markup language that's designed to be unambiguous yet easy to use.
* **Categories** let you organize hyphae without any hierarchy restrictions, with all the benefits of a category system.
* **Nesting of hyphae** is also supported if you like hierarchies.
* **History of changes.** Every change is safely stored in [Git]. Web feeds (RSS, Atom, JSON Feed) for recent changes included.
* **Keyboard-driven navigation.** Press `?` to see the list of shortcuts.
* **Support for [authorization].** Both plain username-password pairs and [Telegram]'s login widget are supported.
* **[Open Graph] support.** The most relevant info about a hypha is made available through OG meta tags for consumption by other software.
* **Interwiki support.**

[transclude]: https://mycorrhiza.wiki/hypha/feature/transclusion
[Mycomarkup]: https://mycorrhiza.wiki/help/en/mycomarkup
[Git]: https://mycorrhiza.wiki/hypha/integration/git
[authorization]: https://mycorrhiza.wiki/hypha/authorization
[Telegram]: https://mycorrhiza.wiki/help/en/telegram
[Open Graph]: https://mycorrhiza.wiki/hypha/opengraph

Compare Mycorrhiza Wiki with other engines on [WikiMatrix](https://www.wikimatrix.org/show/mycorrhiza).


## Installing

See [the deployment guide](https://mycorrhiza.wiki/hypha/deployment) on the wiki. Also, Mycorrhiza might be available in your repositories. See [Repology](https://repology.org/project/mycorrhiza/versions).


## Contributing and community

* [GitHub](https://github.com/bouncepaw/mycorrhiza)
* [Fediverse @mycorrhiza@floss.social](https://floss.social/@mycorrhiza)
* Mirrors:
  * [SourceHut](https://sr.ht/~bouncepaw/mycorrhiza)
  * [Codeberg](https://codeberg.org/bouncepaw/mycorrhiza)
* [@mycorrhizadev (Russian) in Telegram](https://t.me/mycorrhizadev)

If you want to contribute with code, open a pull request on GitHub or send a patch to the [mailing list](https://lists.sr.ht/~bouncepaw/mycorrhiza-devel).
If you want to report an issue, open an issue on GitHub or contact us directly.

Consider supporting the development on [Boosty](https://boosty.to/bouncepaw).

Check out [Betula](https://betula.mycorrhiza.wiki) as well.