// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/securitycenter/v2/ip_rules.proto

package securitycenterpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of direction that the rule is applicable to, one of ingress or
// egress. Not applicable to OPEN_X_PORT findings.
type IpRules_Direction int32

const (
	// Unspecified direction value.
	IpRules_DIRECTION_UNSPECIFIED IpRules_Direction = 0
	// Ingress direction value.
	IpRules_INGRESS IpRules_Direction = 1
	// Egress direction value.
	IpRules_EGRESS IpRules_Direction = 2
)

// Enum value maps for IpRules_Direction.
var (
	IpRules_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "INGRESS",
		2: "EGRESS",
	}
	IpRules_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"INGRESS":               1,
		"EGRESS":                2,
	}
)

func (x IpRules_Direction) Enum() *IpRules_Direction {
	p := new(IpRules_Direction)
	*p = x
	return p
}

func (x IpRules_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IpRules_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_enumTypes[0].Descriptor()
}

func (IpRules_Direction) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_ip_rules_proto_enumTypes[0]
}

func (x IpRules_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IpRules_Direction.Descriptor instead.
func (IpRules_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP(), []int{0, 0}
}

// IP rules associated with the finding.
type IpRules struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The direction that the rule is applicable to, one of ingress or egress.
	Direction IpRules_Direction `protobuf:"varint,1,opt,name=direction,proto3,enum=google.cloud.securitycenter.v2.IpRules_Direction" json:"direction,omitempty"`
	// The list of allow rules specified by this firewall. Each rule specifies a
	// protocol and port-range tuple that describes a permitted connection.
	//
	// Types that are assignable to Rules:
	//
	//	*IpRules_Allowed
	//	*IpRules_Denied
	Rules isIpRules_Rules `protobuf_oneof:"rules"`
	// If source IP ranges are specified, the firewall rule applies only to
	// traffic that has a source IP address in these ranges. These ranges must be
	// expressed in CIDR format. Only supports IPv4.
	SourceIpRanges []string `protobuf:"bytes,4,rep,name=source_ip_ranges,json=sourceIpRanges,proto3" json:"source_ip_ranges,omitempty"`
	// If destination IP ranges are specified, the firewall rule applies only to
	// traffic that has a destination IP address in these ranges. These ranges
	// must be expressed in CIDR format. Only supports IPv4.
	DestinationIpRanges []string `protobuf:"bytes,5,rep,name=destination_ip_ranges,json=destinationIpRanges,proto3" json:"destination_ip_ranges,omitempty"`
	// Name of the network protocol service, such as FTP, that is exposed by the
	// open port. Follows the naming convention available at:
	// https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml.
	ExposedServices []string `protobuf:"bytes,6,rep,name=exposed_services,json=exposedServices,proto3" json:"exposed_services,omitempty"`
}

func (x *IpRules) Reset() {
	*x = IpRules{}
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IpRules) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpRules) ProtoMessage() {}

func (x *IpRules) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpRules.ProtoReflect.Descriptor instead.
func (*IpRules) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP(), []int{0}
}

func (x *IpRules) GetDirection() IpRules_Direction {
	if x != nil {
		return x.Direction
	}
	return IpRules_DIRECTION_UNSPECIFIED
}

func (m *IpRules) GetRules() isIpRules_Rules {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (x *IpRules) GetAllowed() *Allowed {
	if x, ok := x.GetRules().(*IpRules_Allowed); ok {
		return x.Allowed
	}
	return nil
}

func (x *IpRules) GetDenied() *Denied {
	if x, ok := x.GetRules().(*IpRules_Denied); ok {
		return x.Denied
	}
	return nil
}

func (x *IpRules) GetSourceIpRanges() []string {
	if x != nil {
		return x.SourceIpRanges
	}
	return nil
}

func (x *IpRules) GetDestinationIpRanges() []string {
	if x != nil {
		return x.DestinationIpRanges
	}
	return nil
}

func (x *IpRules) GetExposedServices() []string {
	if x != nil {
		return x.ExposedServices
	}
	return nil
}

type isIpRules_Rules interface {
	isIpRules_Rules()
}

type IpRules_Allowed struct {
	// Tuple with allowed rules.
	Allowed *Allowed `protobuf:"bytes,2,opt,name=allowed,proto3,oneof"`
}

type IpRules_Denied struct {
	// Tuple with denied rules.
	Denied *Denied `protobuf:"bytes,3,opt,name=denied,proto3,oneof"`
}

func (*IpRules_Allowed) isIpRules_Rules() {}

func (*IpRules_Denied) isIpRules_Rules() {}

// IP rule information.
type IpRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP protocol this rule applies to. This value can either be one of the
	// following well known protocol strings (TCP, UDP, ICMP, ESP, AH, IPIP,
	// SCTP) or a string representation of the integer value.
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Optional. An optional list of ports to which this rule applies. This field
	// is only applicable for the UDP or (S)TCP protocols. Each entry must be
	// either an integer or a range including a min and max port number.
	PortRanges []*IpRule_PortRange `protobuf:"bytes,2,rep,name=port_ranges,json=portRanges,proto3" json:"port_ranges,omitempty"`
}

func (x *IpRule) Reset() {
	*x = IpRule{}
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IpRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpRule) ProtoMessage() {}

func (x *IpRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpRule.ProtoReflect.Descriptor instead.
func (*IpRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP(), []int{1}
}

func (x *IpRule) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *IpRule) GetPortRanges() []*IpRule_PortRange {
	if x != nil {
		return x.PortRanges
	}
	return nil
}

// Allowed IP rule.
type Allowed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Optional list of allowed IP rules.
	IpRules []*IpRule `protobuf:"bytes,1,rep,name=ip_rules,json=ipRules,proto3" json:"ip_rules,omitempty"`
}

func (x *Allowed) Reset() {
	*x = Allowed{}
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Allowed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Allowed) ProtoMessage() {}

func (x *Allowed) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Allowed.ProtoReflect.Descriptor instead.
func (*Allowed) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP(), []int{2}
}

func (x *Allowed) GetIpRules() []*IpRule {
	if x != nil {
		return x.IpRules
	}
	return nil
}

// Denied IP rule.
type Denied struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Optional list of denied IP rules.
	IpRules []*IpRule `protobuf:"bytes,1,rep,name=ip_rules,json=ipRules,proto3" json:"ip_rules,omitempty"`
}

func (x *Denied) Reset() {
	*x = Denied{}
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Denied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Denied) ProtoMessage() {}

func (x *Denied) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Denied.ProtoReflect.Descriptor instead.
func (*Denied) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP(), []int{3}
}

func (x *Denied) GetIpRules() []*IpRule {
	if x != nil {
		return x.IpRules
	}
	return nil
}

// A port range which is inclusive of the min and max values.
// Values are between 0 and 2^16-1. The max can be equal / must be not smaller
// than the min value. If min and max are equal this indicates that it is a
// single port.
type IpRule_PortRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum port value.
	Min int64 `protobuf:"varint,1,opt,name=min,proto3" json:"min,omitempty"`
	// Maximum port value.
	Max int64 `protobuf:"varint,2,opt,name=max,proto3" json:"max,omitempty"`
}

func (x *IpRule_PortRange) Reset() {
	*x = IpRule_PortRange{}
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IpRule_PortRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IpRule_PortRange) ProtoMessage() {}

func (x *IpRule_PortRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IpRule_PortRange.ProtoReflect.Descriptor instead.
func (*IpRule_PortRange) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP(), []int{1, 0}
}

func (x *IpRule_PortRange) GetMin() int64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *IpRule_PortRange) GetMax() int64 {
	if x != nil {
		return x.Max
	}
	return 0
}

var File_google_cloud_securitycenter_v2_ip_rules_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_ip_rules_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x69, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0xb4, 0x03, 0x0a, 0x07, 0x49, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x4f, 0x0a, 0x09,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32,
	0x2e, 0x49, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x0a,
	0x07, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x48, 0x00, 0x52, 0x07, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x12, 0x40, 0x0a, 0x06, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x48, 0x00, 0x52, 0x06, 0x64, 0x65,
	0x6e, 0x69, 0x65, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69,
	0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x32,
	0x0a, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x70,
	0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x13, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67,
	0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78,
	0x70, 0x6f, 0x73, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x22, 0x3f, 0x0a,
	0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x49,
	0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x47, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x42, 0x07,
	0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xad, 0x01, 0x0a, 0x06, 0x49, 0x70, 0x52, 0x75,
	0x6c, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x12, 0x56,
	0x0a, 0x0b, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x2e, 0x50, 0x6f, 0x72, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x1a, 0x2f, 0x0a, 0x09, 0x50, 0x6f, 0x72, 0x74, 0x52, 0x61,
	0x6e, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x61, 0x78, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x03, 0x6d, 0x61, 0x78, 0x22, 0x51, 0x0a, 0x07, 0x41, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x12, 0x46, 0x0a, 0x08, 0x69, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x69, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x50, 0x0a, 0x06, 0x44, 0x65,
	0x6e, 0x69, 0x65, 0x64, 0x12, 0x46, 0x0a, 0x08, 0x69, 0x70, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x69, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x42, 0xe6, 0x01, 0x0a,
	0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x42, 0x0c, 0x49, 0x70, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
	0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa,
	0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32,
	0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56,
	0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescData = file_google_cloud_securitycenter_v2_ip_rules_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_ip_rules_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_ip_rules_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_securitycenter_v2_ip_rules_proto_goTypes = []any{
	(IpRules_Direction)(0),   // 0: google.cloud.securitycenter.v2.IpRules.Direction
	(*IpRules)(nil),          // 1: google.cloud.securitycenter.v2.IpRules
	(*IpRule)(nil),           // 2: google.cloud.securitycenter.v2.IpRule
	(*Allowed)(nil),          // 3: google.cloud.securitycenter.v2.Allowed
	(*Denied)(nil),           // 4: google.cloud.securitycenter.v2.Denied
	(*IpRule_PortRange)(nil), // 5: google.cloud.securitycenter.v2.IpRule.PortRange
}
var file_google_cloud_securitycenter_v2_ip_rules_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.IpRules.direction:type_name -> google.cloud.securitycenter.v2.IpRules.Direction
	3, // 1: google.cloud.securitycenter.v2.IpRules.allowed:type_name -> google.cloud.securitycenter.v2.Allowed
	4, // 2: google.cloud.securitycenter.v2.IpRules.denied:type_name -> google.cloud.securitycenter.v2.Denied
	5, // 3: google.cloud.securitycenter.v2.IpRule.port_ranges:type_name -> google.cloud.securitycenter.v2.IpRule.PortRange
	2, // 4: google.cloud.securitycenter.v2.Allowed.ip_rules:type_name -> google.cloud.securitycenter.v2.IpRule
	2, // 5: google.cloud.securitycenter.v2.Denied.ip_rules:type_name -> google.cloud.securitycenter.v2.IpRule
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_ip_rules_proto_init() }
func file_google_cloud_securitycenter_v2_ip_rules_proto_init() {
	if File_google_cloud_securitycenter_v2_ip_rules_proto != nil {
		return
	}
	file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes[0].OneofWrappers = []any{
		(*IpRules_Allowed)(nil),
		(*IpRules_Denied)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_ip_rules_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_ip_rules_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_ip_rules_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_ip_rules_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_ip_rules_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_ip_rules_proto = out.File
	file_google_cloud_securitycenter_v2_ip_rules_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_ip_rules_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_ip_rules_proto_depIdxs = nil
}
