/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.parser.antlr;

import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.jd.gui.api.model.Container;
import org.jd.gui.util.parser.antlr.JavaBaseListener;
import org.jd.gui.util.parser.antlr.JavaParser;

public abstract class AbstractJavaListener
extends JavaBaseListener {
    protected Container.Entry entry;
    protected String packageName = "";
    protected HashMap<String, String> nameToInternalTypeName = new HashMap();
    protected StringBuilder sb = new StringBuilder();
    protected HashMap<String, String> typeNameCache = new HashMap();

    public AbstractJavaListener(Container.Entry entry) {
        this.entry = entry;
    }

    @Override
    public void enterPackageDeclaration(JavaParser.PackageDeclarationContext ctx) {
        this.packageName = this.concatIdentifiers(ctx.qualifiedName().Identifier());
    }

    @Override
    public void enterImportDeclaration(JavaParser.ImportDeclarationContext ctx) {
        List<TerminalNode> identifiers = ctx.qualifiedName().Identifier();
        int size = identifiers.size();
        if (size > 1) {
            this.nameToInternalTypeName.put(identifiers.get(size - 1).getText(), this.concatIdentifiers(identifiers));
        }
    }

    protected String concatIdentifiers(List<TerminalNode> identifiers) {
        switch (identifiers.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return identifiers.get(0).getText();
            }
        }
        this.sb.setLength(0);
        for (TerminalNode identifier : identifiers) {
            this.sb.append(identifier.getText()).append('/');
        }
        this.sb.setLength(this.sb.length() - 1);
        return this.sb.toString();
    }

    protected String resolveInternalTypeName(List<TerminalNode> identifiers) {
        switch (identifiers.size()) {
            case 0: {
                return null;
            }
            case 1: {
                String name = identifiers.get(0).getText();
                String qualifiedName = this.typeNameCache.get(name);
                if (qualifiedName != null) {
                    return qualifiedName;
                }
                String imp = this.nameToInternalTypeName.get(name);
                if (imp != null) {
                    return imp;
                }
                String prefix = name + '.';
                if (this.entry.getPath().indexOf(47) != -1) {
                    Container.Entry parent = this.entry.getParent();
                    int packageLength = parent.getPath().length() + 1;
                    for (Container.Entry child : parent.getChildren()) {
                        if (child.isDirectory() || !child.getPath().substring(packageLength).startsWith(prefix)) continue;
                        qualifiedName = this.packageName + '/' + name;
                        this.typeNameCache.put(name, qualifiedName);
                        return qualifiedName;
                    }
                }
                for (Container.Entry child : this.entry.getContainer().getRoot().getChildren()) {
                    if (child.isDirectory() || !child.getPath().startsWith(prefix)) continue;
                    this.typeNameCache.put(name, name);
                    return name;
                }
                try {
                    if (Class.forName("java.lang." + name) != null) {
                        qualifiedName = "java/lang/" + name;
                        this.typeNameCache.put(name, qualifiedName);
                        return qualifiedName;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                qualifiedName = "*/" + name;
                this.typeNameCache.put(name, qualifiedName);
                return qualifiedName;
            }
        }
        return this.concatIdentifiers(identifiers);
    }

    protected String createDescriptor(JavaParser.TypeContext typeContext, int dimension) {
        String name;
        if (typeContext == null) {
            return "V";
        }
        dimension += this.countDimension(typeContext.children);
        JavaParser.PrimitiveTypeContext primitive = typeContext.primitiveType();
        if (primitive == null) {
            JavaParser.ClassOrInterfaceTypeContext type = typeContext.classOrInterfaceType();
            List<JavaParser.TypeArgumentsContext> typeArgumentsContexts = type.typeArguments();
            if (typeArgumentsContexts.size() == 1) {
                JavaParser.TypeArgumentsContext typeArgumentsContext = typeArgumentsContexts.get(0);
                List<JavaParser.TypeArgumentContext> list = typeArgumentsContext.typeArgument();
            } else if (typeArgumentsContexts.size() > 1) {
                throw new RuntimeException("UNEXPECTED");
            }
            name = "L" + this.resolveInternalTypeName(type.Identifier()) + ";";
        } else {
            switch (primitive.getText()) {
                case "boolean": {
                    name = "Z";
                    break;
                }
                case "byte": {
                    name = "B";
                    break;
                }
                case "char": {
                    name = "C";
                    break;
                }
                case "double": {
                    name = "D";
                    break;
                }
                case "float": {
                    name = "F";
                    break;
                }
                case "int": {
                    name = "I";
                    break;
                }
                case "long": {
                    name = "J";
                    break;
                }
                case "short": {
                    name = "S";
                    break;
                }
                case "void": {
                    name = "V";
                    break;
                }
                default: {
                    throw new RuntimeException("UNEXPECTED PRIMITIVE");
                }
            }
        }
        switch (dimension) {
            case 0: {
                return name;
            }
            case 1: {
                return "[" + name;
            }
            case 2: {
                return "[[" + name;
            }
        }
        return new String(new char[dimension]).replace('\u0000', '[') + name;
    }

    protected int countDimension(List<ParseTree> children) {
        int dimension = 0;
        for (ParseTree child : children) {
            if (!(child instanceof TerminalNodeImpl) || ((TerminalNodeImpl)child).getSymbol().getType() != 61) continue;
            ++dimension;
        }
        return dimension;
    }
}

