// Licensed to Elasticsearch B.V. under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Elasticsearch B.V. licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.
//
// Code generated from specification version 7.17.1: DO NOT EDIT

package esapi

import (
	"context"
	"net/http"
	"strconv"
	"strings"
)

func newMLGetJobsFunc(t Transport) MLGetJobs {
	return func(o ...func(*MLGetJobsRequest)) (*Response, error) {
		var r = MLGetJobsRequest{}
		for _, f := range o {
			f(&r)
		}
		return r.Do(r.ctx, t)
	}
}

// ----- API Definition -------------------------------------------------------

// MLGetJobs - Retrieves configuration information for anomaly detection jobs.
//
// See full documentation at https://www.elastic.co/guide/en/elasticsearch/reference/current/ml-get-job.html.
//
type MLGetJobs func(o ...func(*MLGetJobsRequest)) (*Response, error)

// MLGetJobsRequest configures the ML Get Jobs API request.
//
type MLGetJobsRequest struct {
	JobID string

	AllowNoJobs      *bool
	AllowNoMatch     *bool
	ExcludeGenerated *bool

	Pretty     bool
	Human      bool
	ErrorTrace bool
	FilterPath []string

	Header http.Header

	ctx context.Context
}

// Do executes the request and returns response or error.
//
func (r MLGetJobsRequest) Do(ctx context.Context, transport Transport) (*Response, error) {
	var (
		method string
		path   strings.Builder
		params map[string]string
	)

	method = "GET"

	path.Grow(1 + len("_ml") + 1 + len("anomaly_detectors") + 1 + len(r.JobID))
	path.WriteString("/")
	path.WriteString("_ml")
	path.WriteString("/")
	path.WriteString("anomaly_detectors")
	if r.JobID != "" {
		path.WriteString("/")
		path.WriteString(r.JobID)
	}

	params = make(map[string]string)

	if r.AllowNoJobs != nil {
		params["allow_no_jobs"] = strconv.FormatBool(*r.AllowNoJobs)
	}

	if r.AllowNoMatch != nil {
		params["allow_no_match"] = strconv.FormatBool(*r.AllowNoMatch)
	}

	if r.ExcludeGenerated != nil {
		params["exclude_generated"] = strconv.FormatBool(*r.ExcludeGenerated)
	}

	if r.Pretty {
		params["pretty"] = "true"
	}

	if r.Human {
		params["human"] = "true"
	}

	if r.ErrorTrace {
		params["error_trace"] = "true"
	}

	if len(r.FilterPath) > 0 {
		params["filter_path"] = strings.Join(r.FilterPath, ",")
	}

	req, err := newRequest(method, path.String(), nil)
	if err != nil {
		return nil, err
	}

	if len(params) > 0 {
		q := req.URL.Query()
		for k, v := range params {
			q.Set(k, v)
		}
		req.URL.RawQuery = q.Encode()
	}

	if len(r.Header) > 0 {
		if len(req.Header) == 0 {
			req.Header = r.Header
		} else {
			for k, vv := range r.Header {
				for _, v := range vv {
					req.Header.Add(k, v)
				}
			}
		}
	}

	if ctx != nil {
		req = req.WithContext(ctx)
	}

	res, err := transport.Perform(req)
	if err != nil {
		return nil, err
	}

	response := Response{
		StatusCode: res.StatusCode,
		Body:       res.Body,
		Header:     res.Header,
	}

	return &response, nil
}

// WithContext sets the request context.
//
func (f MLGetJobs) WithContext(v context.Context) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.ctx = v
	}
}

// WithJobID - the ID of the jobs to fetch.
//
func (f MLGetJobs) WithJobID(v string) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.JobID = v
	}
}

// WithAllowNoJobs - whether to ignore if a wildcard expression matches no jobs. (this includes `_all` string or when no jobs have been specified).
//
func (f MLGetJobs) WithAllowNoJobs(v bool) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.AllowNoJobs = &v
	}
}

// WithAllowNoMatch - whether to ignore if a wildcard expression matches no jobs. (this includes `_all` string or when no jobs have been specified).
//
func (f MLGetJobs) WithAllowNoMatch(v bool) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.AllowNoMatch = &v
	}
}

// WithExcludeGenerated - omits fields that are illegal to set on job put.
//
func (f MLGetJobs) WithExcludeGenerated(v bool) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.ExcludeGenerated = &v
	}
}

// WithPretty makes the response body pretty-printed.
//
func (f MLGetJobs) WithPretty() func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.Pretty = true
	}
}

// WithHuman makes statistical values human-readable.
//
func (f MLGetJobs) WithHuman() func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.Human = true
	}
}

// WithErrorTrace includes the stack trace for errors in the response body.
//
func (f MLGetJobs) WithErrorTrace() func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.ErrorTrace = true
	}
}

// WithFilterPath filters the properties of the response body.
//
func (f MLGetJobs) WithFilterPath(v ...string) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		r.FilterPath = v
	}
}

// WithHeader adds the headers to the HTTP request.
//
func (f MLGetJobs) WithHeader(h map[string]string) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		if r.Header == nil {
			r.Header = make(http.Header)
		}
		for k, v := range h {
			r.Header.Add(k, v)
		}
	}
}

// WithOpaqueID adds the X-Opaque-Id header to the HTTP request.
//
func (f MLGetJobs) WithOpaqueID(s string) func(*MLGetJobsRequest) {
	return func(r *MLGetJobsRequest) {
		if r.Header == nil {
			r.Header = make(http.Header)
		}
		r.Header.Set("X-Opaque-Id", s)
	}
}
