// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/maps/places/v1/places_service.proto

package placespb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Places_SearchNearby_FullMethodName       = "/google.maps.places.v1.Places/SearchNearby"
	Places_SearchText_FullMethodName         = "/google.maps.places.v1.Places/SearchText"
	Places_GetPhotoMedia_FullMethodName      = "/google.maps.places.v1.Places/GetPhotoMedia"
	Places_GetPlace_FullMethodName           = "/google.maps.places.v1.Places/GetPlace"
	Places_AutocompletePlaces_FullMethodName = "/google.maps.places.v1.Places/AutocompletePlaces"
)

// PlacesClient is the client API for Places service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PlacesClient interface {
	// Search for places near locations.
	SearchNearby(ctx context.Context, in *SearchNearbyRequest, opts ...grpc.CallOption) (*SearchNearbyResponse, error)
	// Text query based place search.
	SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error)
	// Get a photo media with a photo reference string.
	GetPhotoMedia(ctx context.Context, in *GetPhotoMediaRequest, opts ...grpc.CallOption) (*PhotoMedia, error)
	// Get the details of a place based on its resource name, which is a string
	// in the `places/{place_id}` format.
	GetPlace(ctx context.Context, in *GetPlaceRequest, opts ...grpc.CallOption) (*Place, error)
	// Returns predictions for the given input.
	AutocompletePlaces(ctx context.Context, in *AutocompletePlacesRequest, opts ...grpc.CallOption) (*AutocompletePlacesResponse, error)
}

type placesClient struct {
	cc grpc.ClientConnInterface
}

func NewPlacesClient(cc grpc.ClientConnInterface) PlacesClient {
	return &placesClient{cc}
}

func (c *placesClient) SearchNearby(ctx context.Context, in *SearchNearbyRequest, opts ...grpc.CallOption) (*SearchNearbyResponse, error) {
	out := new(SearchNearbyResponse)
	err := c.cc.Invoke(ctx, Places_SearchNearby_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) SearchText(ctx context.Context, in *SearchTextRequest, opts ...grpc.CallOption) (*SearchTextResponse, error) {
	out := new(SearchTextResponse)
	err := c.cc.Invoke(ctx, Places_SearchText_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) GetPhotoMedia(ctx context.Context, in *GetPhotoMediaRequest, opts ...grpc.CallOption) (*PhotoMedia, error) {
	out := new(PhotoMedia)
	err := c.cc.Invoke(ctx, Places_GetPhotoMedia_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) GetPlace(ctx context.Context, in *GetPlaceRequest, opts ...grpc.CallOption) (*Place, error) {
	out := new(Place)
	err := c.cc.Invoke(ctx, Places_GetPlace_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *placesClient) AutocompletePlaces(ctx context.Context, in *AutocompletePlacesRequest, opts ...grpc.CallOption) (*AutocompletePlacesResponse, error) {
	out := new(AutocompletePlacesResponse)
	err := c.cc.Invoke(ctx, Places_AutocompletePlaces_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlacesServer is the server API for Places service.
// All implementations should embed UnimplementedPlacesServer
// for forward compatibility
type PlacesServer interface {
	// Search for places near locations.
	SearchNearby(context.Context, *SearchNearbyRequest) (*SearchNearbyResponse, error)
	// Text query based place search.
	SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error)
	// Get a photo media with a photo reference string.
	GetPhotoMedia(context.Context, *GetPhotoMediaRequest) (*PhotoMedia, error)
	// Get the details of a place based on its resource name, which is a string
	// in the `places/{place_id}` format.
	GetPlace(context.Context, *GetPlaceRequest) (*Place, error)
	// Returns predictions for the given input.
	AutocompletePlaces(context.Context, *AutocompletePlacesRequest) (*AutocompletePlacesResponse, error)
}

// UnimplementedPlacesServer should be embedded to have forward compatible implementations.
type UnimplementedPlacesServer struct {
}

func (UnimplementedPlacesServer) SearchNearby(context.Context, *SearchNearbyRequest) (*SearchNearbyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchNearby not implemented")
}
func (UnimplementedPlacesServer) SearchText(context.Context, *SearchTextRequest) (*SearchTextResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchText not implemented")
}
func (UnimplementedPlacesServer) GetPhotoMedia(context.Context, *GetPhotoMediaRequest) (*PhotoMedia, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhotoMedia not implemented")
}
func (UnimplementedPlacesServer) GetPlace(context.Context, *GetPlaceRequest) (*Place, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlace not implemented")
}
func (UnimplementedPlacesServer) AutocompletePlaces(context.Context, *AutocompletePlacesRequest) (*AutocompletePlacesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutocompletePlaces not implemented")
}

// UnsafePlacesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PlacesServer will
// result in compilation errors.
type UnsafePlacesServer interface {
	mustEmbedUnimplementedPlacesServer()
}

func RegisterPlacesServer(s grpc.ServiceRegistrar, srv PlacesServer) {
	s.RegisterService(&Places_ServiceDesc, srv)
}

func _Places_SearchNearby_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchNearbyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchNearby(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Places_SearchNearby_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchNearby(ctx, req.(*SearchNearbyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_SearchText_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchTextRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).SearchText(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Places_SearchText_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).SearchText(ctx, req.(*SearchTextRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_GetPhotoMedia_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhotoMediaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).GetPhotoMedia(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Places_GetPhotoMedia_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).GetPhotoMedia(ctx, req.(*GetPhotoMediaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_GetPlace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPlaceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).GetPlace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Places_GetPlace_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).GetPlace(ctx, req.(*GetPlaceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Places_AutocompletePlaces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AutocompletePlacesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlacesServer).AutocompletePlaces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Places_AutocompletePlaces_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlacesServer).AutocompletePlaces(ctx, req.(*AutocompletePlacesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Places_ServiceDesc is the grpc.ServiceDesc for Places service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Places_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.maps.places.v1.Places",
	HandlerType: (*PlacesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SearchNearby",
			Handler:    _Places_SearchNearby_Handler,
		},
		{
			MethodName: "SearchText",
			Handler:    _Places_SearchText_Handler,
		},
		{
			MethodName: "GetPhotoMedia",
			Handler:    _Places_GetPhotoMedia_Handler,
		},
		{
			MethodName: "GetPlace",
			Handler:    _Places_GetPlace_Handler,
		},
		{
			MethodName: "AutocompletePlaces",
			Handler:    _Places_AutocompletePlaces_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/maps/places/v1/places_service.proto",
}
