package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHotParamRulesOfApp invokes the ahas_openapi.ListHotParamRulesOfApp API synchronously
func (client *Client) ListHotParamRulesOfApp(request *ListHotParamRulesOfAppRequest) (response *ListHotParamRulesOfAppResponse, err error) {
	response = CreateListHotParamRulesOfAppResponse()
	err = client.DoAction(request, response)
	return
}

// ListHotParamRulesOfAppWithChan invokes the ahas_openapi.ListHotParamRulesOfApp API asynchronously
func (client *Client) ListHotParamRulesOfAppWithChan(request *ListHotParamRulesOfAppRequest) (<-chan *ListHotParamRulesOfAppResponse, <-chan error) {
	responseChan := make(chan *ListHotParamRulesOfAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHotParamRulesOfApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHotParamRulesOfAppWithCallback invokes the ahas_openapi.ListHotParamRulesOfApp API asynchronously
func (client *Client) ListHotParamRulesOfAppWithCallback(request *ListHotParamRulesOfAppRequest, callback func(response *ListHotParamRulesOfAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHotParamRulesOfAppResponse
		var err error
		defer close(result)
		response, err = client.ListHotParamRulesOfApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHotParamRulesOfAppRequest is the request struct for api ListHotParamRulesOfApp
type ListHotParamRulesOfAppRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	PageIndex    requests.Integer `position:"Query" name:"PageIndex"`
}

// ListHotParamRulesOfAppResponse is the response struct for api ListHotParamRulesOfApp
type ListHotParamRulesOfAppResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListHotParamRulesOfAppRequest creates a request to invoke ListHotParamRulesOfApp API
func CreateListHotParamRulesOfAppRequest() (request *ListHotParamRulesOfAppRequest) {
	request = &ListHotParamRulesOfAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "ListHotParamRulesOfApp", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListHotParamRulesOfAppResponse creates a response to parse from ListHotParamRulesOfApp response
func CreateListHotParamRulesOfAppResponse() (response *ListHotParamRulesOfAppResponse) {
	response = &ListHotParamRulesOfAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
