package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemovePdnsAppKey invokes the alidns.RemovePdnsAppKey API synchronously
func (client *Client) RemovePdnsAppKey(request *RemovePdnsAppKeyRequest) (response *RemovePdnsAppKeyResponse, err error) {
	response = CreateRemovePdnsAppKeyResponse()
	err = client.DoAction(request, response)
	return
}

// RemovePdnsAppKeyWithChan invokes the alidns.RemovePdnsAppKey API asynchronously
func (client *Client) RemovePdnsAppKeyWithChan(request *RemovePdnsAppKeyRequest) (<-chan *RemovePdnsAppKeyResponse, <-chan error) {
	responseChan := make(chan *RemovePdnsAppKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemovePdnsAppKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemovePdnsAppKeyWithCallback invokes the alidns.RemovePdnsAppKey API asynchronously
func (client *Client) RemovePdnsAppKeyWithCallback(request *RemovePdnsAppKeyRequest, callback func(response *RemovePdnsAppKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemovePdnsAppKeyResponse
		var err error
		defer close(result)
		response, err = client.RemovePdnsAppKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemovePdnsAppKeyRequest is the request struct for api RemovePdnsAppKey
type RemovePdnsAppKeyRequest struct {
	*requests.RpcRequest
	AppKeyId string `position:"Query" name:"AppKeyId"`
	Lang     string `position:"Query" name:"Lang"`
}

// RemovePdnsAppKeyResponse is the response struct for api RemovePdnsAppKey
type RemovePdnsAppKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRemovePdnsAppKeyRequest creates a request to invoke RemovePdnsAppKey API
func CreateRemovePdnsAppKeyRequest() (request *RemovePdnsAppKeyRequest) {
	request = &RemovePdnsAppKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "RemovePdnsAppKey", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemovePdnsAppKeyResponse creates a response to parse from RemovePdnsAppKey response
func CreateRemovePdnsAppKeyResponse() (response *RemovePdnsAppKeyResponse) {
	response = &RemovePdnsAppKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
