package alinlp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMedicineChMedical invokes the alinlp.GetMedicineChMedical API synchronously
func (client *Client) GetMedicineChMedical(request *GetMedicineChMedicalRequest) (response *GetMedicineChMedicalResponse, err error) {
	response = CreateGetMedicineChMedicalResponse()
	err = client.DoAction(request, response)
	return
}

// GetMedicineChMedicalWithChan invokes the alinlp.GetMedicineChMedical API asynchronously
func (client *Client) GetMedicineChMedicalWithChan(request *GetMedicineChMedicalRequest) (<-chan *GetMedicineChMedicalResponse, <-chan error) {
	responseChan := make(chan *GetMedicineChMedicalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMedicineChMedical(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMedicineChMedicalWithCallback invokes the alinlp.GetMedicineChMedical API asynchronously
func (client *Client) GetMedicineChMedicalWithCallback(request *GetMedicineChMedicalRequest, callback func(response *GetMedicineChMedicalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMedicineChMedicalResponse
		var err error
		defer close(result)
		response, err = client.GetMedicineChMedical(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMedicineChMedicalRequest is the request struct for api GetMedicineChMedical
type GetMedicineChMedicalRequest struct {
	*requests.RpcRequest
	Factory       string `position:"Body" name:"Factory"`
	Specification string `position:"Body" name:"Specification"`
	Unit          string `position:"Body" name:"Unit"`
	ServiceCode   string `position:"Body" name:"ServiceCode"`
	Name          string `position:"Body" name:"Name"`
}

// GetMedicineChMedicalResponse is the response struct for api GetMedicineChMedical
type GetMedicineChMedicalResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetMedicineChMedicalRequest creates a request to invoke GetMedicineChMedical API
func CreateGetMedicineChMedicalRequest() (request *GetMedicineChMedicalRequest) {
	request = &GetMedicineChMedicalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alinlp", "2020-06-29", "GetMedicineChMedical", "alinlp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMedicineChMedicalResponse creates a response to parse from GetMedicineChMedical response
func CreateGetMedicineChMedicalResponse() (response *GetMedicineChMedicalResponse) {
	response = &GetMedicineChMedicalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
