package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRetcodeDataByQuery invokes the arms.GetRetcodeDataByQuery API synchronously
func (client *Client) GetRetcodeDataByQuery(request *GetRetcodeDataByQueryRequest) (response *GetRetcodeDataByQueryResponse, err error) {
	response = CreateGetRetcodeDataByQueryResponse()
	err = client.DoAction(request, response)
	return
}

// GetRetcodeDataByQueryWithChan invokes the arms.GetRetcodeDataByQuery API asynchronously
func (client *Client) GetRetcodeDataByQueryWithChan(request *GetRetcodeDataByQueryRequest) (<-chan *GetRetcodeDataByQueryResponse, <-chan error) {
	responseChan := make(chan *GetRetcodeDataByQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRetcodeDataByQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRetcodeDataByQueryWithCallback invokes the arms.GetRetcodeDataByQuery API asynchronously
func (client *Client) GetRetcodeDataByQueryWithCallback(request *GetRetcodeDataByQueryRequest, callback func(response *GetRetcodeDataByQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRetcodeDataByQueryResponse
		var err error
		defer close(result)
		response, err = client.GetRetcodeDataByQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRetcodeDataByQueryRequest is the request struct for api GetRetcodeDataByQuery
type GetRetcodeDataByQueryRequest struct {
	*requests.RpcRequest
	Query string           `position:"Query" name:"Query"`
	Pid   string           `position:"Query" name:"Pid"`
	From  requests.Integer `position:"Query" name:"From"`
	To    requests.Integer `position:"Query" name:"To"`
}

// GetRetcodeDataByQueryResponse is the response struct for api GetRetcodeDataByQuery
type GetRetcodeDataByQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetRetcodeDataByQueryRequest creates a request to invoke GetRetcodeDataByQuery API
func CreateGetRetcodeDataByQueryRequest() (request *GetRetcodeDataByQueryRequest) {
	request = &GetRetcodeDataByQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "GetRetcodeDataByQuery", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRetcodeDataByQueryResponse creates a response to parse from GetRetcodeDataByQuery response
func CreateGetRetcodeDataByQueryResponse() (response *GetRetcodeDataByQueryResponse) {
	response = &GetRetcodeDataByQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
