package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnSMCertificateList invokes the cdn.DescribeCdnSMCertificateList API synchronously
func (client *Client) DescribeCdnSMCertificateList(request *DescribeCdnSMCertificateListRequest) (response *DescribeCdnSMCertificateListResponse, err error) {
	response = CreateDescribeCdnSMCertificateListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnSMCertificateListWithChan invokes the cdn.DescribeCdnSMCertificateList API asynchronously
func (client *Client) DescribeCdnSMCertificateListWithChan(request *DescribeCdnSMCertificateListRequest) (<-chan *DescribeCdnSMCertificateListResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnSMCertificateListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnSMCertificateList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnSMCertificateListWithCallback invokes the cdn.DescribeCdnSMCertificateList API asynchronously
func (client *Client) DescribeCdnSMCertificateListWithCallback(request *DescribeCdnSMCertificateListRequest, callback func(response *DescribeCdnSMCertificateListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnSMCertificateListResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnSMCertificateList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnSMCertificateListRequest is the request struct for api DescribeCdnSMCertificateList
type DescribeCdnSMCertificateListRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCdnSMCertificateListResponse is the response struct for api DescribeCdnSMCertificateList
type DescribeCdnSMCertificateListResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	CertificateListModel CertificateListModel `json:"CertificateListModel" xml:"CertificateListModel"`
}

// CreateDescribeCdnSMCertificateListRequest creates a request to invoke DescribeCdnSMCertificateList API
func CreateDescribeCdnSMCertificateListRequest() (request *DescribeCdnSMCertificateListRequest) {
	request = &DescribeCdnSMCertificateListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeCdnSMCertificateList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnSMCertificateListResponse creates a response to parse from DescribeCdnSMCertificateList response
func CreateDescribeCdnSMCertificateListResponse() (response *DescribeCdnSMCertificateListResponse) {
	response = &DescribeCdnSMCertificateListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
