package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOutBoundData invokes the cloudcallcenter.GetOutBoundData API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getoutbounddata.html
func (client *Client) GetOutBoundData(request *GetOutBoundDataRequest) (response *GetOutBoundDataResponse, err error) {
	response = CreateGetOutBoundDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetOutBoundDataWithChan invokes the cloudcallcenter.GetOutBoundData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getoutbounddata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOutBoundDataWithChan(request *GetOutBoundDataRequest) (<-chan *GetOutBoundDataResponse, <-chan error) {
	responseChan := make(chan *GetOutBoundDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOutBoundData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOutBoundDataWithCallback invokes the cloudcallcenter.GetOutBoundData API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getoutbounddata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOutBoundDataWithCallback(request *GetOutBoundDataRequest, callback func(response *GetOutBoundDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOutBoundDataResponse
		var err error
		defer close(result)
		response, err = client.GetOutBoundData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOutBoundDataRequest is the request struct for api GetOutBoundData
type GetOutBoundDataRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	SkillGroupId string `position:"Query" name:"SkillGroupId"`
	JobGroupId   string `position:"Query" name:"JobGroupId"`
}

// GetOutBoundDataResponse is the response struct for api GetOutBoundData
type GetOutBoundDataResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"data" xml:"data"`
}

// CreateGetOutBoundDataRequest creates a request to invoke GetOutBoundData API
func CreateGetOutBoundDataRequest() (request *GetOutBoundDataRequest) {
	request = &GetOutBoundDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetOutBoundData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOutBoundDataResponse creates a response to parse from GetOutBoundData response
func CreateGetOutBoundDataResponse() (response *GetOutBoundDataResponse) {
	response = &GetOutBoundDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
