package cr_ee

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoTagLayers invokes the cr.GetRepoTagLayers API synchronously
// api document: https://help.aliyun.com/api/cr/getrepotaglayers.html
func (client *Client) GetRepoTagLayers(request *GetRepoTagLayersRequest) (response *GetRepoTagLayersResponse, err error) {
	response = CreateGetRepoTagLayersResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoTagLayersWithChan invokes the cr.GetRepoTagLayers API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepotaglayers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoTagLayersWithChan(request *GetRepoTagLayersRequest) (<-chan *GetRepoTagLayersResponse, <-chan error) {
	responseChan := make(chan *GetRepoTagLayersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoTagLayers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoTagLayersWithCallback invokes the cr.GetRepoTagLayers API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepotaglayers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoTagLayersWithCallback(request *GetRepoTagLayersRequest, callback func(response *GetRepoTagLayersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoTagLayersResponse
		var err error
		defer close(result)
		response, err = client.GetRepoTagLayers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoTagLayersRequest is the request struct for api GetRepoTagLayers
type GetRepoTagLayersRequest struct {
	*requests.RpcRequest
	RepoId     string `position:"Query" name:"RepoId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	Tag        string `position:"Query" name:"Tag"`
}

// GetRepoTagLayersResponse is the response struct for api GetRepoTagLayers
type GetRepoTagLayersResponse struct {
	*responses.BaseResponse
	GetRepoTagLayersIsSuccess bool         `json:"IsSuccess" xml:"IsSuccess"`
	Code                      string       `json:"Code" xml:"Code"`
	RequestId                 string       `json:"RequestId" xml:"RequestId"`
	Layers                    []LayersItem `json:"Layers" xml:"Layers"`
}

// CreateGetRepoTagLayersRequest creates a request to invoke GetRepoTagLayers API
func CreateGetRepoTagLayersRequest() (request *GetRepoTagLayersRequest) {
	request = &GetRepoTagLayersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cr", "2018-12-01", "GetRepoTagLayers", "acr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRepoTagLayersResponse creates a response to parse from GetRepoTagLayers response
func CreateGetRepoTagLayersResponse() (response *GetRepoTagLayersResponse) {
	response = &GetRepoTagLayersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
