package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteIdpDepartment invokes the csas.DeleteIdpDepartment API synchronously
func (client *Client) DeleteIdpDepartment(request *DeleteIdpDepartmentRequest) (response *DeleteIdpDepartmentResponse, err error) {
	response = CreateDeleteIdpDepartmentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteIdpDepartmentWithChan invokes the csas.DeleteIdpDepartment API asynchronously
func (client *Client) DeleteIdpDepartmentWithChan(request *DeleteIdpDepartmentRequest) (<-chan *DeleteIdpDepartmentResponse, <-chan error) {
	responseChan := make(chan *DeleteIdpDepartmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteIdpDepartment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteIdpDepartmentWithCallback invokes the csas.DeleteIdpDepartment API asynchronously
func (client *Client) DeleteIdpDepartmentWithCallback(request *DeleteIdpDepartmentRequest, callback func(response *DeleteIdpDepartmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteIdpDepartmentResponse
		var err error
		defer close(result)
		response, err = client.DeleteIdpDepartment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteIdpDepartmentRequest is the request struct for api DeleteIdpDepartment
type DeleteIdpDepartmentRequest struct {
	*requests.RpcRequest
	DepartmentId string `position:"Query" name:"DepartmentId"`
	IdpConfigId  string `position:"Query" name:"IdpConfigId"`
}

// DeleteIdpDepartmentResponse is the response struct for api DeleteIdpDepartment
type DeleteIdpDepartmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteIdpDepartmentRequest creates a request to invoke DeleteIdpDepartment API
func CreateDeleteIdpDepartmentRequest() (request *DeleteIdpDepartmentRequest) {
	request = &DeleteIdpDepartmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DeleteIdpDepartment", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteIdpDepartmentResponse creates a response to parse from DeleteIdpDepartment response
func CreateDeleteIdpDepartmentResponse() (response *DeleteIdpDepartmentResponse) {
	response = &DeleteIdpDepartmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
