package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegistrationPolicy invokes the csas.GetRegistrationPolicy API synchronously
func (client *Client) GetRegistrationPolicy(request *GetRegistrationPolicyRequest) (response *GetRegistrationPolicyResponse, err error) {
	response = CreateGetRegistrationPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegistrationPolicyWithChan invokes the csas.GetRegistrationPolicy API asynchronously
func (client *Client) GetRegistrationPolicyWithChan(request *GetRegistrationPolicyRequest) (<-chan *GetRegistrationPolicyResponse, <-chan error) {
	responseChan := make(chan *GetRegistrationPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegistrationPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegistrationPolicyWithCallback invokes the csas.GetRegistrationPolicy API asynchronously
func (client *Client) GetRegistrationPolicyWithCallback(request *GetRegistrationPolicyRequest, callback func(response *GetRegistrationPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegistrationPolicyResponse
		var err error
		defer close(result)
		response, err = client.GetRegistrationPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegistrationPolicyRequest is the request struct for api GetRegistrationPolicy
type GetRegistrationPolicyRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	PolicyId string `position:"Query" name:"PolicyId"`
}

// GetRegistrationPolicyResponse is the response struct for api GetRegistrationPolicy
type GetRegistrationPolicyResponse struct {
	*responses.BaseResponse
	RequestId    string            `json:"RequestId" xml:"RequestId"`
	Name         string            `json:"Name" xml:"Name"`
	PolicyId     string            `json:"PolicyId" xml:"PolicyId"`
	Description  string            `json:"Description" xml:"Description"`
	Priority     int64             `json:"Priority" xml:"Priority"`
	Status       string            `json:"Status" xml:"Status"`
	MatchMode    string            `json:"MatchMode" xml:"MatchMode"`
	CreateTime   string            `json:"CreateTime" xml:"CreateTime"`
	Whitelist    []string          `json:"Whitelist" xml:"Whitelist"`
	UserGroupIds []string          `json:"UserGroupIds" xml:"UserGroupIds"`
	LimitDetail  []LimitDetailItem `json:"LimitDetail" xml:"LimitDetail"`
}

// CreateGetRegistrationPolicyRequest creates a request to invoke GetRegistrationPolicy API
func CreateGetRegistrationPolicyRequest() (request *GetRegistrationPolicyRequest) {
	request = &GetRegistrationPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetRegistrationPolicy", "", "")
	request.Method = requests.GET
	return
}

// CreateGetRegistrationPolicyResponse creates a response to parse from GetRegistrationPolicy response
func CreateGetRegistrationPolicyResponse() (response *GetRegistrationPolicyResponse) {
	response = &GetRegistrationPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
