package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateNacUserCertStatus invokes the csas.UpdateNacUserCertStatus API synchronously
func (client *Client) UpdateNacUserCertStatus(request *UpdateNacUserCertStatusRequest) (response *UpdateNacUserCertStatusResponse, err error) {
	response = CreateUpdateNacUserCertStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateNacUserCertStatusWithChan invokes the csas.UpdateNacUserCertStatus API asynchronously
func (client *Client) UpdateNacUserCertStatusWithChan(request *UpdateNacUserCertStatusRequest) (<-chan *UpdateNacUserCertStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateNacUserCertStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateNacUserCertStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateNacUserCertStatusWithCallback invokes the csas.UpdateNacUserCertStatus API asynchronously
func (client *Client) UpdateNacUserCertStatusWithCallback(request *UpdateNacUserCertStatusRequest, callback func(response *UpdateNacUserCertStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateNacUserCertStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateNacUserCertStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateNacUserCertStatusRequest is the request struct for api UpdateNacUserCertStatus
type UpdateNacUserCertStatusRequest struct {
	*requests.RpcRequest
	IdList *[]UpdateNacUserCertStatusIdList `position:"Body" name:"IdList"  type:"Repeated"`
	Status string                           `position:"Body" name:"Status"`
}

// UpdateNacUserCertStatusIdList is a repeated param struct in UpdateNacUserCertStatusRequest
type UpdateNacUserCertStatusIdList struct {
	UserId string `name:"UserId"`
	DevTag string `name:"DevTag"`
}

// UpdateNacUserCertStatusResponse is the response struct for api UpdateNacUserCertStatus
type UpdateNacUserCertStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateNacUserCertStatusRequest creates a request to invoke UpdateNacUserCertStatus API
func CreateUpdateNacUserCertStatusRequest() (request *UpdateNacUserCertStatusRequest) {
	request = &UpdateNacUserCertStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateNacUserCertStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateNacUserCertStatusResponse creates a response to parse from UpdateNacUserCertStatus response
func CreateUpdateNacUserCertStatusResponse() (response *UpdateNacUserCertStatusResponse) {
	response = &UpdateNacUserCertStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
