package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDISyncTask invokes the dataworks_public.GetDISyncTask API synchronously
func (client *Client) GetDISyncTask(request *GetDISyncTaskRequest) (response *GetDISyncTaskResponse, err error) {
	response = CreateGetDISyncTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetDISyncTaskWithChan invokes the dataworks_public.GetDISyncTask API asynchronously
func (client *Client) GetDISyncTaskWithChan(request *GetDISyncTaskRequest) (<-chan *GetDISyncTaskResponse, <-chan error) {
	responseChan := make(chan *GetDISyncTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDISyncTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDISyncTaskWithCallback invokes the dataworks_public.GetDISyncTask API asynchronously
func (client *Client) GetDISyncTaskWithCallback(request *GetDISyncTaskRequest, callback func(response *GetDISyncTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDISyncTaskResponse
		var err error
		defer close(result)
		response, err = client.GetDISyncTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDISyncTaskRequest is the request struct for api GetDISyncTask
type GetDISyncTaskRequest struct {
	*requests.RpcRequest
	TaskType  string           `position:"Query" name:"TaskType"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
	FileId    requests.Integer `position:"Query" name:"FileId"`
}

// GetDISyncTaskResponse is the response struct for api GetDISyncTask
type GetDISyncTaskResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetDISyncTaskRequest creates a request to invoke GetDISyncTask API
func CreateGetDISyncTaskRequest() (request *GetDISyncTaskRequest) {
	request = &GetDISyncTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDISyncTask", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDISyncTaskResponse creates a response to parse from GetDISyncTask response
func CreateGetDISyncTaskResponse() (response *GetDISyncTaskResponse) {
	response = &GetDISyncTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
