package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableWebCCRule invokes the ddoscoo.DisableWebCCRule API synchronously
func (client *Client) DisableWebCCRule(request *DisableWebCCRuleRequest) (response *DisableWebCCRuleResponse, err error) {
	response = CreateDisableWebCCRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableWebCCRuleWithChan invokes the ddoscoo.DisableWebCCRule API asynchronously
func (client *Client) DisableWebCCRuleWithChan(request *DisableWebCCRuleRequest) (<-chan *DisableWebCCRuleResponse, <-chan error) {
	responseChan := make(chan *DisableWebCCRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableWebCCRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableWebCCRuleWithCallback invokes the ddoscoo.DisableWebCCRule API asynchronously
func (client *Client) DisableWebCCRuleWithCallback(request *DisableWebCCRuleRequest, callback func(response *DisableWebCCRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableWebCCRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableWebCCRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableWebCCRuleRequest is the request struct for api DisableWebCCRule
type DisableWebCCRuleRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Domain          string `position:"Query" name:"Domain"`
}

// DisableWebCCRuleResponse is the response struct for api DisableWebCCRule
type DisableWebCCRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableWebCCRuleRequest creates a request to invoke DisableWebCCRule API
func CreateDisableWebCCRuleRequest() (request *DisableWebCCRuleRequest) {
	request = &DisableWebCCRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DisableWebCCRule", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableWebCCRuleResponse creates a response to parse from DisableWebCCRule response
func CreateDisableWebCCRuleResponse() (response *DisableWebCCRuleResponse) {
	response = &DisableWebCCRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
