package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferClusterBackup invokes the dds.TransferClusterBackup API synchronously
func (client *Client) TransferClusterBackup(request *TransferClusterBackupRequest) (response *TransferClusterBackupResponse, err error) {
	response = CreateTransferClusterBackupResponse()
	err = client.DoAction(request, response)
	return
}

// TransferClusterBackupWithChan invokes the dds.TransferClusterBackup API asynchronously
func (client *Client) TransferClusterBackupWithChan(request *TransferClusterBackupRequest) (<-chan *TransferClusterBackupResponse, <-chan error) {
	responseChan := make(chan *TransferClusterBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferClusterBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferClusterBackupWithCallback invokes the dds.TransferClusterBackup API asynchronously
func (client *Client) TransferClusterBackupWithCallback(request *TransferClusterBackupRequest, callback func(response *TransferClusterBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferClusterBackupResponse
		var err error
		defer close(result)
		response, err = client.TransferClusterBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferClusterBackupRequest is the request struct for api TransferClusterBackup
type TransferClusterBackupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// TransferClusterBackupResponse is the response struct for api TransferClusterBackup
type TransferClusterBackupResponse struct {
	*responses.BaseResponse
	AlreadyDone string `json:"AlreadyDone" xml:"AlreadyDone"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateTransferClusterBackupRequest creates a request to invoke TransferClusterBackup API
func CreateTransferClusterBackupRequest() (request *TransferClusterBackupRequest) {
	request = &TransferClusterBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "TransferClusterBackup", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTransferClusterBackupResponse creates a response to parse from TransferClusterBackup response
func CreateTransferClusterBackupResponse() (response *TransferClusterBackupResponse) {
	response = &TransferClusterBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
