package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskFlowOwner invokes the dms_enterprise.UpdateTaskFlowOwner API synchronously
func (client *Client) UpdateTaskFlowOwner(request *UpdateTaskFlowOwnerRequest) (response *UpdateTaskFlowOwnerResponse, err error) {
	response = CreateUpdateTaskFlowOwnerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskFlowOwnerWithChan invokes the dms_enterprise.UpdateTaskFlowOwner API asynchronously
func (client *Client) UpdateTaskFlowOwnerWithChan(request *UpdateTaskFlowOwnerRequest) (<-chan *UpdateTaskFlowOwnerResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskFlowOwnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskFlowOwner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskFlowOwnerWithCallback invokes the dms_enterprise.UpdateTaskFlowOwner API asynchronously
func (client *Client) UpdateTaskFlowOwnerWithCallback(request *UpdateTaskFlowOwnerRequest, callback func(response *UpdateTaskFlowOwnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskFlowOwnerResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskFlowOwner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskFlowOwnerRequest is the request struct for api UpdateTaskFlowOwner
type UpdateTaskFlowOwnerRequest struct {
	*requests.RpcRequest
	DagId      requests.Integer `position:"Query" name:"DagId"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	NewOwnerId string           `position:"Query" name:"NewOwnerId"`
}

// UpdateTaskFlowOwnerResponse is the response struct for api UpdateTaskFlowOwner
type UpdateTaskFlowOwnerResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskFlowOwnerRequest creates a request to invoke UpdateTaskFlowOwner API
func CreateUpdateTaskFlowOwnerRequest() (request *UpdateTaskFlowOwnerRequest) {
	request = &UpdateTaskFlowOwnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskFlowOwner", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskFlowOwnerResponse creates a response to parse from UpdateTaskFlowOwner response
func CreateUpdateTaskFlowOwnerResponse() (response *UpdateTaskFlowOwnerResponse) {
	response = &UpdateTaskFlowOwnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
