package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcIcSeriousOffense invokes the dt_oc_info.GetOcIcSeriousOffense API synchronously
func (client *Client) GetOcIcSeriousOffense(request *GetOcIcSeriousOffenseRequest) (response *GetOcIcSeriousOffenseResponse, err error) {
	response = CreateGetOcIcSeriousOffenseResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcIcSeriousOffenseWithChan invokes the dt_oc_info.GetOcIcSeriousOffense API asynchronously
func (client *Client) GetOcIcSeriousOffenseWithChan(request *GetOcIcSeriousOffenseRequest) (<-chan *GetOcIcSeriousOffenseResponse, <-chan error) {
	responseChan := make(chan *GetOcIcSeriousOffenseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcIcSeriousOffense(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcIcSeriousOffenseWithCallback invokes the dt_oc_info.GetOcIcSeriousOffense API asynchronously
func (client *Client) GetOcIcSeriousOffenseWithCallback(request *GetOcIcSeriousOffenseRequest, callback func(response *GetOcIcSeriousOffenseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcIcSeriousOffenseResponse
		var err error
		defer close(result)
		response, err = client.GetOcIcSeriousOffense(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcIcSeriousOffenseRequest is the request struct for api GetOcIcSeriousOffense
type GetOcIcSeriousOffenseRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Body" name:"PageNo"`
	PageSize  requests.Integer `position:"Body" name:"PageSize"`
	SearchKey string           `position:"Body" name:"SearchKey"`
}

// GetOcIcSeriousOffenseResponse is the response struct for api GetOcIcSeriousOffense
type GetOcIcSeriousOffenseResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	TotalNum  int        `json:"TotalNum" xml:"TotalNum"`
	PageIndex int        `json:"PageIndex" xml:"PageIndex"`
	PageNum   int        `json:"PageNum" xml:"PageNum"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOcIcSeriousOffenseRequest creates a request to invoke GetOcIcSeriousOffense API
func CreateGetOcIcSeriousOffenseRequest() (request *GetOcIcSeriousOffenseRequest) {
	request = &GetOcIcSeriousOffenseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcIcSeriousOffense", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcIcSeriousOffenseResponse creates a response to parse from GetOcIcSeriousOffense response
func CreateGetOcIcSeriousOffenseResponse() (response *GetOcIcSeriousOffenseResponse) {
	response = &GetOcIcSeriousOffenseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
