package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyWithFusionAuthToken invokes the dypnsapi.VerifyWithFusionAuthToken API synchronously
func (client *Client) VerifyWithFusionAuthToken(request *VerifyWithFusionAuthTokenRequest) (response *VerifyWithFusionAuthTokenResponse, err error) {
	response = CreateVerifyWithFusionAuthTokenResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyWithFusionAuthTokenWithChan invokes the dypnsapi.VerifyWithFusionAuthToken API asynchronously
func (client *Client) VerifyWithFusionAuthTokenWithChan(request *VerifyWithFusionAuthTokenRequest) (<-chan *VerifyWithFusionAuthTokenResponse, <-chan error) {
	responseChan := make(chan *VerifyWithFusionAuthTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyWithFusionAuthToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyWithFusionAuthTokenWithCallback invokes the dypnsapi.VerifyWithFusionAuthToken API asynchronously
func (client *Client) VerifyWithFusionAuthTokenWithCallback(request *VerifyWithFusionAuthTokenRequest, callback func(response *VerifyWithFusionAuthTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyWithFusionAuthTokenResponse
		var err error
		defer close(result)
		response, err = client.VerifyWithFusionAuthToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyWithFusionAuthTokenRequest is the request struct for api VerifyWithFusionAuthToken
type VerifyWithFusionAuthTokenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	VerifyToken          string           `position:"Query" name:"VerifyToken"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// VerifyWithFusionAuthTokenResponse is the response struct for api VerifyWithFusionAuthToken
type VerifyWithFusionAuthTokenResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateVerifyWithFusionAuthTokenRequest creates a request to invoke VerifyWithFusionAuthToken API
func CreateVerifyWithFusionAuthTokenRequest() (request *VerifyWithFusionAuthTokenRequest) {
	request = &VerifyWithFusionAuthTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "VerifyWithFusionAuthToken", "dypnsapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVerifyWithFusionAuthTokenResponse creates a response to parse from VerifyWithFusionAuthToken response
func CreateVerifyWithFusionAuthTokenResponse() (response *VerifyWithFusionAuthTokenResponse) {
	response = &VerifyWithFusionAuthTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
