package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskReplicaGroups invokes the ebs.DescribeDiskReplicaGroups API synchronously
func (client *Client) DescribeDiskReplicaGroups(request *DescribeDiskReplicaGroupsRequest) (response *DescribeDiskReplicaGroupsResponse, err error) {
	response = CreateDescribeDiskReplicaGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskReplicaGroupsWithChan invokes the ebs.DescribeDiskReplicaGroups API asynchronously
func (client *Client) DescribeDiskReplicaGroupsWithChan(request *DescribeDiskReplicaGroupsRequest) (<-chan *DescribeDiskReplicaGroupsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskReplicaGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskReplicaGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskReplicaGroupsWithCallback invokes the ebs.DescribeDiskReplicaGroups API asynchronously
func (client *Client) DescribeDiskReplicaGroupsWithCallback(request *DescribeDiskReplicaGroupsRequest, callback func(response *DescribeDiskReplicaGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskReplicaGroupsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskReplicaGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskReplicaGroupsRequest is the request struct for api DescribeDiskReplicaGroups
type DescribeDiskReplicaGroupsRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer                `position:"Query" name:"PageNumber"`
	ResourceGroupId string                          `position:"Query" name:"ResourceGroupId"`
	NextToken       string                          `position:"Query" name:"NextToken"`
	PageSize        requests.Integer                `position:"Query" name:"PageSize"`
	Tag             *[]DescribeDiskReplicaGroupsTag `position:"Query" name:"Tag"  type:"Repeated"`
	Site            string                          `position:"Query" name:"Site"`
	GroupIds        string                          `position:"Query" name:"GroupIds"`
	MaxResults      requests.Integer                `position:"Query" name:"MaxResults"`
}

// DescribeDiskReplicaGroupsTag is a repeated param struct in DescribeDiskReplicaGroupsRequest
type DescribeDiskReplicaGroupsTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDiskReplicaGroupsResponse is the response struct for api DescribeDiskReplicaGroups
type DescribeDiskReplicaGroupsResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	NextToken     string         `json:"NextToken" xml:"NextToken"`
	PageNumber    int            `json:"PageNumber" xml:"PageNumber"`
	PageSize      int            `json:"PageSize" xml:"PageSize"`
	TotalCount    int64          `json:"TotalCount" xml:"TotalCount"`
	ReplicaGroups []ReplicaGroup `json:"ReplicaGroups" xml:"ReplicaGroups"`
}

// CreateDescribeDiskReplicaGroupsRequest creates a request to invoke DescribeDiskReplicaGroups API
func CreateDescribeDiskReplicaGroupsRequest() (request *DescribeDiskReplicaGroupsRequest) {
	request = &DescribeDiskReplicaGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDiskReplicaGroups", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskReplicaGroupsResponse creates a response to parse from DescribeDiskReplicaGroups response
func CreateDescribeDiskReplicaGroupsResponse() (response *DescribeDiskReplicaGroupsResponse) {
	response = &DescribeDiskReplicaGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
