package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopTimer invokes the ecd.ModifyDesktopTimer API synchronously
func (client *Client) ModifyDesktopTimer(request *ModifyDesktopTimerRequest) (response *ModifyDesktopTimerResponse, err error) {
	response = CreateModifyDesktopTimerResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopTimerWithChan invokes the ecd.ModifyDesktopTimer API asynchronously
func (client *Client) ModifyDesktopTimerWithChan(request *ModifyDesktopTimerRequest) (<-chan *ModifyDesktopTimerResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopTimerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopTimer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopTimerWithCallback invokes the ecd.ModifyDesktopTimer API asynchronously
func (client *Client) ModifyDesktopTimerWithCallback(request *ModifyDesktopTimerRequest, callback func(response *ModifyDesktopTimerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopTimerResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopTimer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopTimerRequest is the request struct for api ModifyDesktopTimer
type ModifyDesktopTimerRequest struct {
	*requests.RpcRequest
	CronExpression   string                             `position:"Query" name:"CronExpression"`
	TimerType        string                             `position:"Query" name:"TimerType"`
	DesktopTimers    *[]ModifyDesktopTimerDesktopTimers `position:"Query" name:"DesktopTimers"  type:"Repeated"`
	DesktopId        *[]string                          `position:"Query" name:"DesktopId"  type:"Repeated"`
	ResetType        string                             `position:"Query" name:"ResetType"`
	OperationType    string                             `position:"Query" name:"OperationType"`
	TimerStatus      string                             `position:"Query" name:"TimerStatus"`
	Enforce          requests.Boolean                   `position:"Query" name:"Enforce"`
	UseDesktopTimers requests.Boolean                   `position:"Query" name:"UseDesktopTimers"`
	Interval         requests.Integer                   `position:"Query" name:"Interval"`
}

// ModifyDesktopTimerDesktopTimers is a repeated param struct in ModifyDesktopTimerRequest
type ModifyDesktopTimerDesktopTimers struct {
	CronExpression     string `name:"CronExpression"`
	TimerType          string `name:"TimerType"`
	AllowClientSetting string `name:"AllowClientSetting"`
	ResetType          string `name:"ResetType"`
	Enforce            string `name:"Enforce"`
	Interval           string `name:"Interval"`
	OperationType      string `name:"OperationType"`
}

// ModifyDesktopTimerResponse is the response struct for api ModifyDesktopTimer
type ModifyDesktopTimerResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	DesktopIds []string `json:"DesktopIds" xml:"DesktopIds"`
}

// CreateModifyDesktopTimerRequest creates a request to invoke ModifyDesktopTimer API
func CreateModifyDesktopTimerRequest() (request *ModifyDesktopTimerRequest) {
	request = &ModifyDesktopTimerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopTimer", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopTimerResponse creates a response to parse from ModifyDesktopTimer response
func CreateModifyDesktopTimerResponse() (response *ModifyDesktopTimerResponse) {
	response = &ModifyDesktopTimerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
