package eflo_controller

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNode invokes the eflo_controller.DescribeNode API synchronously
func (client *Client) DescribeNode(request *DescribeNodeRequest) (response *DescribeNodeResponse, err error) {
	response = CreateDescribeNodeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNodeWithChan invokes the eflo_controller.DescribeNode API asynchronously
func (client *Client) DescribeNodeWithChan(request *DescribeNodeRequest) (<-chan *DescribeNodeResponse, <-chan error) {
	responseChan := make(chan *DescribeNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNodeWithCallback invokes the eflo_controller.DescribeNode API asynchronously
func (client *Client) DescribeNodeWithCallback(request *DescribeNodeRequest, callback func(response *DescribeNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNodeResponse
		var err error
		defer close(result)
		response, err = client.DescribeNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNodeRequest is the request struct for api DescribeNode
type DescribeNodeRequest struct {
	*requests.RpcRequest
	NodeId string `position:"Body" name:"NodeId"`
}

// DescribeNodeResponse is the response struct for api DescribeNode
type DescribeNodeResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	NodeGroupName  string         `json:"NodeGroupName" xml:"NodeGroupName"`
	ClusterId      string         `json:"ClusterId" xml:"ClusterId"`
	ClusterName    string         `json:"ClusterName" xml:"ClusterName"`
	ZoneId         string         `json:"ZoneId" xml:"ZoneId"`
	CreateTime     string         `json:"CreateTime" xml:"CreateTime"`
	NodeGroupId    string         `json:"NodeGroupId" xml:"NodeGroupId"`
	Hostname       string         `json:"Hostname" xml:"Hostname"`
	ImageId        string         `json:"ImageId" xml:"ImageId"`
	MachineType    string         `json:"MachineType" xml:"MachineType"`
	NodeId         string         `json:"NodeId" xml:"NodeId"`
	Sn             string         `json:"Sn" xml:"Sn"`
	OperatingState string         `json:"OperatingState" xml:"OperatingState"`
	ExpiredTime    string         `json:"ExpiredTime" xml:"ExpiredTime"`
	Networks       []NetworksItem `json:"Networks" xml:"Networks"`
}

// CreateDescribeNodeRequest creates a request to invoke DescribeNode API
func CreateDescribeNodeRequest() (request *DescribeNodeRequest) {
	request = &DescribeNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo-controller", "2022-12-15", "DescribeNode", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeNodeResponse creates a response to parse from DescribeNode response
func CreateDescribeNodeResponse() (response *DescribeNodeResponse) {
	response = &DescribeNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
