package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiagnosisSettings invokes the elasticsearch.DescribeDiagnosisSettings API synchronously
func (client *Client) DescribeDiagnosisSettings(request *DescribeDiagnosisSettingsRequest) (response *DescribeDiagnosisSettingsResponse, err error) {
	response = CreateDescribeDiagnosisSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiagnosisSettingsWithChan invokes the elasticsearch.DescribeDiagnosisSettings API asynchronously
func (client *Client) DescribeDiagnosisSettingsWithChan(request *DescribeDiagnosisSettingsRequest) (<-chan *DescribeDiagnosisSettingsResponse, <-chan error) {
	responseChan := make(chan *DescribeDiagnosisSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiagnosisSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiagnosisSettingsWithCallback invokes the elasticsearch.DescribeDiagnosisSettings API asynchronously
func (client *Client) DescribeDiagnosisSettingsWithCallback(request *DescribeDiagnosisSettingsRequest, callback func(response *DescribeDiagnosisSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiagnosisSettingsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiagnosisSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiagnosisSettingsRequest is the request struct for api DescribeDiagnosisSettings
type DescribeDiagnosisSettingsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
	Lang       string `position:"Query" name:"lang"`
}

// DescribeDiagnosisSettingsResponse is the response struct for api DescribeDiagnosisSettings
type DescribeDiagnosisSettingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeDiagnosisSettingsRequest creates a request to invoke DescribeDiagnosisSettings API
func CreateDescribeDiagnosisSettingsRequest() (request *DescribeDiagnosisSettingsRequest) {
	request = &DescribeDiagnosisSettingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeDiagnosisSettings", "/openapi/diagnosis/instances/[InstanceId]/settings", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDiagnosisSettingsResponse creates a response to parse from DescribeDiagnosisSettings response
func CreateDescribeDiagnosisSettingsResponse() (response *DescribeDiagnosisSettingsResponse) {
	response = &DescribeDiagnosisSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
