package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableRule invokes the eventbridge.DisableRule API synchronously
func (client *Client) DisableRule(request *DisableRuleRequest) (response *DisableRuleResponse, err error) {
	response = CreateDisableRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DisableRuleWithChan invokes the eventbridge.DisableRule API asynchronously
func (client *Client) DisableRuleWithChan(request *DisableRuleRequest) (<-chan *DisableRuleResponse, <-chan error) {
	responseChan := make(chan *DisableRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableRuleWithCallback invokes the eventbridge.DisableRule API asynchronously
func (client *Client) DisableRuleWithCallback(request *DisableRuleRequest, callback func(response *DisableRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableRuleResponse
		var err error
		defer close(result)
		response, err = client.DisableRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableRuleRequest is the request struct for api DisableRule
type DisableRuleRequest struct {
	*requests.RpcRequest
	RuleName     string `position:"Query" name:"RuleName"`
	EventBusName string `position:"Query" name:"EventBusName"`
}

// DisableRuleResponse is the response struct for api DisableRule
type DisableRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDisableRuleRequest creates a request to invoke DisableRule API
func CreateDisableRuleRequest() (request *DisableRuleRequest) {
	request = &DisableRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "DisableRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableRuleResponse creates a response to parse from DisableRule response
func CreateDisableRuleResponse() (response *DisableRuleResponse) {
	response = &DisableRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
