package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RpcNoDefaultErrorCodeApi invokes the ft.RpcNoDefaultErrorCodeApi API synchronously
func (client *Client) RpcNoDefaultErrorCodeApi(request *RpcNoDefaultErrorCodeApiRequest) (response *RpcNoDefaultErrorCodeApiResponse, err error) {
	response = CreateRpcNoDefaultErrorCodeApiResponse()
	err = client.DoAction(request, response)
	return
}

// RpcNoDefaultErrorCodeApiWithChan invokes the ft.RpcNoDefaultErrorCodeApi API asynchronously
func (client *Client) RpcNoDefaultErrorCodeApiWithChan(request *RpcNoDefaultErrorCodeApiRequest) (<-chan *RpcNoDefaultErrorCodeApiResponse, <-chan error) {
	responseChan := make(chan *RpcNoDefaultErrorCodeApiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RpcNoDefaultErrorCodeApi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RpcNoDefaultErrorCodeApiWithCallback invokes the ft.RpcNoDefaultErrorCodeApi API asynchronously
func (client *Client) RpcNoDefaultErrorCodeApiWithCallback(request *RpcNoDefaultErrorCodeApiRequest, callback func(response *RpcNoDefaultErrorCodeApiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RpcNoDefaultErrorCodeApiResponse
		var err error
		defer close(result)
		response, err = client.RpcNoDefaultErrorCodeApi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RpcNoDefaultErrorCodeApiRequest is the request struct for api RpcNoDefaultErrorCodeApi
type RpcNoDefaultErrorCodeApiRequest struct {
	*requests.RpcRequest
	HttpMe         string `position:"Query" name:"HttpMe"`
	HttpStatusCode string `position:"Query" name:"HttpStatusCode"`
	SetUser        string `position:"Query" name:"SetUser"`
	Code           string `position:"Query" name:"Code"`
	Success        string `position:"Query" name:"Success"`
	Message        string `position:"Query" name:"Message"`
}

// RpcNoDefaultErrorCodeApiResponse is the response struct for api RpcNoDefaultErrorCodeApi
type RpcNoDefaultErrorCodeApiResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Success string `json:"Success" xml:"Success"`
}

// CreateRpcNoDefaultErrorCodeApiRequest creates a request to invoke RpcNoDefaultErrorCodeApi API
func CreateRpcNoDefaultErrorCodeApiRequest() (request *RpcNoDefaultErrorCodeApiRequest) {
	request = &RpcNoDefaultErrorCodeApiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2015-03-03", "RpcNoDefaultErrorCodeApi", "", "")
	request.Method = requests.POST
	return
}

// CreateRpcNoDefaultErrorCodeApiResponse creates a response to parse from RpcNoDefaultErrorCodeApi response
func CreateRpcNoDefaultErrorCodeApiResponse() (response *RpcNoDefaultErrorCodeApiResponse) {
	response = &RpcNoDefaultErrorCodeApiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
