package green

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddVideoDnaGroup invokes the green.AddVideoDnaGroup API synchronously
func (client *Client) AddVideoDnaGroup(request *AddVideoDnaGroupRequest) (response *AddVideoDnaGroupResponse, err error) {
	response = CreateAddVideoDnaGroupResponse()
	err = client.DoAction(request, response)
	return
}

// AddVideoDnaGroupWithChan invokes the green.AddVideoDnaGroup API asynchronously
func (client *Client) AddVideoDnaGroupWithChan(request *AddVideoDnaGroupRequest) (<-chan *AddVideoDnaGroupResponse, <-chan error) {
	responseChan := make(chan *AddVideoDnaGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddVideoDnaGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddVideoDnaGroupWithCallback invokes the green.AddVideoDnaGroup API asynchronously
func (client *Client) AddVideoDnaGroupWithCallback(request *AddVideoDnaGroupRequest, callback func(response *AddVideoDnaGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddVideoDnaGroupResponse
		var err error
		defer close(result)
		response, err = client.AddVideoDnaGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddVideoDnaGroupRequest is the request struct for api AddVideoDnaGroup
type AddVideoDnaGroupRequest struct {
	*requests.RoaRequest
	ClientInfo string `position:"Query" name:"ClientInfo"`
}

// AddVideoDnaGroupResponse is the response struct for api AddVideoDnaGroup
type AddVideoDnaGroupResponse struct {
	*responses.BaseResponse
}

// CreateAddVideoDnaGroupRequest creates a request to invoke AddVideoDnaGroup API
func CreateAddVideoDnaGroupRequest() (request *AddVideoDnaGroupRequest) {
	request = &AddVideoDnaGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Green", "2018-05-09", "AddVideoDnaGroup", "/green/video/dna/group/add", "", "")
	request.Method = requests.POST
	return
}

// CreateAddVideoDnaGroupResponse creates a response to parse from AddVideoDnaGroup response
func CreateAddVideoDnaGroupResponse() (response *AddVideoDnaGroupResponse) {
	response = &AddVideoDnaGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
