package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryFaceUserGroupAndDeviceGroupRelation invokes the linkvisual.QueryFaceUserGroupAndDeviceGroupRelation API synchronously
func (client *Client) QueryFaceUserGroupAndDeviceGroupRelation(request *QueryFaceUserGroupAndDeviceGroupRelationRequest) (response *QueryFaceUserGroupAndDeviceGroupRelationResponse, err error) {
	response = CreateQueryFaceUserGroupAndDeviceGroupRelationResponse()
	err = client.DoAction(request, response)
	return
}

// QueryFaceUserGroupAndDeviceGroupRelationWithChan invokes the linkvisual.QueryFaceUserGroupAndDeviceGroupRelation API asynchronously
func (client *Client) QueryFaceUserGroupAndDeviceGroupRelationWithChan(request *QueryFaceUserGroupAndDeviceGroupRelationRequest) (<-chan *QueryFaceUserGroupAndDeviceGroupRelationResponse, <-chan error) {
	responseChan := make(chan *QueryFaceUserGroupAndDeviceGroupRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryFaceUserGroupAndDeviceGroupRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryFaceUserGroupAndDeviceGroupRelationWithCallback invokes the linkvisual.QueryFaceUserGroupAndDeviceGroupRelation API asynchronously
func (client *Client) QueryFaceUserGroupAndDeviceGroupRelationWithCallback(request *QueryFaceUserGroupAndDeviceGroupRelationRequest, callback func(response *QueryFaceUserGroupAndDeviceGroupRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryFaceUserGroupAndDeviceGroupRelationResponse
		var err error
		defer close(result)
		response, err = client.QueryFaceUserGroupAndDeviceGroupRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryFaceUserGroupAndDeviceGroupRelationRequest is the request struct for api QueryFaceUserGroupAndDeviceGroupRelation
type QueryFaceUserGroupAndDeviceGroupRelationRequest struct {
	*requests.RpcRequest
	IsolationId string `position:"Query" name:"IsolationId"`
	ControlId   string `position:"Query" name:"ControlId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// QueryFaceUserGroupAndDeviceGroupRelationResponse is the response struct for api QueryFaceUserGroupAndDeviceGroupRelation
type QueryFaceUserGroupAndDeviceGroupRelationResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Data         Data   `json:"Data" xml:"Data"`
}

// CreateQueryFaceUserGroupAndDeviceGroupRelationRequest creates a request to invoke QueryFaceUserGroupAndDeviceGroupRelation API
func CreateQueryFaceUserGroupAndDeviceGroupRelationRequest() (request *QueryFaceUserGroupAndDeviceGroupRelationRequest) {
	request = &QueryFaceUserGroupAndDeviceGroupRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryFaceUserGroupAndDeviceGroupRelation", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryFaceUserGroupAndDeviceGroupRelationResponse creates a response to parse from QueryFaceUserGroupAndDeviceGroupRelation response
func CreateQueryFaceUserGroupAndDeviceGroupRelationResponse() (response *QueryFaceUserGroupAndDeviceGroupRelationResponse) {
	response = &QueryFaceUserGroupAndDeviceGroupRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
