package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateLiveAIStudio invokes the live.CreateLiveAIStudio API synchronously
func (client *Client) CreateLiveAIStudio(request *CreateLiveAIStudioRequest) (response *CreateLiveAIStudioResponse, err error) {
	response = CreateCreateLiveAIStudioResponse()
	err = client.DoAction(request, response)
	return
}

// CreateLiveAIStudioWithChan invokes the live.CreateLiveAIStudio API asynchronously
func (client *Client) CreateLiveAIStudioWithChan(request *CreateLiveAIStudioRequest) (<-chan *CreateLiveAIStudioResponse, <-chan error) {
	responseChan := make(chan *CreateLiveAIStudioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateLiveAIStudio(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateLiveAIStudioWithCallback invokes the live.CreateLiveAIStudio API asynchronously
func (client *Client) CreateLiveAIStudioWithCallback(request *CreateLiveAIStudioRequest, callback func(response *CreateLiveAIStudioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateLiveAIStudioResponse
		var err error
		defer close(result)
		response, err = client.CreateLiveAIStudio(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateLiveAIStudioRequest is the request struct for api CreateLiveAIStudio
type CreateLiveAIStudioRequest struct {
	*requests.RpcRequest
	BackgroundResourceId  string                          `position:"Query" name:"BackgroundResourceId"`
	Description           string                          `position:"Query" name:"Description"`
	MediaLayout           CreateLiveAIStudioMediaLayout   `position:"Query" name:"MediaLayout"  type:"Struct"`
	BackgroundType        string                          `position:"Query" name:"BackgroundType"`
	MattingType           string                          `position:"Query" name:"MattingType"`
	MediaResourceUrl      string                          `position:"Query" name:"MediaResourceUrl"`
	Height                requests.Integer                `position:"Query" name:"Height"`
	BackgroundResourceUrl string                          `position:"Query" name:"BackgroundResourceUrl"`
	MediaResourceId       string                          `position:"Query" name:"MediaResourceId"`
	MattingLayout         CreateLiveAIStudioMattingLayout `position:"Query" name:"MattingLayout"  type:"Struct"`
	OwnerId               requests.Integer                `position:"Query" name:"OwnerId"`
	StudioName            string                          `position:"Query" name:"StudioName"`
	Width                 requests.Integer                `position:"Query" name:"Width"`
	MediaType             string                          `position:"Query" name:"MediaType"`
}

// CreateLiveAIStudioMediaLayout is a repeated param struct in CreateLiveAIStudioRequest
type CreateLiveAIStudioMediaLayout struct {
	PositionX        string `name:"PositionX"`
	PositionY        string `name:"PositionY"`
	HeightNormalized string `name:"HeightNormalized"`
}

// CreateLiveAIStudioMattingLayout is a repeated param struct in CreateLiveAIStudioRequest
type CreateLiveAIStudioMattingLayout struct {
	PositionX        string `name:"PositionX"`
	PositionY        string `name:"PositionY"`
	HeightNormalized string `name:"HeightNormalized"`
}

// CreateLiveAIStudioResponse is the response struct for api CreateLiveAIStudio
type CreateLiveAIStudioResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	StudioId  string `json:"StudioId" xml:"StudioId"`
}

// CreateCreateLiveAIStudioRequest creates a request to invoke CreateLiveAIStudio API
func CreateCreateLiveAIStudioRequest() (request *CreateLiveAIStudioRequest) {
	request = &CreateLiveAIStudioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateLiveAIStudio", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateLiveAIStudioResponse creates a response to parse from CreateLiveAIStudio response
func CreateCreateLiveAIStudioResponse() (response *CreateLiveAIStudioResponse) {
	response = &CreateLiveAIStudioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
