package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendLike invokes the live.SendLike API synchronously
func (client *Client) SendLike(request *SendLikeRequest) (response *SendLikeResponse, err error) {
	response = CreateSendLikeResponse()
	err = client.DoAction(request, response)
	return
}

// SendLikeWithChan invokes the live.SendLike API asynchronously
func (client *Client) SendLikeWithChan(request *SendLikeRequest) (<-chan *SendLikeResponse, <-chan error) {
	responseChan := make(chan *SendLikeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendLike(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendLikeWithCallback invokes the live.SendLike API asynchronously
func (client *Client) SendLikeWithCallback(request *SendLikeRequest, callback func(response *SendLikeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendLikeResponse
		var err error
		defer close(result)
		response, err = client.SendLike(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendLikeRequest is the request struct for api SendLike
type SendLikeRequest struct {
	*requests.RpcRequest
	OperatorUserId string           `position:"Body" name:"OperatorUserId"`
	BroadCastType  requests.Integer `position:"Body" name:"BroadCastType"`
	GroupId        string           `position:"Body" name:"GroupId"`
	Count          string           `position:"Body" name:"Count"`
	AppId          string           `position:"Body" name:"AppId"`
}

// SendLikeResponse is the response struct for api SendLike
type SendLikeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateSendLikeRequest creates a request to invoke SendLike API
func CreateSendLikeRequest() (request *SendLikeRequest) {
	request = &SendLikeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "SendLike", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSendLikeResponse creates a response to parse from SendLike response
func CreateSendLikeResponse() (response *SendLikeResponse) {
	response = &SendLikeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
