package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchUploadMPCoSPhaseDigestInfoByDevice invokes the ltl.BatchUploadMPCoSPhaseDigestInfoByDevice API synchronously
func (client *Client) BatchUploadMPCoSPhaseDigestInfoByDevice(request *BatchUploadMPCoSPhaseDigestInfoByDeviceRequest) (response *BatchUploadMPCoSPhaseDigestInfoByDeviceResponse, err error) {
	response = CreateBatchUploadMPCoSPhaseDigestInfoByDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// BatchUploadMPCoSPhaseDigestInfoByDeviceWithChan invokes the ltl.BatchUploadMPCoSPhaseDigestInfoByDevice API asynchronously
func (client *Client) BatchUploadMPCoSPhaseDigestInfoByDeviceWithChan(request *BatchUploadMPCoSPhaseDigestInfoByDeviceRequest) (<-chan *BatchUploadMPCoSPhaseDigestInfoByDeviceResponse, <-chan error) {
	responseChan := make(chan *BatchUploadMPCoSPhaseDigestInfoByDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchUploadMPCoSPhaseDigestInfoByDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchUploadMPCoSPhaseDigestInfoByDeviceWithCallback invokes the ltl.BatchUploadMPCoSPhaseDigestInfoByDevice API asynchronously
func (client *Client) BatchUploadMPCoSPhaseDigestInfoByDeviceWithCallback(request *BatchUploadMPCoSPhaseDigestInfoByDeviceRequest, callback func(response *BatchUploadMPCoSPhaseDigestInfoByDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchUploadMPCoSPhaseDigestInfoByDeviceResponse
		var err error
		defer close(result)
		response, err = client.BatchUploadMPCoSPhaseDigestInfoByDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchUploadMPCoSPhaseDigestInfoByDeviceRequest is the request struct for api BatchUploadMPCoSPhaseDigestInfoByDevice
type BatchUploadMPCoSPhaseDigestInfoByDeviceRequest struct {
	*requests.RpcRequest
	IotSignature         string                 `position:"Query" name:"IotSignature"`
	IotAuthType          string                 `position:"Query" name:"IotAuthType"`
	IotIdSource          string                 `position:"Query" name:"IotIdSource"`
	PhaseId              string                 `position:"Query" name:"PhaseId"`
	ApiVersion           string                 `position:"Query" name:"ApiVersion"`
	BizChainId           string                 `position:"Query" name:"BizChainId"`
	PhaseDataList        map[string]interface{} `position:"Query" name:"PhaseDataList"`
	IotId                string                 `position:"Query" name:"IotId"`
	PhaseGroupId         string                 `position:"Query" name:"PhaseGroupId"`
	IotDataDigest        string                 `position:"Query" name:"IotDataDigest"`
	IotIdServiceProvider string                 `position:"Query" name:"IotIdServiceProvider"`
}

// BatchUploadMPCoSPhaseDigestInfoByDeviceResponse is the response struct for api BatchUploadMPCoSPhaseDigestInfoByDevice
type BatchUploadMPCoSPhaseDigestInfoByDeviceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBatchUploadMPCoSPhaseDigestInfoByDeviceRequest creates a request to invoke BatchUploadMPCoSPhaseDigestInfoByDevice API
func CreateBatchUploadMPCoSPhaseDigestInfoByDeviceRequest() (request *BatchUploadMPCoSPhaseDigestInfoByDeviceRequest) {
	request = &BatchUploadMPCoSPhaseDigestInfoByDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "BatchUploadMPCoSPhaseDigestInfoByDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchUploadMPCoSPhaseDigestInfoByDeviceResponse creates a response to parse from BatchUploadMPCoSPhaseDigestInfoByDevice response
func CreateBatchUploadMPCoSPhaseDigestInfoByDeviceResponse() (response *BatchUploadMPCoSPhaseDigestInfoByDeviceResponse) {
	response = &BatchUploadMPCoSPhaseDigestInfoByDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
