package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProofChain invokes the ltl.ListProofChain API synchronously
func (client *Client) ListProofChain(request *ListProofChainRequest) (response *ListProofChainResponse, err error) {
	response = CreateListProofChainResponse()
	err = client.DoAction(request, response)
	return
}

// ListProofChainWithChan invokes the ltl.ListProofChain API asynchronously
func (client *Client) ListProofChainWithChan(request *ListProofChainRequest) (<-chan *ListProofChainResponse, <-chan error) {
	responseChan := make(chan *ListProofChainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProofChain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProofChainWithCallback invokes the ltl.ListProofChain API asynchronously
func (client *Client) ListProofChainWithCallback(request *ListProofChainRequest, callback func(response *ListProofChainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProofChainResponse
		var err error
		defer close(result)
		response, err = client.ListProofChain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProofChainRequest is the request struct for api ListProofChain
type ListProofChainRequest struct {
	*requests.RpcRequest
	Size       requests.Integer `position:"Query" name:"Size"`
	Num        requests.Integer `position:"Query" name:"Num"`
	Name       string           `position:"Query" name:"Name"`
	ApiVersion string           `position:"Query" name:"ApiVersion"`
}

// ListProofChainResponse is the response struct for api ListProofChain
type ListProofChainResponse struct {
	*responses.BaseResponse
	Code      int                  `json:"Code" xml:"Code"`
	Message   string               `json:"Message" xml:"Message"`
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Success   bool                 `json:"Success" xml:"Success"`
	Data      DataInListProofChain `json:"Data" xml:"Data"`
}

// CreateListProofChainRequest creates a request to invoke ListProofChain API
func CreateListProofChainRequest() (request *ListProofChainRequest) {
	request = &ListProofChainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ListProofChain", "", "")
	request.Method = requests.POST
	return
}

// CreateListProofChainResponse creates a response to parse from ListProofChain response
func CreateListProofChainResponse() (response *ListProofChainResponse) {
	response = &ListProofChainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
