package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppBySwimmingLaneGroupTags invokes the mse.ListAppBySwimmingLaneGroupTags API synchronously
func (client *Client) ListAppBySwimmingLaneGroupTags(request *ListAppBySwimmingLaneGroupTagsRequest) (response *ListAppBySwimmingLaneGroupTagsResponse, err error) {
	response = CreateListAppBySwimmingLaneGroupTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppBySwimmingLaneGroupTagsWithChan invokes the mse.ListAppBySwimmingLaneGroupTags API asynchronously
func (client *Client) ListAppBySwimmingLaneGroupTagsWithChan(request *ListAppBySwimmingLaneGroupTagsRequest) (<-chan *ListAppBySwimmingLaneGroupTagsResponse, <-chan error) {
	responseChan := make(chan *ListAppBySwimmingLaneGroupTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppBySwimmingLaneGroupTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppBySwimmingLaneGroupTagsWithCallback invokes the mse.ListAppBySwimmingLaneGroupTags API asynchronously
func (client *Client) ListAppBySwimmingLaneGroupTagsWithCallback(request *ListAppBySwimmingLaneGroupTagsRequest, callback func(response *ListAppBySwimmingLaneGroupTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppBySwimmingLaneGroupTagsResponse
		var err error
		defer close(result)
		response, err = client.ListAppBySwimmingLaneGroupTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppBySwimmingLaneGroupTagsRequest is the request struct for api ListAppBySwimmingLaneGroupTags
type ListAppBySwimmingLaneGroupTagsRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	GroupId        requests.Integer `position:"Query" name:"GroupId"`
	Tags           *[]string        `position:"Query" name:"Tags"  type:"Json"`
	Namespace      string           `position:"Query" name:"Namespace"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// ListAppBySwimmingLaneGroupTagsResponse is the response struct for api ListAppBySwimmingLaneGroupTags
type ListAppBySwimmingLaneGroupTagsResponse struct {
	*responses.BaseResponse
}

// CreateListAppBySwimmingLaneGroupTagsRequest creates a request to invoke ListAppBySwimmingLaneGroupTags API
func CreateListAppBySwimmingLaneGroupTagsRequest() (request *ListAppBySwimmingLaneGroupTagsRequest) {
	request = &ListAppBySwimmingLaneGroupTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListAppBySwimmingLaneGroupTags", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAppBySwimmingLaneGroupTagsResponse creates a response to parse from ListAppBySwimmingLaneGroupTags response
func CreateListAppBySwimmingLaneGroupTagsResponse() (response *ListAppBySwimmingLaneGroupTagsResponse) {
	response = &ListAppBySwimmingLaneGroupTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
