package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataFlows invokes the nas.DescribeDataFlows API synchronously
func (client *Client) DescribeDataFlows(request *DescribeDataFlowsRequest) (response *DescribeDataFlowsResponse, err error) {
	response = CreateDescribeDataFlowsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDataFlowsWithChan invokes the nas.DescribeDataFlows API asynchronously
func (client *Client) DescribeDataFlowsWithChan(request *DescribeDataFlowsRequest) (<-chan *DescribeDataFlowsResponse, <-chan error) {
	responseChan := make(chan *DescribeDataFlowsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataFlows(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataFlowsWithCallback invokes the nas.DescribeDataFlows API asynchronously
func (client *Client) DescribeDataFlowsWithCallback(request *DescribeDataFlowsRequest, callback func(response *DescribeDataFlowsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataFlowsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDataFlows(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataFlowsRequest is the request struct for api DescribeDataFlows
type DescribeDataFlowsRequest struct {
	*requests.RpcRequest
	NextToken    string                      `position:"Query" name:"NextToken"`
	FileSystemId string                      `position:"Query" name:"FileSystemId"`
	Filters      *[]DescribeDataFlowsFilters `position:"Query" name:"Filters"  type:"Repeated"`
	MaxResults   requests.Integer            `position:"Query" name:"MaxResults"`
}

// DescribeDataFlowsFilters is a repeated param struct in DescribeDataFlowsRequest
type DescribeDataFlowsFilters struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// DescribeDataFlowsResponse is the response struct for api DescribeDataFlows
type DescribeDataFlowsResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	NextToken    string       `json:"NextToken" xml:"NextToken"`
	DataFlowInfo DataFlowInfo `json:"DataFlowInfo" xml:"DataFlowInfo"`
}

// CreateDescribeDataFlowsRequest creates a request to invoke DescribeDataFlows API
func CreateDescribeDataFlowsRequest() (request *DescribeDataFlowsRequest) {
	request = &DescribeDataFlowsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "DescribeDataFlows", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDataFlowsResponse creates a response to parse from DescribeDataFlows response
func CreateDescribeDataFlowsResponse() (response *DescribeDataFlowsResponse) {
	response = &DescribeDataFlowsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
