package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFunctionTasks invokes the opensearch.ListFunctionTasks API synchronously
func (client *Client) ListFunctionTasks(request *ListFunctionTasksRequest) (response *ListFunctionTasksResponse, err error) {
	response = CreateListFunctionTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListFunctionTasksWithChan invokes the opensearch.ListFunctionTasks API asynchronously
func (client *Client) ListFunctionTasksWithChan(request *ListFunctionTasksRequest) (<-chan *ListFunctionTasksResponse, <-chan error) {
	responseChan := make(chan *ListFunctionTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFunctionTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFunctionTasksWithCallback invokes the opensearch.ListFunctionTasks API asynchronously
func (client *Client) ListFunctionTasksWithCallback(request *ListFunctionTasksRequest, callback func(response *ListFunctionTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFunctionTasksResponse
		var err error
		defer close(result)
		response, err = client.ListFunctionTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFunctionTasksRequest is the request struct for api ListFunctionTasks
type ListFunctionTasksRequest struct {
	*requests.RoaRequest
	InstanceName     string           `position:"Path" name:"instanceName"`
	FunctionName     string           `position:"Path" name:"functionName"`
	PageSize         requests.Integer `position:"Query" name:"pageSize"`
	EndTime          requests.Integer `position:"Query" name:"endTime"`
	StartTime        requests.Integer `position:"Query" name:"startTime"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
	PageNumber       requests.Integer `position:"Query" name:"pageNumber"`
	Status           string           `position:"Query" name:"status"`
}

// ListFunctionTasksResponse is the response struct for api ListFunctionTasks
type ListFunctionTasksResponse struct {
	*responses.BaseResponse
	Status     string                          `json:"Status" xml:"Status"`
	HttpCode   int64                           `json:"HttpCode" xml:"HttpCode"`
	TotalCount int64                           `json:"TotalCount" xml:"TotalCount"`
	RequestId  string                          `json:"RequestId" xml:"RequestId"`
	Message    string                          `json:"Message" xml:"Message"`
	Code       string                          `json:"Code" xml:"Code"`
	Latency    int64                           `json:"Latency" xml:"Latency"`
	Result     []ResultItemInListFunctionTasks `json:"Result" xml:"Result"`
}

// CreateListFunctionTasksRequest creates a request to invoke ListFunctionTasks API
func CreateListFunctionTasksRequest() (request *ListFunctionTasksRequest) {
	request = &ListFunctionTasksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListFunctionTasks", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/instances/[instanceName]/tasks", "", "")
	request.Method = requests.GET
	return
}

// CreateListFunctionTasksResponse creates a response to parse from ListFunctionTasks response
func CreateListFunctionTasksResponse() (response *ListFunctionTasksResponse) {
	response = &ListFunctionTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
