package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindEsInstance invokes the opensearch.UnbindEsInstance API synchronously
func (client *Client) UnbindEsInstance(request *UnbindEsInstanceRequest) (response *UnbindEsInstanceResponse, err error) {
	response = CreateUnbindEsInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindEsInstanceWithChan invokes the opensearch.UnbindEsInstance API asynchronously
func (client *Client) UnbindEsInstanceWithChan(request *UnbindEsInstanceRequest) (<-chan *UnbindEsInstanceResponse, <-chan error) {
	responseChan := make(chan *UnbindEsInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindEsInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindEsInstanceWithCallback invokes the opensearch.UnbindEsInstance API asynchronously
func (client *Client) UnbindEsInstanceWithCallback(request *UnbindEsInstanceRequest, callback func(response *UnbindEsInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindEsInstanceResponse
		var err error
		defer close(result)
		response, err = client.UnbindEsInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindEsInstanceRequest is the request struct for api UnbindEsInstance
type UnbindEsInstanceRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// UnbindEsInstanceResponse is the response struct for api UnbindEsInstance
type UnbindEsInstanceResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateUnbindEsInstanceRequest creates a request to invoke UnbindEsInstance API
func CreateUnbindEsInstanceRequest() (request *UnbindEsInstanceRequest) {
	request = &UnbindEsInstanceRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UnbindEsInstance", "/v4/openapi/app-groups/[appGroupIdentity]/actions/unbind-es-instance", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindEsInstanceResponse creates a response to parse from UnbindEsInstance response
func CreateUnbindEsInstanceResponse() (response *UnbindEsInstanceResponse) {
	response = &UnbindEsInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
