package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAllNumberDistrictInfo invokes the outboundbot.DeleteAllNumberDistrictInfo API synchronously
func (client *Client) DeleteAllNumberDistrictInfo(request *DeleteAllNumberDistrictInfoRequest) (response *DeleteAllNumberDistrictInfoResponse, err error) {
	response = CreateDeleteAllNumberDistrictInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAllNumberDistrictInfoWithChan invokes the outboundbot.DeleteAllNumberDistrictInfo API asynchronously
func (client *Client) DeleteAllNumberDistrictInfoWithChan(request *DeleteAllNumberDistrictInfoRequest) (<-chan *DeleteAllNumberDistrictInfoResponse, <-chan error) {
	responseChan := make(chan *DeleteAllNumberDistrictInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAllNumberDistrictInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAllNumberDistrictInfoWithCallback invokes the outboundbot.DeleteAllNumberDistrictInfo API asynchronously
func (client *Client) DeleteAllNumberDistrictInfoWithCallback(request *DeleteAllNumberDistrictInfoRequest, callback func(response *DeleteAllNumberDistrictInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAllNumberDistrictInfoResponse
		var err error
		defer close(result)
		response, err = client.DeleteAllNumberDistrictInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAllNumberDistrictInfoRequest is the request struct for api DeleteAllNumberDistrictInfo
type DeleteAllNumberDistrictInfoRequest struct {
	*requests.RpcRequest
}

// DeleteAllNumberDistrictInfoResponse is the response struct for api DeleteAllNumberDistrictInfo
type DeleteAllNumberDistrictInfoResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeleteAllNumberDistrictInfoRequest creates a request to invoke DeleteAllNumberDistrictInfo API
func CreateDeleteAllNumberDistrictInfoRequest() (request *DeleteAllNumberDistrictInfoRequest) {
	request = &DeleteAllNumberDistrictInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DeleteAllNumberDistrictInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAllNumberDistrictInfoResponse creates a response to parse from DeleteAllNumberDistrictInfo response
func CreateDeleteAllNumberDistrictInfoResponse() (response *DeleteAllNumberDistrictInfoResponse) {
	response = &DeleteAllNumberDistrictInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
