package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeScript invokes the outboundbot.DescribeScript API synchronously
func (client *Client) DescribeScript(request *DescribeScriptRequest) (response *DescribeScriptResponse, err error) {
	response = CreateDescribeScriptResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeScriptWithChan invokes the outboundbot.DescribeScript API asynchronously
func (client *Client) DescribeScriptWithChan(request *DescribeScriptRequest) (<-chan *DescribeScriptResponse, <-chan error) {
	responseChan := make(chan *DescribeScriptResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeScript(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeScriptWithCallback invokes the outboundbot.DescribeScript API asynchronously
func (client *Client) DescribeScriptWithCallback(request *DescribeScriptRequest, callback func(response *DescribeScriptResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeScriptResponse
		var err error
		defer close(result)
		response, err = client.DescribeScript(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeScriptRequest is the request struct for api DescribeScript
type DescribeScriptRequest struct {
	*requests.RpcRequest
	ScriptId   string `position:"Query" name:"ScriptId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeScriptResponse is the response struct for api DescribeScript
type DescribeScriptResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	ChatbotId      string `json:"ChatbotId" xml:"ChatbotId"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	TtsConfig      string `json:"TtsConfig" xml:"TtsConfig"`
	AsrConfig      string `json:"AsrConfig" xml:"AsrConfig"`
	NlsConfig      string `json:"NlsConfig" xml:"NlsConfig"`
	Script         Script `json:"Script" xml:"Script"`
}

// CreateDescribeScriptRequest creates a request to invoke DescribeScript API
func CreateDescribeScriptRequest() (request *DescribeScriptRequest) {
	request = &DescribeScriptRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeScript", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeScriptResponse creates a response to parse from DescribeScript response
func CreateDescribeScriptResponse() (response *DescribeScriptResponse) {
	response = &DescribeScriptResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
