package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateResourceRuleItem invokes the pairecservice.UpdateResourceRuleItem API synchronously
func (client *Client) UpdateResourceRuleItem(request *UpdateResourceRuleItemRequest) (response *UpdateResourceRuleItemResponse, err error) {
	response = CreateUpdateResourceRuleItemResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateResourceRuleItemWithChan invokes the pairecservice.UpdateResourceRuleItem API asynchronously
func (client *Client) UpdateResourceRuleItemWithChan(request *UpdateResourceRuleItemRequest) (<-chan *UpdateResourceRuleItemResponse, <-chan error) {
	responseChan := make(chan *UpdateResourceRuleItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateResourceRuleItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateResourceRuleItemWithCallback invokes the pairecservice.UpdateResourceRuleItem API asynchronously
func (client *Client) UpdateResourceRuleItemWithCallback(request *UpdateResourceRuleItemRequest, callback func(response *UpdateResourceRuleItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateResourceRuleItemResponse
		var err error
		defer close(result)
		response, err = client.UpdateResourceRuleItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateResourceRuleItemRequest is the request struct for api UpdateResourceRuleItem
type UpdateResourceRuleItemRequest struct {
	*requests.RoaRequest
	Body               string `position:"Body" name:"body"`
	ResourceRuleId     string `position:"Path" name:"ResourceRuleId"`
	ResourceRuleItemId string `position:"Path" name:"ResourceRuleItemId"`
}

// UpdateResourceRuleItemResponse is the response struct for api UpdateResourceRuleItem
type UpdateResourceRuleItemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateResourceRuleItemRequest creates a request to invoke UpdateResourceRuleItem API
func CreateUpdateResourceRuleItemRequest() (request *UpdateResourceRuleItemRequest) {
	request = &UpdateResourceRuleItemRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateResourceRuleItem", "/api/v1/resourcerules/[ResourceRuleId]/items/[ResourceRuleItemId]", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateResourceRuleItemResponse creates a response to parse from UpdateResourceRuleItem response
func CreateUpdateResourceRuleItemResponse() (response *UpdateResourceRuleItemResponse) {
	response = &UpdateResourceRuleItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
